/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SecureReader
implements PrivilegedAction {
    protected InputStream iStream = null;
    protected static boolean libraryLoaded = false;

    protected static void loadLibrary() {
        try {
            System.loadLibrary("provutil");
            libraryLoaded = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Object run() {
        if (!libraryLoaded) {
            SecureReader.loadLibrary();
        }
        if (this.iStream == null) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.iStream));
            this.echoOff();
            String string = bufferedReader.readLine();
            this.echoOn();
            return string;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static String readLine(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        SecureReader secureReader = new SecureReader();
        secureReader.iStream = inputStream;
        try {
            Object t = AccessController.doPrivileged(secureReader);
            return (String)t;
        }
        catch (Throwable throwable) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                return bufferedReader.readLine();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    protected void echoOff() {
        if (libraryLoaded) {
            SecureReader.doEchoOff();
        }
    }

    protected void echoOn() {
        if (libraryLoaded) {
            SecureReader.doEchoOn();
        }
    }

    protected static native void doEchoOff();

    protected static native void doEchoOn();
}

