/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.UnixDomainSocket;
import java.io.FileInputStream;
import java.io.IOException;

class UnixDomainSocketInputStream
extends FileInputStream {
    private boolean eof;
    private UnixDomainSocket impl;
    private byte[] temp = new byte[1];

    private static native void init();

    private native int socketRead(byte[] var1, int var2, int var3) throws IOException;

    UnixDomainSocketInputStream(UnixDomainSocket unixDomainSocket) throws IOException {
        super(unixDomainSocket.getFileDescriptor());
        this.impl = unixDomainSocket;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.socketRead(byArray, n, n2);
        if (n3 <= 0) {
            this.eof = true;
            return -1;
        }
        return n3;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        long l2 = l;
        int n = (int)Math.min(1024L, l2);
        byte[] byArray = new byte[n];
        while (l2 > 0L) {
            int n2 = this.read(byArray, 0, (int)Math.min((long)n, l2));
            if (n2 < 0) break;
            l2 -= (long)n2;
        }
        return l - l2;
    }

    public int available() throws IOException {
        return this.impl.available();
    }

    public void close() throws IOException {
        this.impl.close();
    }

    protected void finalize() {
    }

    static {
        UnixDomainSocketInputStream.init();
    }
}

