/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.VException;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticationUtil;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestAuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestMessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import java.net.InetAddress;

public class DigestServerSecurityContext
extends ServerSecurityContext {
    private boolean signing;
    private boolean integrity = false;
    private byte[] clientkey = null;
    private byte[] serverchg = null;
    private byte[] clientchg = null;
    private byte[] sessionkey = null;
    private byte[] hashpswd = null;
    private byte[] salt = null;
    private String username = null;
    private String userpswd = null;
    private static boolean ssl_enabled = true;
    private static String is_ssl = null;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestServerSecurityContext(DigestAuthFlavor digestAuthFlavor) throws AuthenticationException {
        super(digestAuthFlavor);
        if (is_ssl == null && !(is_ssl = System.getProperty("sun.smc.internal.ssl.enable", "yes")).equals("yes")) {
            ssl_enabled = false;
        }
    }

    public boolean verifyAuthFlavor(AuthenticationFlavor authenticationFlavor) throws AuthenticationException {
        boolean bl = true;
        boolean bl2 = false;
        DigestAuthFlavor digestAuthFlavor = null;
        try {
            digestAuthFlavor = (DigestAuthFlavor)authenticationFlavor;
        }
        catch (Exception exception) {
            this.writeLog(400, "LMS_SecurityError", "LMD_AuthTypeMismatch", authenticationFlavor.getAuthTypeName(), "Digest");
            bl = false;
        }
        DigestAuthFlavor digestAuthFlavor2 = (DigestAuthFlavor)this.getAuthFlavor();
        while (bl) {
            if (digestAuthFlavor.getAuthType() != 0) {
                this.writeLog(400, "LMS_SecurityError", "LMD_AuthTypeMismatch", digestAuthFlavor.getAuthTypeName(), "Digest");
                break;
            }
            if (!digestAuthFlavor2.getDigestAlgorithm().equals(digestAuthFlavor.getDigestAlgorithm())) {
                this.writeLog(400, "LMS_SecurityError", "LMD_DigestAlgoMismatch", digestAuthFlavor.getDigestAlgorithm(), digestAuthFlavor2.getDigestAlgorithm());
                break;
            }
            if (!digestAuthFlavor2.getSignatureAlgorithm().equals(digestAuthFlavor.getSignatureAlgorithm())) {
                this.writeLog(400, "LMS_SecurityError", "LMD_SignAlgoMismatch", digestAuthFlavor.getSignatureAlgorithm(), digestAuthFlavor2.getSignatureAlgorithm());
                break;
            }
            if (!digestAuthFlavor2.getKeyGenerationAlgorithm().equals(digestAuthFlavor.getKeyGenerationAlgorithm())) {
                this.writeLog(400, "LMS_SecurityError", "LMD_KeyAlgoMismatch", digestAuthFlavor.getKeyGenerationAlgorithm(), digestAuthFlavor2.getKeyGenerationAlgorithm());
                break;
            }
            if (digestAuthFlavor2.getKeyStrength() != digestAuthFlavor.getKeyStrength()) {
                this.writeLog(400, "LMS_SecurityError", "LMD_KeySizeMismatch", new Integer(digestAuthFlavor.getKeyStrength()).toString(), new Integer(digestAuthFlavor2.getKeyStrength()).toString());
                break;
            }
            bl2 = true;
            bl = false;
        }
        if (!bl2) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication flavor mismatch", null);
        }
        return bl2;
    }

    public ResponseSecurityToken verifyRequestToken(RequestSecurityToken requestSecurityToken) throws AuthenticationException {
        this.clientkey = null;
        this.serverchg = null;
        this.clientchg = null;
        this.sessionkey = null;
        this.hashpswd = null;
        this.username = null;
        this.userpswd = null;
        this.salt = null;
        RequestSecurityToken requestSecurityToken2 = requestSecurityToken;
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying authentication request...", null);
        String string = null;
        int n = -1;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AuthenticationPrincipal authenticationPrincipal = requestSecurityToken2.getAuthPrincipal();
        if (authenticationPrincipal != (AuthenticationPrincipal)null) {
            this.username = authenticationPrincipal.getName();
            if (this.username != (String)null) {
                try {
                    string = AuthenticationLibrary.getPassword(this.username);
                    if (string == null) {
                        throw new AuthenticationLoginException();
                    }
                    n = Integer.parseInt(AuthenticationLibrary.getUid(this.username));
                    n2 = Integer.parseInt(AuthenticationLibrary.getGid(this.username));
                    string2 = AuthenticationLibrary.getHomedir(this.username);
                    string3 = AuthenticationLibrary.getShell(this.username);
                }
                catch (Exception exception) {
                    Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("cannot get user \"" + this.username + "\" account info"), (Throwable)exception);
                }
                if (string == null || string.trim().length() == 0) {
                    Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)("Cannot access user password for " + this.username), null);
                    this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadUser", this.username, requestSecurityToken2.getClientHost());
                    this.auditBadUser(requestSecurityToken2.getClientHost(), this.username);
                    throw new AuthenticationLoginException();
                }
                string4 = string.substring(0, 2);
            } else {
                authenticationPrincipal = null;
            }
        }
        if (authenticationPrincipal == (AuthenticationPrincipal)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Null or invalid admin principal identity", null);
            throw new AuthenticationException("EXSS_BUI");
        }
        this.hashpswd = string.getBytes();
        this.salt = string4.getBytes();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   Client user identity=" + this.username), null);
        this.serverchg = new byte[16];
        DigestSecurityUtil.getRandomBytes(this.serverchg);
        byte[] byArray = new byte[32];
        DigestSecurityUtil.getRandomBytes(byArray);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   challenge=" + this.toHex(this.serverchg)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   salt=" + string4), null);
        DigestResponseSecurityToken digestResponseSecurityToken = new DigestResponseSecurityToken(this.getSecurityId());
        digestResponseSecurityToken.setChallenge(this.serverchg);
        digestResponseSecurityToken.setPasswordSalt(this.salt);
        digestResponseSecurityToken.setServerKey(byArray);
        this.setAuthPrincipal(authenticationPrincipal);
        this.setUid(n);
        this.setGid(n2);
        this.setHome(string2);
        this.setShell(string3);
        this.setClientHost(requestSecurityToken2.getClientHost());
        this.setAuthState(2);
        return digestResponseSecurityToken;
    }

    public ConfirmSecurityToken verifyAuthenticatorToken(AuthenticatorSecurityToken authenticatorSecurityToken) throws AuthenticationException {
        String string;
        byte[] byArray;
        byte[] byArray2;
        DigestAuthenticatorSecurityToken digestAuthenticatorSecurityToken = null;
        try {
            digestAuthenticatorSecurityToken = (DigestAuthenticatorSecurityToken)authenticatorSecurityToken;
        }
        catch (Exception exception) {
            this.writeLog(400, "LMS_SecurityError", "LMD_BadAuthToken");
            throw new AuthenticationException("EXSS_BAT");
        }
        byte[] byArray3 = digestAuthenticatorSecurityToken.getMessageDigest();
        byte[] byArray4 = digestAuthenticatorSecurityToken.getAuthenticatorDigest();
        byte[] byArray5 = digestAuthenticatorSecurityToken.getSessionDigest();
        this.clientchg = digestAuthenticatorSecurityToken.getChallenge();
        this.clientkey = digestAuthenticatorSecurityToken.getClientKey();
        AuthenticationPrincipal authenticationPrincipal = this.getAuthPrincipal();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying authenticator...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   msg digest=" + this.toHex(byArray3)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   auth digest=" + this.toHex(byArray4)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   sess digest=" + this.toHex(byArray5)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   client chal=" + this.toHex(this.clientchg)), null);
        if (!ssl_enabled) {
            byArray2 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
            try {
                byArray = DigestSecurityUtil.decryptPassword(byArray2, byArray3);
            }
            catch (VException vException) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (1)", (Throwable)vException);
                this.clientkey = null;
                String string2 = authenticationPrincipal.getUserName();
                if (authenticationPrincipal.getRoleName() != null) {
                    string2 = string2 + " (in role " + authenticationPrincipal.getRoleName() + ")";
                }
                this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadPwd", string2, this.getClientHost());
                this.auditBadPasswd(this.getClientHost(), authenticationPrincipal.getName());
                throw new AuthenticationLoginException();
            }
            this.userpswd = AuthenticationUtil.hashPassword(new String(byArray));
            try {
                this.sessionkey = DigestSecurityUtil.encryptDigest(byArray5, byArray2);
            }
            catch (VException vException) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (2)", (Throwable)vException);
                this.clientkey = null;
                this.username = null;
                this.userpswd = null;
                String string3 = authenticationPrincipal.getUserName();
                if (authenticationPrincipal.getRoleName() != null) {
                    string3 = string3 + " (in role " + authenticationPrincipal.getRoleName() + ")";
                }
                this.writeLog(100, "LMS_LoginFailed", "LMD_DecryptSKeyFailed", string3);
                throw new AuthenticationLoginException();
            }
        }
        byArray = byArray3;
        this.sessionkey = byArray5;
        this.userpswd = AuthenticationUtil.hashPassword(new String(byArray));
        byte[] byArray6 = this.clientkey;
        byArray2 = DigestSecurityUtil.generateDigest(byArray3, byArray6, byArray);
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        if (!DigestSecurityUtil.compareDigests(byArray4, byArray2)) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (3)", null);
            this.clientkey = null;
            this.username = null;
            this.userpswd = null;
            this.sessionkey = null;
            String string4 = authenticationPrincipal.getUserName();
            if (authenticationPrincipal.getRoleName() != null) {
                string4 = string4 + " (in role " + authenticationPrincipal.getRoleName() + ")";
            }
            this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadPwd", string4, this.getClientHost());
            this.auditBadPasswd(this.getClientHost(), authenticationPrincipal.getName());
            throw new AuthenticationLoginException();
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Authenticator digest is verified!", null);
        String string5 = string = this.username.equals(authenticationPrincipal.getUserName()) ? null : authenticationPrincipal.getUserName();
        if (AuthenticationLibrary.doPamAuthentication(this.username, string, AuthenticationUtil.unhashPassword(this.userpswd)) != 0) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (4)", null);
            this.clientkey = null;
            this.username = null;
            this.userpswd = null;
            this.sessionkey = null;
            String string6 = authenticationPrincipal.getUserName();
            if (authenticationPrincipal.getRoleName() != null) {
                string6 = string6 + " (in role " + authenticationPrincipal.getRoleName() + ")";
            }
            this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadOthers", string6, this.getClientHost());
            throw new AuthenticationLoginException();
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"User authenticated to Solaris", null);
        byte[] byArray7 = "success".getBytes();
        byte[] byArray8 = !ssl_enabled ? DigestSecurityUtil.generateDigest(this.clientchg, this.hashpswd, byArray7) : DigestSecurityUtil.generateDigest(this.clientchg, this.userpswd.getBytes(), byArray7);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   result digest=" + this.toHex(byArray8)), null);
        AuthenticationPrincipal[] authenticationPrincipalArray = null;
        String[] stringArray = AuthenticationLibrary.getRoleNames(this.username);
        if (stringArray != null) {
            authenticationPrincipalArray = new AuthenticationPrincipal[stringArray.length];
            String string7 = null;
            try {
                string7 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                authenticationPrincipalArray[n2] = new AuthenticationPrincipal(0, this.username, stringArray[n2]);
                authenticationPrincipalArray[n2].setUserDesc(AuthenticationLibrary.getDesc(this.username));
                authenticationPrincipalArray[n2].setRoleDesc(AuthenticationLibrary.getDesc(stringArray[n2]));
                if (string7 != null) {
                    authenticationPrincipalArray[n2].setHostName(string7);
                }
                Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("role[" + n2 + "]=" + authenticationPrincipalArray[n2]), null);
                ++n2;
            }
        }
        DigestConfirmSecurityToken digestConfirmSecurityToken = new DigestConfirmSecurityToken(this.getSecurityId(), authenticationPrincipalArray);
        digestConfirmSecurityToken.setHeartbeatPeriod(this.getHeartbeatPeriod());
        digestConfirmSecurityToken.setResultMessage("success");
        digestConfirmSecurityToken.setMessageDigest(byArray8);
        if (this.isIntegrityRequired()) {
            digestConfirmSecurityToken.setIntegrity();
        }
        this.setAuthState(4);
        this.auditAuthSuccess(this.getClientHost(), this.username, this.getSecurityId());
        return digestConfirmSecurityToken;
    }

    public void verifyMessageToken(MessageSecurityToken messageSecurityToken, Object[] objectArray) throws AuthenticationException {
        byte[] byArray;
        byte[] byArray2;
        DigestMessageSecurityToken digestMessageSecurityToken;
        try {
            digestMessageSecurityToken = (DigestMessageSecurityToken)messageSecurityToken;
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_BVT");
        }
        byte[] byArray3 = this.serverchg;
        if (this.isIntegrityRequired() && objectArray != null && objectArray.length > 0) {
            byArray3 = DigestSecurityUtil.generateDigest(objectArray);
        }
        if ((byArray2 = DigestSecurityUtil.encryptDigest(byArray = digestMessageSecurityToken.getDigest(), this.sessionkey)) == null) {
            throw new AuthenticationException("EXSS_BVD");
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying message...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   server digest=" + this.toHex(byArray3)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   client digest=" + this.toHex(byArray2)), null);
        if (!DigestSecurityUtil.compareDigests(byArray3, byArray2)) {
            throw new AuthenticationMessageException();
        }
    }

    public String decryptPassword(byte[] byArray) throws AuthenticationException {
        byte[] byArray2;
        if (this.getAuthState() != 4) {
            throw new AuthenticationException("EXSS_NAX", (Object)"encryptPassword");
        }
        byte[] byArray3 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        try {
            byArray2 = DigestSecurityUtil.decryptPassword(byArray3, byArray);
        }
        catch (VException vException) {
            throw new AuthenticationException("EXSS_BEP");
        }
        String string = new String(byArray2);
        return string;
    }

    public ServerSecurityContext newCopy() throws AuthenticationException {
        DigestServerSecurityContext digestServerSecurityContext = new DigestServerSecurityContext((DigestAuthFlavor)this.getAuthFlavor());
        super.copyAttrs(digestServerSecurityContext);
        digestServerSecurityContext.setClientKey(this.clientkey);
        digestServerSecurityContext.setServerChallenge(this.serverchg);
        digestServerSecurityContext.setClientChallenge(this.clientchg);
        digestServerSecurityContext.setPasswordHash(this.hashpswd);
        digestServerSecurityContext.setPasswordSalt(this.salt);
        digestServerSecurityContext.setUserPassword(this.userpswd);
        if (this.integrity) {
            digestServerSecurityContext.setIntegrity();
        }
        return digestServerSecurityContext;
    }

    public byte[] getClientKey() {
        return this.clientkey;
    }

    public void setClientKey(byte[] byArray) {
        this.clientkey = byArray;
    }

    public void setServerChallenge(byte[] byArray) {
        if (byArray != null) {
            this.serverchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.serverchg, 0, byArray.length);
        } else {
            this.serverchg = null;
        }
    }

    public void setClientChallenge(byte[] byArray) {
        if (byArray != null) {
            this.clientchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.clientchg, 0, byArray.length);
        } else {
            this.clientchg = null;
        }
    }

    public void setPasswordHash(byte[] byArray) {
        if (byArray != null) {
            this.hashpswd = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.hashpswd, 0, byArray.length);
        } else {
            this.hashpswd = null;
        }
    }

    public void setPasswordSalt(byte[] byArray) {
        if (byArray != null) {
            this.salt = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
        } else {
            this.salt = null;
        }
    }

    public void setUserPassword(String string) {
        this.userpswd = string != null ? new String(string) : null;
    }

    public boolean isIntegrityRequired() {
        return this.integrity & this.isVerify();
    }

    public void setIntegrity() {
        this.integrity = true;
    }

    private String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        if (byArray == null) {
            return "(null)";
        }
        if (byArray.length == 0) {
            return "(empty)";
        }
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

