/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.VIdentity;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceContainer;
import com.sun.management.viperimpl.VCallerImpl;
import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.util.Date;
import java.util.Vector;

public class ServiceInstance {
    private ServiceContainer container = null;
    private ServiceAgent agent = null;
    private Vector users = null;
    private Date createdTime = null;
    private RemoteStub stub = null;

    public ServiceInstance(ServiceContainer serviceContainer, ServiceAgent serviceAgent, VCallerImpl vCallerImpl) {
        this.container = serviceContainer;
        this.agent = serviceAgent;
        try {
            this.stub = (RemoteStub)RemoteObject.toStub((Remote)((Object)this.container));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.users = new Vector();
        if (vCallerImpl != null) {
            this.users.addElement(vCallerImpl);
        }
        this.createdTime = new Date();
    }

    protected ServiceContainer getContainer() {
        return this.container;
    }

    public VCallerImpl[] getAllUsers() {
        VCallerImpl[] vCallerImplArray = new VCallerImpl[this.users.size()];
        int n = 0;
        while (n < vCallerImplArray.length) {
            vCallerImplArray[n] = (VCallerImpl)((Object)this.users.elementAt(n));
            ++n;
        }
        return vCallerImplArray;
    }

    protected ServiceAgent newAgent(VCallerImpl vCallerImpl) {
        ServiceAgent serviceAgent = null;
        if (vCallerImpl != null) {
            int n = 0;
            while (n < this.users.size()) {
                if (vCallerImpl.equals((VIdentity)this.users.elementAt(n))) break;
                ++n;
            }
            if (n == this.users.size()) {
                this.users.addElement(vCallerImpl);
            }
            try {
                serviceAgent = (ServiceAgent)this.agent.getClass().newInstance();
                serviceAgent.setContainer(this.stub);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                serviceAgent = null;
            }
        }
        return serviceAgent;
    }

    public Date getCreatedTime() {
        return (Date)this.createdTime.clone();
    }

    public Date getLastAccessTime() {
        return this.container.getLastAccessTime();
    }

    public VIdentity getLastAccessUser() {
        return this.container.getLastAccessId();
    }
}

