/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.VPermission;
import com.sun.management.viper.VPolicy;
import com.sun.management.viperimpl.util.ResourceStringReader;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class PolicyAdder {
    public static final int SUCCESS = 0;
    public static final int INVALID_USAGE = 1;
    public static final int INVALID_POLICY = 2;
    public static final int NOPERMISSION = 3;
    private static final String AUTH_ATTR_FILE = "/etc/security/auth_attr";
    private static final String AUTH_HELP_DIR = "/usr/lib/help/auths/locale";
    private static final String PROF_ATTR_FILE = "/etc/security/prof_attr";
    private static final String PROF_HELP_DIR = "/usr/lib/help/profiles/locale";
    private static final String RESOURCE_BUNDLE = "com.sun.management.viperimpl.server.repository.RepositoryServiceResources";
    private static String currentFile = null;
    private static ResourceStringReader resource = null;

    public static void main(String[] stringArray) {
        resource = new ResourceStringReader(RESOURCE_BUNDLE);
        if (stringArray.length != 1) {
            System.err.println(resource.getString("BadUsage"));
            System.exit(1);
        }
        VPolicy vPolicy = null;
        try {
            vPolicy = (VPolicy)Class.forName(stringArray[0]).newInstance();
        }
        catch (Exception exception) {
            System.err.println(resource.getString("BadPolicyClass") + ": " + exception.getLocalizedMessage());
            System.exit(2);
        }
        VPermission[] vPermissionArray = vPolicy.getPermissions();
        if (vPermissionArray != null && vPermissionArray.length > 0) {
            Object object;
            Object object2;
            int n = 0;
            String string = "";
            int n2 = 0;
            while (n2 < vPermissionArray.length) {
                if (!PolicyAdder.isDuplicated(vPermissionArray[n2])) {
                    String string2;
                    object2 = PolicyAdder.toAuthAttrRow(vPermissionArray[n2]);
                    string = string + (String)object2 + "\n";
                    ++n;
                    System.err.println(resource.getString("VerifyingPermission", vPermissionArray[n2].getName()));
                    object = vPermissionArray[n2].getHelpDir();
                    if (object == null || ((String)object).trim().length() == 0) {
                        object = ".";
                    }
                    if ((string2 = vPermissionArray[n2].getHelpFile()) != null && string2.trim().length() > 0) {
                        System.out.println("/usr/lib/help/auths/locale\t" + (String)object + "\t" + string2);
                    }
                } else {
                    System.err.println(resource.getString("SkipPermission", vPermissionArray[n2].getName()));
                }
                ++n2;
            }
            if (n > 0) {
                try {
                    object2 = new FileOutputStream(AUTH_ATTR_FILE, true);
                    object = new PrintWriter((OutputStream)object2);
                    ((PrintWriter)object).print("# Automatically added by SMC\n" + string);
                    ((PrintWriter)object).close();
                    ((FileOutputStream)object2).close();
                }
                catch (IOException iOException) {
                    System.err.println(resource.getString("CannotUpdateAttr") + ": " + iOException.getLocalizedMessage());
                    System.exit(3);
                }
            }
        }
        System.exit(0);
    }

    private static boolean isDuplicated(VPermission vPermission) {
        if (vPermission == null || vPermission.getName() == null || vPermission.getName().length() == 0) {
            return true;
        }
        if (currentFile == null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(AUTH_ATTR_FILE));
                currentFile = "";
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    currentFile = currentFile + "^" + string.trim();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println(resource.getString("CannotReadAttr") + " :" + iOException.getLocalizedMessage());
                System.exit(3);
            }
        }
        return currentFile.indexOf("^" + vPermission.getName()) >= 0;
    }

    private static String toAuthAttrRow(VPermission vPermission) {
        return vPermission.getName() + ":::" + (vPermission.getShortDesc() == null ? "" : vPermission.getShortDesc()) + "::" + (vPermission.getHelpFile() == null ? "" : "help=" + vPermission.getHelpFile());
    }
}

