/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.rmic2.Main;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.util.ResourceStringReader;
import com.sun.management.viperimpl.xml.viperbean.DescriptorManager;
import java.io.File;

public class InfoAdder {
    private static final int R_OPTION = 2;
    private static final int A_OPTION = 3;
    private static final int P_OPTION = 4;
    static final String RESOURCE_BUNDLE = "com.sun.management.viperimpl.server.repository.RepositoryServiceResources";
    private static ResourceStringReader resource;

    public static void usage() {
        System.out.println("InfoAdder -R <info_xml>");
        System.out.println("-or-");
        System.out.println("InfoAdder -A <bean_class> <base_jar_name>");
        System.out.println("-or-");
        System.out.println("InfoAdder -P <key=value> <pseudo-beanname> <lib.jar> ");
        System.out.println("For example:");
        System.out.println("\tInfoAdder -R com/sun/print/printerInfo.xml");
        System.out.println("-or-");
        System.out.println("InfoAdder -A com.sun.print.prtMgr tools/com.sun.print.prtMgr.resources.jar");
        System.out.println("-or-");
        System.out.println("InfoAdder -P \"x1=1 x2=2 x3=3\" ALLTOOL libx");
    }

    public static void main(String[] stringArray) {
        resource = new ResourceStringReader(RESOURCE_BUNDLE);
        String[] stringArray2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (stringArray[0].equals("-R")) {
            n3 = 2;
        } else if (stringArray[0].equals("-A")) {
            n3 = 3;
        } else if (stringArray[0].equals("-P")) {
            n3 = 4;
        }
        n2 = stringArray.length - n3;
        if (n2 > 0) {
            stringArray2 = new String[n2];
            int n4 = n3;
            while (n4 < stringArray.length) {
                stringArray2[n++] = stringArray[n4] != null && stringArray[n4].trim().length() > 0 ? stringArray[n4] : "";
                ++n4;
            }
        }
        VRegistry.makeDirectories();
        if (stringArray[0].equals("-R")) {
            InfoAdder.addBean(stringArray[1], stringArray2);
        } else if (stringArray[0].equals("-A")) {
            InfoAdder.attach(stringArray[1], stringArray[2], stringArray2);
        } else if (stringArray[0].equals("-P")) {
            InfoAdder.attachProperties(stringArray[1].trim(), stringArray[2].trim(), stringArray[3]);
        } else {
            InfoAdder.usage();
        }
        System.exit(0);
    }

    private static void attachProperties(String string, String string2, String string3) {
        int n = VRegistry.addProperties(string, string2, string3);
        if (n == 1) {
            System.out.println(resource.getString("BeanNotFound", string2));
        } else if (n == 2) {
            System.out.println(resource.getString("LibNotAttached", string3, string2));
        }
    }

    private static void addBean(String string, String[] stringArray) {
        String string2;
        ComponentInfo componentInfo = null;
        try {
            componentInfo = DescriptorManager.createDescriptor(new File(string).toURL());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        if (componentInfo == null) {
            System.err.println();
            System.err.println(resource.getString("InfoReadError", string));
            System.exit(1);
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        LibInfoImpl[] libInfoImplArray = VRegistry.readAllLibJars();
        if (libInfoImplArray != null) {
            int n = 0;
            while (n < libInfoImplArray.length) {
                string2 = libInfoImplArray[n].getJarName();
                if (string2.startsWith("ALL@")) {
                    string3 = string3 + ":" + libInfoImplArray[n].getJarPath();
                } else if (string2.startsWith("services/ALLSERVICE@")) {
                    string4 = string4 + ":" + libInfoImplArray[n].getJarPath();
                } else if (string2.startsWith("tools/ALLTOOL@")) {
                    string5 = string5 + ":" + libInfoImplArray[n].getJarPath();
                }
                ++n;
            }
        }
        string2 = System.getProperty("java.class.path") + string3;
        if (componentInfo instanceof ServiceInfo) {
            ServiceInfo serviceInfo = (ServiceInfo)componentInfo;
            string2 = string2 + string4;
            String[] stringArray2 = new String[]{"-classpath", string2, "-d", ".", serviceInfo.getClassName()};
            boolean bl = new Main(System.out, "rmic").compile(stringArray2);
            if (bl) {
                ServiceInfoImpl serviceInfoImpl = VRegistry.addEntry(serviceInfo, stringArray);
                System.out.println("Jar Path:" + serviceInfoImpl.getJarPaths()[0]);
                System.out.println("Class Path:" + string2);
            } else {
                System.err.println(resource.getString("CompileFailed"));
            }
        } else if (componentInfo instanceof ToolInfo) {
            ToolInfo toolInfo = (ToolInfo)componentInfo;
            ToolInfoImpl toolInfoImpl = VRegistry.addEntry(toolInfo, stringArray);
            System.out.println("Jar Path:" + toolInfoImpl.getJarPaths()[0]);
            string2 = string2 + string5;
            System.out.println("Class Path:" + string2);
        } else if (componentInfo instanceof ExternalClientProviderInfo) {
            ExternalClientProviderInfo externalClientProviderInfo = (ExternalClientProviderInfo)componentInfo;
            ExternalClientProviderInfoImpl externalClientProviderInfoImpl = VRegistry.addEntry(externalClientProviderInfo, stringArray);
            System.out.println("Jar Path:" + externalClientProviderInfoImpl.getJarPaths()[0]);
            System.out.println("Class Path:" + string2);
        } else {
            System.err.println(resource.getString("UnknownInfoDescriptor", string));
        }
    }

    private static void attach(String string, String string2, String[] stringArray) {
        String string3 = VRegistry.addJarToEntry(string, string2, stringArray);
        if (string3 == null) {
            System.out.println(resource.getString("BeanNotFound", string));
        } else {
            System.out.println("Jar Path:" + string3);
        }
    }

    private static String baseName(String string) {
        int n = string.indexOf(64);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }
}

