/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viperimpl.ContainerContext;
import com.sun.management.viperimpl.DelegationAgentContext;
import com.sun.management.viperimpl.DelegationSecurityToken;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.server.ViperImpl;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.services.authentication.SecurityToken;

public class ServiceACManager
implements DelegationAgentContext,
ContainerContext {
    private long delegationKey = 0L;
    private ViperImpl daemon = null;

    ServiceACManager(ViperImpl viperImpl) {
        this.daemon = viperImpl;
    }

    public SecurityToken generateMessageToken(Object[] objectArray) throws AuthenticationException {
        return this.generateDelegationToken(this.daemon.getServiceRole());
    }

    public DelegationSecurityToken generateDelegationToken(VCallerImpl vCallerImpl) throws AuthenticationException {
        while (this.delegationKey == 0L) {
            this.delegationKey = ViperServer.getRandom().nextLong();
        }
        return new DelegationSecurityToken(this.delegationKey, vCallerImpl);
    }

    public VCallerImpl verifyMessageToken(SecurityToken securityToken, Object[] objectArray) throws AuthenticationException {
        if (securityToken instanceof DelegationSecurityToken) {
            return this.verifyDelegationToken((DelegationSecurityToken)securityToken);
        }
        this.daemon.checkToken(securityToken, objectArray);
        return this.daemon.getCallerId(securityToken);
    }

    public VCallerImpl verifyDelegationToken(DelegationSecurityToken delegationSecurityToken) throws AuthenticationException {
        if (delegationSecurityToken == null) {
            throw new AuthenticationException("EXSS_BVD");
        }
        if (delegationSecurityToken.getSecurityId() != this.delegationKey) {
            throw new AuthenticationMessageException();
        }
        return delegationSecurityToken.getDelegate();
    }
}

