/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.PropertiesNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ToolNode
extends VBaseNode
implements VConfigurationNode {
    protected String serverName;
    protected int serverPort;
    protected String className;
    protected boolean autoLoad;
    protected boolean backgroundLoad;
    protected Properties properties;
    protected int SLOT_SERVERNAME;
    protected int SLOT_SERVERPORT;
    protected int SLOT_CLASSNAME;
    protected int SLOT_PROPERTIES;

    public ToolNode() {
        this.setTag("Tool");
        this.SLOT_NAME = 0;
        this.SLOT_DESCRIPTION = 1;
        this.SLOT_ICON = 2;
        this.SLOT_LARGEICON = 3;
        this.SLOT_SCOPE = 4;
        this.SLOT_SERVERNAME = 5;
        this.SLOT_SERVERPORT = 6;
        this.SLOT_CLASSNAME = 7;
        this.SLOT_BGIMAGE = 8;
        this.SLOT_PROPERTIES = 9;
        this.slots = new Node[10];
    }

    public void startParse(ParseContext parseContext) throws SAXException {
        super.startParse(parseContext);
        try {
            this.serverName = this.baseURL.getHost();
            this.serverPort = this.baseURL.getPort();
        }
        catch (Exception exception) {
            this.serverName = "";
            this.serverPort = -1;
        }
        NamedNodeMap namedNodeMap = this.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            String string = namedNodeMap.item(n).getNodeName();
            String string2 = namedNodeMap.item(n).getNodeValue();
            if (string.equals("AutoLoad")) {
                this.autoLoad = this.isTrueValue(string2);
            } else if (string.equals("BackgroundLoad")) {
                this.backgroundLoad = this.isTrueValue(string2);
            } else if (string.equals("TreeDisplay")) {
                this.treeDisplay = this.isTrueValue(string2);
            }
            ++n;
        }
    }

    public void doneChild(NodeEx nodeEx, ParseContext parseContext) throws SAXException {
        super.doneChild(nodeEx, parseContext);
        String string = nodeEx.getNodeName();
        Node node = nodeEx.getFirstChild();
        String string2 = null;
        if (node != null) {
            string2 = node.getNodeValue();
        }
        try {
            if (string.equals("ServerName")) {
                this.serverName = string2;
                this.slots[this.SLOT_SERVERNAME] = nodeEx;
            } else if (string.equals("ServerPort")) {
                this.serverPort = Integer.parseInt(string2);
                this.slots[this.SLOT_SERVERPORT] = nodeEx;
            } else if (string.equals("Name")) {
                this.name = string2;
                this.slots[this.SLOT_NAME] = nodeEx;
            } else if (string.equals("Description")) {
                this.description = string2;
                this.slots[this.SLOT_DESCRIPTION] = nodeEx;
            } else if (string.equals("Icon")) {
                this.smallIcon = string2;
                this.slots[this.SLOT_ICON] = nodeEx;
            } else if (string.equals("LargeIcon")) {
                this.largeIcon = string2;
                this.slots[this.SLOT_LARGEICON] = nodeEx;
            } else if (string.equals("ClassName")) {
                this.className = string2;
                this.slots[this.SLOT_CLASSNAME] = nodeEx;
            } else if (string.equals("Scope")) {
                this.scope = string2;
                this.slots[this.SLOT_SCOPE] = nodeEx;
            } else if (string.equals("BackgroundImage")) {
                this.bgImage = ((BGImageNode)nodeEx).getURL();
                this.bgImageLoc = ((BGImageNode)nodeEx).getLocation();
                this.slots[this.SLOT_BGIMAGE] = nodeEx;
            } else if (string.equals("Properties")) {
                this.properties = ((PropertiesNode)nodeEx).getProperties();
                this.slots[this.SLOT_PROPERTIES] = nodeEx;
            }
        }
        catch (Exception exception) {
            Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)"Configuration error", (Throwable)exception);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        if (string == null) {
            return;
        }
        this.className = string;
        this.setTaggedNode("ClassName", string, this.SLOT_CLASSNAME);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
        if (string != null && string.length() > 0) {
            this.setTaggedNode("ServerName", string, this.SLOT_SERVERNAME);
        } else if (this.slots[this.SLOT_SERVERNAME] != null) {
            this.removeChild(this.slots[this.SLOT_SERVERNAME]);
            this.slots[this.SLOT_SERVERNAME] = null;
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int n) {
        if (n < 0) {
            n = -1;
        }
        this.serverPort = n;
        if (n >= 0) {
            this.setTaggedNode("ServerPort", "" + n, this.SLOT_SERVERPORT);
        } else if (this.slots[this.SLOT_SERVERPORT] != null) {
            this.removeChild(this.slots[this.SLOT_SERVERPORT]);
            this.slots[this.SLOT_SERVERPORT] = null;
        }
    }

    public boolean isAutoLoad() {
        return this.autoLoad;
    }

    public void setAutoLoad(boolean bl) {
        this.autoLoad = bl;
        if (bl) {
            this.setAttribute("AutoLoad", "true");
        } else if (this.getAttribute("AutoLoad") != null && !this.getAttribute("AutoLoad").equals("")) {
            this.removeAttribute("AutoLoad");
        }
    }

    public boolean isBackgroundLoad() {
        return this.backgroundLoad;
    }

    public void setBackgroundLoad(boolean bl) {
        this.backgroundLoad = bl;
        if (bl) {
            this.setAttribute("BackgroundLoad", "true");
        } else if (this.getAttribute("BackgroundLoad") != null && !this.getAttribute("BackgroundLoad").equals("")) {
            this.removeAttribute("BackgroundLoad");
        }
    }

    public Properties getParameters() {
        return this.properties;
    }

    public void setParameters(Properties properties) {
        this.properties = properties;
        if (properties != null && properties.size() > 0) {
            PropertiesNode propertiesNode = this.getConfiguration().createPropertiesNode(properties);
            this.setTaggedNode((Node)((Object)propertiesNode), this.SLOT_PROPERTIES);
        } else if (this.slots[this.SLOT_PROPERTIES] != null) {
            this.removeChild(this.slots[this.SLOT_PROPERTIES]);
            this.slots[this.SLOT_PROPERTIES] = null;
        }
    }

    public boolean getAllowsChildren() {
        return false;
    }

    protected void printNode(int n) {
        System.out.println(this.indent(n) + this.getNodeName() + ": " + this.getClassName() + " (scope = " + this.getScope() + ")" + " len = " + this.getLength() + ", " + this.getFilteredLength());
        String string = this.indent(n + 1);
        System.out.println(string + "Server Name: " + (this.serverName.equals("") ? "Default" : this.serverName));
        System.out.println(string + "Server Port: " + (this.serverPort == -1 ? "Default" : "" + this.serverPort));
        System.out.println(string + (this.autoLoad ? "Automatically loaded" : "Loaded at user request"));
        System.out.println(string + (this.backgroundLoad ? "Loads in background" : "Blocks on load"));
        System.out.println(string + (this.treeDisplay ? "Displayed in Nav Panel" : "Hidden from Nav Panel"));
    }
}

