/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.common;

import com.sun.admin.hostmgr.common.HostException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class HostData
implements Serializable,
Cloneable {
    private static final int CLASS_A_MAX = 127;
    private static final int CLASS_B_MAX = 191;
    private static final int CLASS_C_MAX = 223;
    private static final int CLASS_D_MAX = 239;
    private static final long IN_CLASSA_HOST = 0xFFFFFFL;
    private static final long IN_CLASSB_HOST = 65535L;
    private static final long IN_CLASSC_HOST = 255L;
    private static final int MAXDESCRIPTIONLEN = 256;
    private static final int MAXHOSTNAMELEN = 256;
    private String hostname = "";
    private String aliases = "";
    private String networkAddress = "";
    private String comment = "";
    private String ethernetAddress = "";
    private long netAddrLong;

    public HostData() {
    }

    public HostData(String string) {
        this.hostname = string;
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setHostName(String string) {
        this.hostname = string;
    }

    public String getAliases() {
        return this.aliases;
    }

    public void setAliases(String string) {
        this.aliases = string;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public long getNetworkAddressLong() {
        return this.netAddrLong;
    }

    public void setNetworkAddress(String string) {
        try {
            HostData.validateIPAddress(string);
        }
        catch (Exception exception) {
            this.netAddrLong = 0L;
            this.networkAddress = string;
            return;
        }
        int n = 3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        this.networkAddress = string;
        String string2 = stringTokenizer.nextToken();
        this.netAddrLong = new Integer(string2).intValue();
        while (stringTokenizer.hasMoreTokens()) {
            this.netAddrLong <<= 8;
            --n;
            string2 = stringTokenizer.nextToken();
            this.netAddrLong |= (long)new Integer(string2).intValue();
        }
        this.netAddrLong <<= n * 8;
    }

    public String getDescription() {
        return this.comment;
    }

    public void setDescription(String string) {
        this.comment = string;
    }

    public String getEthernetAddress() {
        return this.ethernetAddress;
    }

    public void setEthernetAddress(String string) {
        this.ethernetAddress = string;
    }

    public static final void validateEthernetAddress(String string) throws HostException {
        int n = 0;
        int n2 = 255;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
            int n4 = 0;
            while (n4 < stringBuffer.length()) {
                int n5 = Character.digit(stringBuffer.charAt(n4), 16);
                if (n5 == -1) {
                    throw new HostException("EXM_HST_CMN2");
                }
                n3 = n3 * 16 + n5;
                ++n4;
            }
            if (n3 > 255) {
                throw new HostException("EXM_HST_CMN2");
            }
            n2 &= n3;
        }
        if (n != 6 || n2 == 255) {
            throw new HostException("EXM_HST_CMN2");
        }
    }

    public static final void validateHostName(String string) throws HostException {
        if (string.length() == 0) {
            return;
        }
        if (string.length() == 1 || string.length() > 256) {
            throw new HostException("EXM_HST_CMN3");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        if (!Character.isLetterOrDigit(c)) {
            throw new HostException("EXM_HST_CMN3");
        }
        int n = 1;
        while (n < stringBuffer.length()) {
            c = stringBuffer.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                throw new HostException("EXM_HST_CMN3");
            }
            ++n;
        }
        if (c == '_' || c == '-' || c == '.') {
            throw new HostException("EXM_HST_CMN3");
        }
    }

    public static final void validateAliasNames(String string) throws HostException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                HostData.validateHostName(string2);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_CMN5");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void validateIPAddress(String var0) throws HostException {
        var1_1 = 0;
        var2_2 = new int[4];
        var8_3 = new StringTokenizer(var0, ".", false);
        if (!var0.endsWith(".")) ** GOTO lbl15
        throw new HostException("EXM_HST_CMN1");
lbl-1000:
        // 1 sources

        {
            var7_4 = var8_3.nextToken();
            try {
                var2_2[var1_1] = new Integer(var7_4);
            }
            catch (Exception var9_5) {
                throw new HostException("EXM_HST_CMN1");
            }
            if (var2_2[var1_1] > 255) {
                throw new HostException("EXM_HST_CMN1");
            }
            ++var1_1;
lbl15:
            // 2 sources

            ** while (var8_3.hasMoreTokens())
        }
lbl16:
        // 1 sources

        if (var1_1 != 4) {
            throw new HostException("EXM_HST_CMN1");
        }
        var3_6 = var2_2[0] << 24 | var2_2[1] << 16 | var2_2[2] << 8 | var2_2[3];
        if (var2_2[0] <= 127 && (var5_7 = 0xFFFFFFL & var3_6) != 0L && var5_7 != 0xFFFFFFL) {
            return;
        }
        if (var2_2[0] <= 191 && (var5_7 = 65535L & var3_6) != 0L && var5_7 != 65535L) {
            return;
        }
        if (var2_2[0] <= 223 && (var5_7 = 255L & var3_6) != 0L && var5_7 != 255L) {
            return;
        }
        throw new HostException("EXM_HST_CMN1");
    }

    public static final void validateDescription(String string) throws HostException {
        if (string.length() == 0) {
            return;
        }
        if (string.length() > 256) {
            throw new HostException("EXM_HST_CMN8");
        }
    }

    public int netAddrCompare(HostData hostData) {
        int n = 0;
        long l = hostData.getNetworkAddressLong();
        if (this.netAddrLong < l) {
            n = -1;
        } else if (this.netAddrLong > l) {
            n = 1;
        }
        return n;
    }

    public boolean equals(HostData hostData) {
        if (hostData == null) {
            return false;
        }
        return this.getHostName().equals(hostData.getHostName()) && this.getNetworkAddress().equals(hostData.getNetworkAddress()) && this.getAliases().equals(hostData.getAliases()) && this.getDescription().equals(hostData.getDescription()) && this.getEthernetAddress().equals(hostData.getEthernetAddress());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void print() {
        System.out.println("*************************************");
        System.out.println("Host name: " + this.hostname);
        System.out.println("Network address: " + this.networkAddress);
        System.out.println("Aliases: " + this.aliases);
        System.out.println("Description: " + this.comment);
        System.out.println("Ethernet address: " + this.ethernetAddress);
        System.out.println("*************************************");
    }
}

