/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class NetworkGenPropsPanel
extends AbstractPropsPanel {
    public static final int HELP_CACHE_SIZE = 3;
    private NetworkData originalNetworkObj;
    private ISOLatinField networkName;
    private JLabel networkNameLabel;
    private ISOLatinField ipAddress;
    private JLabel ipAddressLabel;
    private ISOLatinField netmask;
    private JLabel netmaskLabel;
    private boolean isNetwork;

    public NetworkGenPropsPanel(VHostMgr vHostMgr, Vector vector, boolean bl, GenInfoPanel genInfoPanel, NetworkData networkData) {
        ResourceBundle resourceBundle = vHostMgr.getResourceBundle();
        this.isNetwork = bl;
        this.setLayout(new GridBagLayout());
        ActionString actionString = bl ? new ActionString(resourceBundle, "NetGenPropsTabName") : new ActionString(resourceBundle, "SubnetGenPropsTabName");
        this.setBorder(BorderFactory.createTitledBorder(actionString.getString()));
        actionString = new ActionString(resourceBundle, "NetGenPropsNetworkName");
        this.networkNameLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)this.networkNameLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)5, (int)10, (int)5);
        this.networkNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.networkNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.networkNameLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.networkName = new ISOLatinField(-1, networkData.getNetworkName(), 16);
        Constraints.constrain((Container)this, (Component)this.networkName, (int)1, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)0, (int)10, (int)5);
        this.networkName.setMinimumSize(this.networkName.getPreferredSize());
        this.networkName.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.networkNameLabel.setLabelFor((Component)this.networkName);
        actionString = new ActionString(resourceBundle, "NetGenPropsNetAddr");
        this.ipAddressLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)this.ipAddressLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        this.ipAddressLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.ipAddressLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.ipAddressLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.ipAddress = new ISOLatinField(15, networkData.getNetworkAddress(), 16);
        Constraints.constrain((Container)this, (Component)this.ipAddress, (int)1, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        this.ipAddress.setMinimumSize(this.ipAddress.getPreferredSize());
        this.ipAddress.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.ipAddressLabel.setLabelFor((Component)this.ipAddress);
        if (bl) {
            actionString = new ActionString(resourceBundle, "NetGenPropsNetmask");
            this.netmaskLabel = new JLabel(actionString.getString());
            Constraints.constrain((Container)this, (Component)this.netmaskLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
            this.netmaskLabel.setForeground(Constants.PROPS_LABEL_COLOR);
            this.netmaskLabel.setFont(Constants.PROPS_LABEL_FONT);
            this.netmaskLabel.setDisplayedMnemonic(actionString.getMnemonic());
            this.netmask = new ISOLatinField(15, networkData.getNetmask(), 16);
            Constraints.constrain((Container)this, (Component)this.netmask, (int)1, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
            this.netmask.setMinimumSize(this.netmask.getPreferredSize());
            this.netmask.setFont(Constants.PROPS_RW_VALUE_FONT);
            this.netmaskLabel.setLabelFor((Component)this.netmask);
        }
        if (networkData.getNetworkAddress().length() != 0) {
            this.networkName.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_netprop_name")));
            this.ipAddress.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_netprop_address")));
            if (bl) {
                this.netmask.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_netprop_netmask")));
            }
        } else {
            this.networkName.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newnet_name")));
            this.ipAddress.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newnet_address")));
            if (bl) {
                this.netmask.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newnet_netmask")));
            }
        }
        this.networkName.requestFocus();
        this.originalNetworkObj = networkData;
    }

    public void dialogDataExchange(Object object) throws HostException {
        NetworkData networkData = (NetworkData)object;
        if (this.networkName.getText().length() > 0) {
            try {
                NetworkData.validateNetworkName(this.networkName.getText());
                networkData.setNetworkName(this.networkName.getText());
            }
            catch (HostException hostException) {
                this.networkName.requestFocus();
                throw hostException;
            }
        }
        if (this.ipAddress.getText().length() == 0) {
            this.ipAddress.requestFocus();
            throw new HostException("EXM_HST_GUI_MISSING_PROPS_VALUE", this.ipAddressLabel.getText().substring(0, this.ipAddressLabel.getText().length() - 1));
        }
        try {
            NetworkData.validateIPAddress(this.ipAddress.getText());
            networkData.setNetworkAddress(this.ipAddress.getText());
        }
        catch (HostException hostException) {
            this.ipAddress.requestFocus();
            throw hostException;
        }
        if (this.isNetwork && this.netmask.getText().length() > 0) {
            try {
                NetworkData.validateNetmask(this.netmask.getText());
                networkData.setNetmask(this.netmask.getText());
            }
            catch (HostException hostException) {
                this.netmask.requestFocus();
                throw hostException;
            }
        }
        if (this.isNetwork && this.networkName.getText().length() == 0 && this.netmask.getText().length() == 0) {
            this.ipAddress.requestFocus();
            throw new HostException("EXM_HST_GUI_ILL_DEFINED_NETWORK", this.ipAddressLabel.getText().substring(0, this.ipAddressLabel.getText().length() - 1), this.networkNameLabel.getText().substring(0, this.networkNameLabel.getText().length() - 1), this.netmaskLabel.getText().substring(0, this.netmaskLabel.getText().length() - 1));
        }
    }

    public void dialogDataInitialize(Object object) {
        NetworkData networkData = (NetworkData)object;
        this.networkName.setText(networkData.getNetworkName());
        this.ipAddress.setText(networkData.getNetworkAddress());
        if (this.isNetwork) {
            this.netmask.setText(networkData.getNetmask());
        }
        this.originalNetworkObj = networkData;
    }
}

