/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.NetworkPropsDialog;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.client.ShowNetworksDialog;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class NetworkContent
extends Content {
    public static final String NETWORK_COLUMN_NETWORKNAME = "networkListNetworkName";
    public static final String NETWORK_COLUMN_IPADDRESS = "networkListIPAddress";
    public static final String NETWORK_COLUMN_ALIASES = "networkListAliases";
    public static final String NETWORK_COLUMN_COMMENT = "networkListComment";
    public static final String NETWORK_COLUMN_NETMASK = "networkListNetmask";
    private int displayChunkSize = -99999;
    private String sortPreferencesKey;
    private final Object[][] advColumnHeaderConfig = new Object[][]{{"networkListNetworkName", new Integer(16)}, {"networkListNetmask", new Integer(16)}, {"networkListComment", new Integer(32)}, {"networkListAliases", new Integer(32)}};
    private final Object[][] genColumnHeaderConfig = new Object[][]{{"networkListNetworkName", new Integer(16)}};
    private static String[][] columnHeaders = null;

    public NetworkContent(VHostMgr vHostMgr) {
        super(vHostMgr);
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
    }

    public void createProperties() {
        NetworkPropsDialog networkPropsDialog = new NetworkPropsDialog(this.theApp, this.theApp.getFrame(), this.whatAmI().equals("networks"), new NetworkData());
        networkPropsDialog.setVisible(true);
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        try {
            VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
            TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
            NetworkData networkData = treeNodeData.getNetworkData();
            NetworkPropsDialog networkPropsDialog = new NetworkPropsDialog(this.theApp, this.theApp.getFrame(), this.whatAmI().equals("networks"), networkData);
            if (networkData.getNetworkAddress().length() == 0) {
                throw new HostException("EXM_HST_GUI_CANT_VIEW_UNREAL_NETWORK", networkData.getNetworkName());
            }
            networkPropsDialog.show();
        }
        catch (HostException hostException) {
            this.theApp.reportErrorException((Exception)((Object)hostException));
        }
    }

    public void openSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.scopeselected", (Object)vScopeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
    }

    public void deleteSelected() {
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            return;
        }
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            n = Integer.parseInt(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNumColumns"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetwork"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)20, (int)5, (int)0, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetworkWill"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)1, (int)2, (int)1, (int)20, (int)5, (int)10, (int)5);
        ImageIcon imageIcon = this.theApp.loadImageIcon("warning_bullet_icon.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        Constraints.constrain((Container)jPanel, (Component)jButton, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)10, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetworkBullet1"), n - 5);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        Constraints.constrain((Container)jPanel, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)-1, (int)1, (int)0, (int)3, (int)18, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        final String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"DeleteNetworkTitle");
        final String string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"NetworkBatchDeleted");
        final String string3 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"PercentComplete");
        boolean bl = true;
        ProgressPanel progressPanel = null;
        JProgressBar jProgressBar = null;
        if (bl) {
            int n2 = string.length();
            n2 = Math.max(n2, string2.length());
            n2 = Math.max(n2, 10);
            progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n2, true);
            progressPanel.setRange(0, vector.size());
            progressPanel.setValue(0);
            progressPanel.setTitle(string);
            progressPanel.setText(string);
        } else {
            jProgressBar = new JProgressBar(0, vector.size());
            jProgressBar.setValue(jProgressBar.getMinimum());
            jProgressBar.setStringPainted(true);
            Object[] objectArray = new Object[]{new Integer(jProgressBar.getValue())};
            jProgressBar.setString(MessageFormat.format(string3, objectArray));
        }
        final ProgressPanel progressPanel2 = progressPanel;
        final JProgressBar jProgressBar2 = jProgressBar;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Object[] objectArray;
                        1.access$000(this.this$1).theApp.waitOn();
                        1.access$000(this.this$1).theApp.setStatusBar(1.access$100(this.this$1));
                        1.access$000(this.this$1).theApp.fireConsoleAction(new VConsoleEvent((Object)1.access$000(this.this$1).theApp, "vconsole.updateprogress", (Object)1.access$200(this.this$1)));
                        if (1.access$300(this.this$1) != null) {
                            1.access$300(this.this$1).setVisible(true);
                        }
                        String string = new String();
                        String string2 = "EXM_HST_GUI_CANT_DELETE_UNREAL_NETWORK";
                        int n = 0;
                        while (n < 1.access$400(this.this$1).size()) {
                            try {
                                objectArray = (Object[])1.access$400(this.this$1).elementAt(n);
                                TreeNodeData treeNodeData = (TreeNodeData)objectArray.getPayload();
                                NetworkData networkData = treeNodeData.getNetworkData();
                                if (networkData.getNetworkAddress().length() == 0) {
                                    throw new HostException(string2, networkData.getNetworkName());
                                }
                                if (!networkData.isStaticNetwork()) {
                                    string = string + networkData.getNetworkAddress() + "    ";
                                } else {
                                    1.access$000(this.this$1).theApp.getHostMgr().deleteNetwork(networkData);
                                    Content.broadcastUpdate(1.access$000(this.this$1).theApp.getContentInstances(), networkData, null, true);
                                }
                            }
                            catch (Exception exception) {
                                1.access$000(this.this$1).theApp.reportErrorException(exception);
                            }
                            if (1.access$200(this.this$1) != null) {
                                1.access$200(this.this$1).setValue(n + 1);
                                Object[] objectArray2 = new Object[]{new Integer(1.access$200(this.this$1).getValue() * 100 / 1.access$200(this.this$1).getMaximum())};
                                1.access$200(this.this$1).setString(MessageFormat.format(1.access$500(this.this$1), objectArray2));
                            }
                            if (1.access$300(this.this$1) != null) {
                                1.access$300(this.this$1).setValue(n + 1);
                                objectArray = new Object[]{new Integer(n + 1), new Integer(1.access$400(this.this$1).size())};
                                1.access$300(this.this$1).setText(MessageFormat.format(1.access$600(this.this$1), objectArray));
                            }
                            ++n;
                        }
                        1.access$000(this.this$1).clearSelection();
                        1.access$000(this.this$1).theApp.setStatusBar(ResourceStrings.getString((ResourceBundle)1.access$700(this.this$1), (String)"DeleteNetworksDone"));
                        if (1.access$300(this.this$1) != null) {
                            1.access$300(this.this$1).setValue(1.access$300(this.this$1).getValue() + 1);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        1.access$000(this.this$1).theApp.fireConsoleAction(new VConsoleEvent((Object)1.access$000(this.this$1).theApp, "vconsole.updateprogress", null));
                        if (1.access$300(this.this$1) != null) {
                            1.access$300(this.this$1).setVisible(false);
                            1.access$300(this.this$1).dispose();
                        }
                        1.access$000(this.this$1).theApp.waitOff();
                        if (string.length() > 0) {
                            objectArray = new HostException("EXM_HST_GUI_CANT_DELETE_DYNAMIC_NETWORKS", string);
                            1.access$000(this.this$1).theApp.reportErrorException((Exception)objectArray);
                        }
                    }
                };
                thread.start();
            }

            static /* synthetic */ NetworkContent access$000(1 var0) {
                return var0.NetworkContent.this;
            }

            static /* synthetic */ String access$100(1 var0) {
                return var0.string;
            }

            static /* synthetic */ JProgressBar access$200(1 var0) {
                return var0.jProgressBar2;
            }

            static /* synthetic */ ProgressPanel access$300(1 var0) {
                return var0.progressPanel2;
            }

            static /* synthetic */ Vector access$400(1 var0) {
                return var0.vector;
            }

            static /* synthetic */ String access$500(1 var0) {
                return var0.string3;
            }

            static /* synthetic */ String access$600(1 var0) {
                return var0.string2;
            }

            static /* synthetic */ ResourceBundle access$700(1 var0) {
                return var0.resourceBundle;
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetworkTitle"), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Delete"));
    }

    public void find(Object object) {
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getFirstChild();
        while (vScopeNode != null) {
            TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
            NetworkData networkData = treeNodeData.getNetworkData();
            if (networkData == (NetworkData)object) {
                this.clearSelection();
                Vector<VScopeNode> vector = new Vector<VScopeNode>();
                vector.addElement(vScopeNode);
                this.setSelected(vector);
                return;
            }
            vScopeNode = (VScopeNode)vScopeNode.getNextSibling();
        }
    }

    public String whatAmI() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        if (networkData == null) {
            return "networks";
        }
        return "subnetworks";
    }

    public String getSortAttribute() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return NETWORK_COLUMN_IPADDRESS;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(1));
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n <= 0) {
            return NETWORK_COLUMN_IPADDRESS;
        }
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        String string2 = applicationContext.isNetworksSupported() ? (String)this.advColumnHeaderConfig[n][0] : (String)this.genColumnHeaderConfig[--n][0];
        return string2;
    }

    public boolean isAscendSort() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return true;
        }
        boolean bl = true;
        if (string.indexOf(45) >= 0) {
            bl = false;
        }
        return bl;
    }

    public String[][] getColumnHeaders() {
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        if (columnHeaders == null) {
            columnHeaders = applicationContext.isNetworksSupported() ? this.constructColumnHeaders(this.advColumnHeaderConfig) : this.constructColumnHeaders(this.genColumnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, NetworkData networkData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_IPADDRESS);
        hashtable.put(string, networkData.getNetworkAddress());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_NETWORKNAME);
        hashtable.put(string, networkData.getNetworkName());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_NETMASK);
        hashtable.put(string, networkData.getNetmask());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_COMMENT);
        hashtable.put(string, networkData.getDescription());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_ALIASES);
        hashtable.put(string, networkData.getAliases());
        return hashtable;
    }

    public void refresh() {
        String string;
        String string2;
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setInfoBar("");
        this.clearSelection();
        this.theApp.getTree().removeAllNetworks(this.treeNode);
        int n = this.getDisplayChunkSize();
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), n);
        if (networkData == null) {
            string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchNetworksTitle");
            string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchNetworksDone");
        } else {
            string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchSubnetworksTitle");
            string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchSubnetworksDone");
        }
        final String string3 = string;
        final String string4 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"PercentComplete");
        final JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setValue(0);
        jProgressBar.setStringPainted(true);
        Object[] objectArray = new Object[]{new Integer(jProgressBar.getValue())};
        jProgressBar.setString(MessageFormat.format(string4, objectArray));
        jProgressBar.setVisible(n > 0);
        if (this.treeNode.getResultPane() == null) {
            this.treeNode.setResultPane((Component)new VBusyPanel(string2));
            this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode));
        }
        this.theApp.setStatusBar(string2);
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updateprogress", (Object)(n > 0 ? jProgressBar : null)));
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        final String string5 = vConsoleProperties.getProperty(this.sortPreferencesKey);
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.sortup", null));
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    NetworkContent.this.theApp.setStatusBar(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string3));
                    if (jProgressBar.isVisible()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (jProgressBar.getValue() == 0) {
                        NetworkContent.this.treeNode.setResultPane(null);
                        NetworkContent.this.theApp.fireConsoleAction(new VConsoleEvent((Object)NetworkContent.this.theApp, "vconsole.updatescope", (Object)NetworkContent.this.treeNode));
                    }
                    NetworkContent.this.updateInfoBar();
                    NetworkContent.this.theApp.fireConsoleAction(new VConsoleEvent((Object)NetworkContent.this.theApp, "vconsole.updateprogress", null));
                    if (string5 != null) {
                        VConsoleProperties vConsoleProperties = NetworkContent.this.theApp.getProperties();
                        vConsoleProperties.setProperty("vconsole.sortedcolumn", string5);
                        NetworkContent.this.saveSortPreferences();
                    }
                    NetworkContent.this.theApp.waitOff();
                    return;
                }
                if (jProgressBar.getValue() == 0) {
                    NetworkContent.this.treeNode.setResultPane(null);
                }
                if (listFetchEvent.getSize() > 0) {
                    if (listFetchEvent.getNumReceived() >= listFetchEvent.getSize()) {
                        jProgressBar.setValue(100);
                    } else {
                        jProgressBar.setValue(listFetchEvent.getNumReceived() * 100 / listFetchEvent.getSize());
                    }
                    Object[] objectArray = new Object[]{new Integer(jProgressBar.getValue())};
                    jProgressBar.setString(MessageFormat.format(string4, objectArray));
                }
                NetworkContent.this.theApp.getTree().appendToNode(NetworkContent.this.treeNode, vector);
            }

            public synchronized void errorException(Exception exception) {
                NetworkContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        myListFetch.start();
        this.bRefresh = true;
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.theApp.getTree().removeAllNetworks(this.treeNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public boolean offerNew(Object object, boolean bl) {
        TreeNodeData treeNodeData;
        Object object2;
        Object object3;
        int n;
        if (object != null && !(object instanceof NetworkData)) {
            return false;
        }
        NetworkData networkData = (NetworkData)object;
        TreeNodeData treeNodeData2 = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        if (!networkData.isNetwork() && networkData2 != null) {
            networkData.setNetmaskForSubnet(networkData2.getNetmask());
        }
        Integer n2 = (Integer)AdminCommonTools.CMN_getPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(1));
        Object object4 = null;
        if (n2 == 2) {
            n = 0;
            while (n < this.getNumInstances()) {
                long l;
                long l2;
                object3 = this.getInstance(n);
                object2 = ((Content)object3).getTreeNode();
                treeNodeData = (TreeNodeData)object2.getPayload();
                NetworkData networkData3 = treeNodeData.getNetworkData();
                if (networkData3 != null && networkData3.getNetworkAddress().length() != 0 && (l2 = networkData3.getNetworkAddressLong()) == (l = networkData.getNetworkAddressLong())) {
                    object4 = object2;
                    break;
                }
                ++n;
            }
        }
        n = 1;
        if (object4 != null) {
            n = 1;
        } else if (networkData2 != null) {
            n = networkData2.belongsNetwork(networkData.getNetworkAddress());
        } else if (!networkData.isNetwork()) {
            n = 0;
        }
        if (bl || n == 0) {
            return n != 0;
        }
        if (object4 != null) {
            object3 = (TreeNodeData)object4.getPayload();
            object2 = ((TreeNodeData)object3).getNetworkData();
            treeNodeData = (VScopeNode)object4.getParent();
            this.theApp.getTree().removeNetwork((VScopeNode)treeNodeData, (NetworkData)object2);
        }
        this.theApp.getTree().addNetwork(this.treeNode, networkData);
        return true;
    }

    public boolean offerDelete(Object object, boolean bl) {
        if (object != null && !(object instanceof NetworkData)) {
            return false;
        }
        final NetworkData networkData = (NetworkData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData2 = treeNodeData.getNetworkData();
        boolean bl2 = true;
        if (networkData2 != null) {
            bl2 = networkData2.belongsNetwork(networkData.getNetworkAddress());
        } else if (!networkData.isNetwork()) {
            bl2 = false;
        }
        if (bl || !bl2) {
            return bl2;
        }
        if (this.theApp.getTree().getCurrentContent() == this) {
            this.getDataCache().removeElement(networkData);
        } else {
            Vector vector = this.getDataCache();
            int n = 0;
            while (n < vector.size()) {
                NetworkData networkData3 = (NetworkData)vector.elementAt(n);
                if (networkData3.equals(networkData)) {
                    vector.removeElement(networkData3);
                    break;
                }
                ++n;
            }
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        NetworkContent.this.theApp.getTree().removeNetwork(NetworkContent.this.treeNode, networkData);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.theApp.getTree().removeNetwork(this.treeNode, networkData);
        }
        return true;
    }

    public void updateInfoBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        if (networkData == null) {
            String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"NetworkListContents");
            Object[] objectArray = new Object[2];
            int n = Math.max(0, this.getDataCache().size() - 1);
            objectArray[0] = new Integer(n);
            objectArray[1] = new Integer(1);
            String string2 = MessageFormat.format(string, objectArray);
            this.theApp.setInfoBar(string2);
        } else {
            String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SubnetworkListContents");
            Object[] objectArray = new Object[2];
            int n = Math.max(0, this.getDataCache().size() - 1);
            objectArray[0] = new Integer(n);
            objectArray[1] = new Integer(1);
            String string3 = MessageFormat.format(string, objectArray);
            this.theApp.setInfoBar(string3);
        }
    }

    public void updateDefaultColumns() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setPropertyObject("vconsole.defaultcolumnheader", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_IPADDRESS));
        Object[][] objectArray = new Object[][]{{NETWORK_COLUMN_IPADDRESS, new Integer(16)}};
        String[][] stringArray = this.constructColumnHeaders(objectArray);
        vConsoleProperties.setProperty("vconsole.defaultcolumnwidth", stringArray[0][1]);
    }

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    private int getServerChunkSize() {
        return 0;
    }

    private int getDisplayChunkSize() {
        if (this.displayChunkSize != -99999) {
            return this.displayChunkSize;
        }
        try {
            String string = System.getProperty("hostmgr.PreferredDisplayChunkSize");
            this.displayChunkSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.displayChunkSize = 0;
        }
        return this.displayChunkSize;
    }

    public boolean isShowByTypeSupported() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        return networkData == null;
    }

    public void showByType() {
        Integer n = (Integer)AdminCommonTools.CMN_getPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(1));
        final ShowNetworksDialog showNetworksDialog = new ShowNetworksDialog(this.theApp, this.theApp.getFrame(), n);
        showNetworksDialog.getOKBtn().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminCommonTools.CMN_setPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(showNetworksDialog.getShowValue()));
                showNetworksDialog.dispose();
                NetworkContent.this.refresh();
            }
        });
        showNetworksDialog.show();
    }

    class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper hostMgr;
        NetworkData networkData = null;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            try {
                this.listProps = new ListProperties();
                if (NetworkContent.this.isAscendSort()) {
                    this.listProps.setSortOrderAscending();
                } else {
                    this.listProps.setSortOrderDescending();
                }
                this.listProps.setSortColumn(NetworkContent.this.getSortAttribute());
                this.listProps.setChunkSize(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hostMgr = NetworkContent.this.theApp.getHostMgr();
            TreeNodeData treeNodeData = (TreeNodeData)NetworkContent.this.treeNode.getPayload();
            this.networkData = treeNodeData.getNetworkData();
        }

        public Vector listCustomStart() {
            Vector<NetworkData> vector = new Vector<NetworkData>();
            NetworkData networkData = new NetworkData();
            String string = ResourceStrings.getString((ResourceBundle)NetworkContent.this.theApp.getResourceBundle(), (String)"AllNetworkHosts");
            networkData.setNetworkName(string);
            vector.addElement(networkData);
            return vector;
        }

        public Vector listAll() throws AdminException {
            ApplicationContext applicationContext = NetworkContent.this.theApp.getApplicationContext();
            if (!applicationContext.isNetworksSupported()) {
                return new Vector();
            }
            Integer n = (Integer)AdminCommonTools.CMN_getPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(1));
            if (n == 3) {
                return new Vector();
            }
            boolean bl = n == 2;
            this.listProps.setCustomBooleanArg1(bl);
            if (this.networkData == null) {
                return this.hostMgr.listNetworks(this.listProps);
            }
            return this.hostMgr.listNetworkSubnets(this.networkData, this.listProps);
        }

        public void listTrace(String string) {
            NetworkContent.this.theApp.Trace(string);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)NetworkContent.this.theApp.getResourceBundle(), (String)"BEANNAME");
        }
    }
}

