/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.FilterPanel;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ListFetch;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.HostPropsDialog;
import com.sun.admin.hostmgr.client.HostRenameDialog;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;

public class HostContent
extends Content {
    public static final String HOST_COLUMN_HOSTNAME = "hostListComputerName";
    public static final String HOST_COLUMN_IPADDRESS = "hostListIPAddress";
    public static final String HOST_COLUMN_COMMENT = "hostListComment";
    public static final String HOST_COLUMN_ALIASES = "hostListAliases";
    public static final String HOST_COLUMN_ENETADDRESS = "hostListEnetAddress";
    private final String[] filterKeys = new String[]{"hostListComputerName", "hostListIPAddress", "hostListComment", "hostListAliases"};
    private VFilter filterControl = null;
    private Vector filters = null;
    private int serverChunkSize = -99999;
    private int displayChunkSize = -99999;
    private String sortPreferencesKey;
    private ImageIcon smallHostIcon;
    private ImageIcon largeHostIcon;
    private final Object[][] advColumnHeaderConfig = new Object[][]{{"hostListIPAddress", new Integer(16)}, {"hostListComment", new Integer(32)}, {"hostListAliases", new Integer(32)}, {"hostListEnetAddress", new Integer(18)}};
    private final Object[][] genColumnHeaderConfig = new Object[][]{{"hostListIPAddress", new Integer(16)}};
    private static String[][] columnHeaders = null;

    public HostContent(VHostMgr vHostMgr) {
        super(vHostMgr);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)vHostMgr.getMenuBar());
        this.rootNode.setToolBar((JToolBar)vHostMgr.getToolBar());
        ResourceBundle resourceBundle = vHostMgr.getResourceBundle();
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.smallHostIcon = vHostMgr.loadImageIcon("smallHost.gif");
        this.largeHostIcon = vHostMgr.loadImageIcon("largeHost.gif");
    }

    public void createProperties() {
        HostPropsDialog hostPropsDialog = new HostPropsDialog(this.theApp, this.theApp.getFrame(), new HostData(""), true);
        hostPropsDialog.setVisible(true);
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        HostData hostData = (HostData)vScopeNode.getPayload();
        HostPropsDialog hostPropsDialog = new HostPropsDialog(this.theApp, this.theApp.getFrame(), hostData, false);
        hostPropsDialog.show();
    }

    public void deleteSelected() {
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            return;
        }
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            n = Integer.parseInt(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNumColumns"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHost"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)20, (int)5, (int)0, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHostWill"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)1, (int)2, (int)1, (int)20, (int)5, (int)10, (int)5);
        ImageIcon imageIcon = this.theApp.loadImageIcon("warning_bullet_icon.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        Constraints.constrain((Container)jPanel, (Component)jButton, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)10, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHostBullet1"), n - 5);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        Constraints.constrain((Container)jPanel, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)-1, (int)1, (int)0, (int)3, (int)18, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        final String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"DeleteHostTitle");
        final String string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"HostBatchDeleted");
        final String string3 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"PercentComplete");
        boolean bl = true;
        ProgressPanel progressPanel = null;
        JProgressBar jProgressBar = null;
        if (bl) {
            int n2 = string.length();
            n2 = Math.max(n2, string2.length());
            n2 = Math.max(n2, 10);
            progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n2, true);
            progressPanel.setRange(0, vector.size());
            progressPanel.setValue(0);
            progressPanel.setTitle(string);
            progressPanel.setText(string);
        } else {
            jProgressBar = new JProgressBar(0, vector.size());
            jProgressBar.setValue(jProgressBar.getMinimum());
            jProgressBar.setStringPainted(true);
            Object[] objectArray = new Object[]{new Integer(jProgressBar.getValue())};
            jProgressBar.setString(MessageFormat.format(string3, objectArray));
        }
        final ProgressPanel progressPanel2 = progressPanel;
        final JProgressBar jProgressBar2 = jProgressBar;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$1).theApp.waitOn();
                        1.access$000(this.this$1).theApp.setStatusBar(1.access$100(this.this$1));
                        1.access$000(this.this$1).theApp.fireConsoleAction(new VConsoleEvent((Object)1.access$000(this.this$1).theApp, "vconsole.updateprogress", (Object)1.access$200(this.this$1)));
                        if (1.access$300(this.this$1) != null) {
                            1.access$300(this.this$1).setVisible(true);
                        }
                        int n = 0;
                        while (n < 1.access$400(this.this$1).size()) {
                            Object[] objectArray;
                            try {
                                objectArray = (Object[])1.access$400(this.this$1).elementAt(n);
                                HostData hostData = (HostData)objectArray.getPayload();
                                if (1.access$300(this.this$1) != null) {
                                    1.access$300(this.this$1).setObjectLabel(hostData.getHostName());
                                }
                                1.access$000(this.this$1).theApp.getHostMgr().deleteHost(hostData);
                                Content.broadcastUpdate(1.access$000(this.this$1).theApp.getContentInstances(), hostData, null, true);
                            }
                            catch (Exception exception) {
                                1.access$000(this.this$1).theApp.reportErrorException(exception);
                            }
                            if (1.access$200(this.this$1) != null) {
                                1.access$200(this.this$1).setValue(n + 1);
                                Object[] objectArray2 = new Object[]{new Integer(1.access$200(this.this$1).getValue() * 100 / 1.access$200(this.this$1).getMaximum())};
                                1.access$200(this.this$1).setString(MessageFormat.format(1.access$500(this.this$1), objectArray2));
                            }
                            if (1.access$300(this.this$1) != null) {
                                1.access$300(this.this$1).setValue(n + 1);
                                objectArray = new Object[]{new Integer(n + 1), new Integer(1.access$400(this.this$1).size())};
                                1.access$300(this.this$1).setText(MessageFormat.format(1.access$600(this.this$1), objectArray));
                            }
                            ++n;
                        }
                        1.access$000(this.this$1).clearSelection();
                        1.access$000(this.this$1).theApp.setStatusBar(ResourceStrings.getString((ResourceBundle)1.access$700(this.this$1), (String)"DeleteHostsDone"));
                        if (1.access$300(this.this$1) != null) {
                            1.access$300(this.this$1).setValue(1.access$300(this.this$1).getValue() + 1);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        1.access$000(this.this$1).theApp.fireConsoleAction(new VConsoleEvent((Object)1.access$000(this.this$1).theApp, "vconsole.updateprogress", null));
                        if (1.access$300(this.this$1) != null) {
                            1.access$300(this.this$1).setVisible(false);
                            1.access$300(this.this$1).dispose();
                        }
                        1.access$000(this.this$1).theApp.waitOff();
                    }
                };
                thread.start();
            }

            static /* synthetic */ HostContent access$000(1 var0) {
                return var0.HostContent.this;
            }

            static /* synthetic */ String access$100(1 var0) {
                return var0.string;
            }

            static /* synthetic */ JProgressBar access$200(1 var0) {
                return var0.jProgressBar2;
            }

            static /* synthetic */ ProgressPanel access$300(1 var0) {
                return var0.progressPanel2;
            }

            static /* synthetic */ Vector access$400(1 var0) {
                return var0.vector;
            }

            static /* synthetic */ String access$500(1 var0) {
                return var0.string3;
            }

            static /* synthetic */ String access$600(1 var0) {
                return var0.string2;
            }

            static /* synthetic */ ResourceBundle access$700(1 var0) {
                return var0.resourceBundle;
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHostTitle"), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Delete"));
    }

    public void renameSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        HostData hostData = (HostData)vScopeNode.getPayload();
        HostRenameDialog hostRenameDialog = new HostRenameDialog(this.theApp, this.theApp.getFrame(), hostData);
        hostRenameDialog.show();
    }

    public void find(Object object) {
        if (this.rootNode.getChildCount() == 0) {
            return;
        }
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            HostData hostData = (HostData)vScopeNode.getPayload();
            if (hostData == (HostData)object) {
                this.clearSelection();
                Vector<VScopeNode> vector = new Vector<VScopeNode>();
                vector.addElement(vScopeNode);
                this.setSelected(vector);
                return;
            }
            ++n;
        }
    }

    public String whatAmI() {
        return "hosts";
    }

    public String getSortAttribute() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return HOST_COLUMN_HOSTNAME;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(1));
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n <= 0) {
            return HOST_COLUMN_HOSTNAME;
        }
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        String string2 = applicationContext.isAdvancedHostPropertiesSupported() ? (String)this.advColumnHeaderConfig[n][0] : (String)this.genColumnHeaderConfig[--n][0];
        return string2;
    }

    public boolean isAscendSort() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return true;
        }
        boolean bl = true;
        if (string.indexOf(45) >= 0) {
            bl = false;
        }
        return bl;
    }

    public String[][] getColumnHeaders() {
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        if (columnHeaders == null) {
            columnHeaders = applicationContext.isAdvancedHostPropertiesSupported() ? this.constructColumnHeaders(this.advColumnHeaderConfig) : this.constructColumnHeaders(this.genColumnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, HostData hostData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_HOSTNAME);
        hashtable.put(string, hostData.getHostName());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_IPADDRESS);
        hashtable.put(string, hostData.getNetworkAddress());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_COMMENT);
        hashtable.put(string, hostData.getDescription());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_ALIASES);
        hashtable.put(string, hostData.getAliases());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_ENETADDRESS);
        hashtable.put(string, hostData.getEthernetAddress());
        return hashtable;
    }

    public String[] getFilterAttributes() {
        return this.filterKeys;
    }

    public Vector getFilters() {
        return this.filters;
    }

    public boolean isFilteringSupported() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)vScopeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        return networkData2 == null && networkData.getNetworkAddress().length() == 0;
    }

    public void setFilters(Vector vector) {
        this.filters = vector;
    }

    public VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new FilterControl();
        }
        return this.filterControl;
    }

    public void refresh() {
        ProgressPanel progressPanel;
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setInfoBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchHostsTitle");
        final String string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"HostBatchReceived");
        String string3 = string + " " + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"RefreshInterrupted");
        final String string4 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"PercentComplete");
        int n = string.length();
        n = Math.max(n, string2.length());
        n = Math.max(n, string3.length());
        n = Math.max(n, 10);
        boolean bl = true;
        ProgressPanel progressPanel2 = null;
        JProgressBar jProgressBar = null;
        if (bl) {
            progressPanel2 = new ProgressPanel(this.theApp.getFrame(), 1, n, true, true);
            progressPanel2.setRange(0, 100);
            progressPanel2.setValue(0);
            progressPanel2.setTitle(string);
            progressPanel2.setText(string);
        } else {
            jProgressBar = new JProgressBar(0, 100);
            jProgressBar.setValue(0);
            jProgressBar.setStringPainted(true);
            progressPanel = new ProgressPanel[]{new Integer(jProgressBar.getValue())};
            jProgressBar.setString(MessageFormat.format(string4, (Object[])progressPanel));
        }
        progressPanel = progressPanel2;
        final JProgressBar jProgressBar2 = jProgressBar;
        if (progressPanel != null) {
            progressPanel.setStopListener(new ActionListener((ListFetch)myListFetch, progressPanel, string3){
                private final /* synthetic */ ListFetch val$listFetch;
                private final /* synthetic */ ProgressPanel val$progressPanel;
                private final /* synthetic */ String val$interruptedMsg;
                {
                    this.val$listFetch = listFetch;
                    this.val$progressPanel = progressPanel;
                    this.val$interruptedMsg = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!this.val$listFetch.isInterrupted()) {
                        this.val$progressPanel.setText(this.val$interruptedMsg);
                        this.val$listFetch.interrupt();
                    }
                }
            });
            progressPanel.show();
        }
        this.treeNode.setResultPane((Component)new VBusyPanel(string));
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode));
        this.theApp.setStatusBar(string);
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updateprogress", (Object)jProgressBar2));
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        final String string5 = vConsoleProperties.getProperty(this.sortPreferencesKey);
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.sortup", null));
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    HostContent.this.theApp.setStatusBar(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchHostsDone"));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (listFetchEvent.getNumReceived() == 0) {
                        HostContent.this.treeNode.setResultPane(null);
                        HostContent.this.theApp.fireConsoleAction(new VConsoleEvent((Object)HostContent.this.theApp, "vconsole.updatescope", (Object)HostContent.this.treeNode));
                    }
                    HostContent.this.updateInfoBar();
                    HostContent.this.showFilteredStatus();
                    HostContent.this.theApp.fireConsoleAction(new VConsoleEvent((Object)HostContent.this.theApp, "vconsole.updateprogress", null));
                    if (string5 != null) {
                        VConsoleProperties vConsoleProperties = HostContent.this.theApp.getProperties();
                        vConsoleProperties.setProperty("vconsole.sortedcolumn", string5);
                        HostContent.this.saveSortPreferences();
                    }
                    if (progressPanel != null) {
                        progressPanel.dispose();
                    }
                    HostContent.this.theApp.waitOff();
                    return;
                }
                if (jProgressBar2 != null && jProgressBar2.getValue() == 0) {
                    HostContent.this.treeNode.setResultPane(null);
                }
                if (progressPanel != null && progressPanel.getValue() == 0) {
                    HostContent.this.treeNode.setResultPane(null);
                }
                if (listFetchEvent.getSize() > 0) {
                    Object[] objectArray;
                    if (listFetchEvent.getNumReceived() >= listFetchEvent.getSize()) {
                        if (jProgressBar2 != null) {
                            jProgressBar2.setValue(100);
                        }
                        if (progressPanel != null) {
                            progressPanel.setValue(100);
                        }
                    } else {
                        if (jProgressBar2 != null) {
                            jProgressBar2.setValue(listFetchEvent.getNumReceived() * 100 / listFetchEvent.getSize());
                        }
                        if (progressPanel != null) {
                            progressPanel.setValue(listFetchEvent.getNumReceived() * 100 / listFetchEvent.getSize());
                        }
                    }
                    if (jProgressBar2 != null) {
                        objectArray = new Object[]{new Integer(jProgressBar2.getValue())};
                        jProgressBar2.setString(MessageFormat.format(string4, objectArray));
                    }
                    if (progressPanel != null) {
                        objectArray = new Object[]{new Integer(listFetchEvent.getNumReceived()), new Integer(listFetchEvent.getSize())};
                        progressPanel.appendText(MessageFormat.format(string2, objectArray));
                    }
                }
                HostContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                HostContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        myListFetch.start();
        this.bRefresh = true;
    }

    private void appendToResultsPane(Vector vector) {
        HostData hostData;
        String string = this.treeNode.getHTMLText();
        int n = 0;
        while (n < vector.size()) {
            hostData = (HostData)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.theApp.getMenuBar().getPopupMenu(), this.smallHostIcon, this.largeHostIcon, hostData.getHostName(), null, null, -1, (Object)hostData);
            vScopeNode.setHTMLText(string);
            vScopeNode.setColumnValues(HostContent.getColumnValues(this.theApp.getResourceBundle(), hostData));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(hostData);
            ++n;
        }
        hostData = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.theApp.fireConsoleAction((VConsoleEvent)hostData);
    }

    private void removeFromResultsPane(HostData hostData) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            HostData hostData2 = (HostData)vScopeNode.getPayload();
            if (hostData2 == hostData) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        this.rootNode.removeAllChildren();
        System.gc();
        if (this.treeNode.getInternalRoot() == null) {
            this.treeNode.setInternalRoot(this.rootNode);
        }
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public boolean offerNew(Object object, boolean bl) {
        if (object == null || !(object instanceof HostData)) {
            return false;
        }
        HostData hostData = (HostData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)vScopeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        NetworkData networkData3 = networkData;
        if (networkData3.getNetworkAddress().length() == 0) {
            networkData3 = networkData2;
        }
        boolean bl2 = true;
        if (networkData3 != null) {
            bl2 = networkData3.belongsNetwork(hostData.getNetworkAddress());
        }
        if (bl || !bl2) {
            return bl2;
        }
        final Vector<HostData> vector = new Vector<HostData>();
        vector.addElement(hostData);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        HostContent.this.appendToResultsPane(vector);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.appendToResultsPane(vector);
        }
        return true;
    }

    public boolean offerDelete(Object object, boolean bl) {
        Serializable serializable;
        Cloneable cloneable;
        if (object != null && !(object instanceof HostData)) {
            return false;
        }
        HostData hostData = (HostData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)vScopeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        NetworkData networkData3 = networkData;
        if (networkData3.getNetworkAddress().length() == 0) {
            networkData3 = networkData2;
        }
        boolean bl2 = true;
        if (networkData3 != null) {
            bl2 = networkData3.belongsNetwork(hostData.getNetworkAddress());
        }
        if (bl || !bl2) {
            return bl2;
        }
        if (this.theApp.getTree().getCurrentContent() == this) {
            this.getDataCache().removeElement(hostData);
        } else {
            cloneable = this.getDataCache();
            int n = 0;
            while (n < ((Vector)cloneable).size()) {
                serializable = (HostData)((Vector)cloneable).elementAt(n);
                if (serializable.equals(hostData)) {
                    hostData = serializable;
                    ((Vector)cloneable).removeElement(serializable);
                    break;
                }
                ++n;
            }
        }
        cloneable = hostData;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable((HostData)cloneable){
                    private final /* synthetic */ HostData val$hd;
                    {
                        this.val$hd = hostData;
                    }

                    public void run() {
                        HostContent.this.removeFromResultsPane(this.val$hd);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.removeFromResultsPane((HostData)cloneable);
        }
        if (networkData.getNetworkAddress().length() == 0 || networkData.isStaticNetwork()) {
            return true;
        }
        final VScopeNode vScopeNode2 = vScopeNode;
        serializable = networkData;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable((NetworkData)serializable){
                    private final /* synthetic */ NetworkData val$nd;
                    {
                        this.val$nd = networkData;
                    }

                    public void run() {
                        HostContent.this.theApp.getTree().removeNetwork(vScopeNode2, this.val$nd);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.theApp.getTree().removeNetwork(vScopeNode2, (NetworkData)serializable);
        }
        return true;
    }

    public void updateInfoBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"HostListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setInfoBar(string2);
    }

    public void updateDefaultColumns() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setPropertyObject("vconsole.defaultcolumnheader", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_HOSTNAME));
        Object[][] objectArray = new Object[][]{{HOST_COLUMN_HOSTNAME, new Integer(16)}};
        String[][] stringArray = this.constructColumnHeaders(objectArray);
        vConsoleProperties.setProperty("vconsole.defaultcolumnwidth", stringArray[0][1]);
    }

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    private int getServerChunkSize() {
        if (this.serverChunkSize != -99999) {
            return this.serverChunkSize;
        }
        try {
            String string = System.getProperty("hostmgr.hosts.ServerChunkSize");
            this.serverChunkSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.serverChunkSize = 1000;
        }
        return this.serverChunkSize;
    }

    private int getDisplayChunkSize() {
        if (this.displayChunkSize != -99999) {
            return this.displayChunkSize;
        }
        try {
            String string = System.getProperty("hostmgr.PreferredDisplayChunkSize");
            this.displayChunkSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.displayChunkSize = 0;
        }
        return this.displayChunkSize;
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper hostMgr;
        NetworkData networkData = null;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            try {
                this.listProps = new ListProperties();
                if (HostContent.this.isAscendSort()) {
                    this.listProps.setSortOrderAscending();
                } else {
                    this.listProps.setSortOrderDescending();
                }
                this.listProps.setSortColumn(HostContent.this.getSortAttribute());
                this.listProps.setChunkSize(n);
                if (HostContent.this.filters != null) {
                    this.listProps.setFilters(HostContent.this.filters);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hostMgr = HostContent.this.theApp.getHostMgr();
            TreeNodeData treeNodeData = (TreeNodeData)HostContent.this.treeNode.getPayload();
            this.networkData = treeNodeData.getNetworkData();
            if (this.networkData.getNetworkAddress().length() == 0) {
                VScopeNode vScopeNode = (VScopeNode)HostContent.this.treeNode.getParent();
                treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                this.networkData = treeNodeData.getNetworkData();
            }
        }

        public int listPrime() throws AdminException {
            if (this.networkData == null) {
                return this.hostMgr.listHostsPrime(this.listProps);
            }
            return this.hostMgr.listHostsByNetworkPrime(this.networkData, this.listProps);
        }

        public Vector listNext() throws AdminException {
            if (this.networkData == null) {
                return this.hostMgr.listHostsNext();
            }
            return this.hostMgr.listHostsByNetworkNext();
        }

        public void listEnd() throws AdminException {
            if (this.networkData == null) {
                this.hostMgr.listHostsEnd();
            } else {
                this.hostMgr.listHostsByNetworkEnd();
            }
        }

        public Vector listAll() throws AdminException {
            if (this.networkData == null) {
                return this.hostMgr.listHosts(this.listProps);
            }
            return this.hostMgr.listHostsByNetwork(this.networkData, this.listProps);
        }

        public void listTrace(String string) {
            HostContent.this.theApp.Trace(string);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)HostContent.this.theApp.getResourceBundle(), (String)"BEANNAME");
        }
    }

    private class FilterControl
    implements VFilter {
        private Vector helpCache = new Vector(12);
        private FilterPanel filterPanel = null;
        private Action filterAction = null;
        private VConsoleProperties properties = null;

        public boolean getFilterEnabled() {
            if (this.filterPanel != null) {
                this.filterPanel.setFilterItems(HostContent.this.getFilters());
            }
            if (this.filterAction != null) {
                Vector vector = HostContent.this.getFilters();
                int n = 0;
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    FilterItem filterItem = (FilterItem)vector.elementAt(n2);
                    n += filterItem.getValue().length();
                    ++n2;
                }
                this.filterAction.setEnabled(n > 0);
            }
            return false;
        }

        public Vector applyFilter(VScopeNode vScopeNode) {
            return null;
        }

        public void clearFilter() {
            this.filterPanel.setDefaultState();
            this.filterAction.setEnabled(false);
        }

        public void setProperties(VConsoleProperties vConsoleProperties) {
            this.properties = vConsoleProperties;
        }

        public void setFilterEnabled(boolean bl) {
            HostContent.this.setFilters(bl ? this.filterPanel.getFilterItems() : new Vector());
            HostContent.this.refresh();
        }

        public void setOptionPane(VOptionPane vOptionPane) {
            if (vOptionPane == null) {
                return;
            }
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ FilterControl this$1;
                {
                    this.this$1 = filterControl;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FilterControl.access$1000(this.this$1).setEnabled(actionEvent.getID() > 0);
                }
            };
            GenInfoPanel genInfoPanel = new GenInfoPanel(vOptionPane);
            this.filterPanel = new FilterPanel(HostContent.this.getFilterAttributes(), "com.sun.admin.hostmgr.client.resources.Resources", this.helpCache, genInfoPanel, actionListener);
            this.filterPanel.setFilterItems(HostContent.this.getFilters());
            vOptionPane.getContentPane().setLayout(new BorderLayout());
            vOptionPane.getContentPane().add((Component)this.filterPanel, "Center");
            vOptionPane.repaint();
        }

        public void setFilterAction(Action action) {
            this.filterAction = action;
        }

        public boolean getFindMode() {
            return false;
        }

        public void setFindMode(boolean bl) {
        }

        static /* synthetic */ Action access$1000(FilterControl filterControl) {
            return filterControl.filterAction;
        }
    }
}

