/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ContentEvent;
import com.sun.admin.hostmgr.client.ContentListener;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.util.ResourceManager;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;

public abstract class Content {
    private Vector listeners = new Vector();
    protected boolean bRefresh = false;
    protected VScopeNode treeNode = null;
    protected VScopeNode rootNode = null;
    protected Vector vDataCache = new Vector();
    protected VHostMgr theApp;

    protected abstract String getSortAttribute();

    protected abstract boolean isAscendSort();

    protected abstract String[][] getColumnHeaders();

    protected abstract void find(Object var1);

    public Content(VHostMgr vHostMgr) {
        this.theApp = vHostMgr;
        vHostMgr.getContentInstances().addElement(this);
    }

    public Vector getSelected() {
        return this.theApp.getDisplayModel().getSelectedNodes();
    }

    public void setSelected(Vector vector) {
        this.theApp.getDisplayModel().setSelectedNodes(vector);
        this.onSelection(vector);
    }

    public void onSelection(Vector vector) {
        this.fireItemPressed(vector.size());
    }

    public int getNumSelections() {
        return this.theApp.getDisplayModel().getSelectedNodes().size();
    }

    public void clearSelection() {
        this.theApp.getDisplayModel().clearSelection();
        this.fireItemPressed(0);
    }

    protected String[][] constructColumnHeaders(Object[][] objectArray) {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        int n = objectArray.length;
        String[][] stringArray = new String[n][3];
        JLabel jLabel = new JLabel();
        jLabel.setFont(ResourceManager.labelFont);
        FontMetrics fontMetrics = jLabel.getFontMetrics(ResourceManager.labelFont);
        jLabel.setFont(ResourceManager.bodyFont);
        FontMetrics fontMetrics2 = jLabel.getFontMetrics(ResourceManager.labelFont);
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectArray[n2][0];
            stringArray[n2][0] = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string);
            int n3 = fontMetrics.stringWidth(stringArray[n2][0]);
            int n4 = fontMetrics2.stringWidth("A");
            stringArray[n2][1] = new String(String.valueOf(Math.max(n3 += fontMetrics.stringWidth("AAAA"), n4 *= ((Integer)objectArray[n2][1]).intValue())));
            ++n2;
        }
        return stringArray;
    }

    public abstract void refresh();

    public abstract void createProperties();

    public abstract void viewProperties();

    public abstract void deleteSelected();

    public void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
        HostActionsListener hostActionsListener = new HostActionsListener(this.theApp);
        hostActionsListener.actionPerformed(actionEvent);
    }

    public void openSelected() {
    }

    public void renameSelected() {
    }

    public abstract String whatAmI();

    protected abstract void updateInfoBar();

    protected abstract void updateDefaultColumns();

    protected abstract void updateSortPreferences();

    protected abstract void saveSortPreferences();

    public String[] getFilterAttributes() {
        return null;
    }

    public Vector getFilters() {
        return null;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public void showFilteredStatus() {
        Vector vector = this.getFilters();
        if (vector == null || vector.size() == 0) {
            this.theApp.getProperties().setProperty("vconsole.filteredstate", "false");
        } else {
            this.theApp.getProperties().setProperty("vconsole.filteredstate", "true");
        }
    }

    public boolean isShowByTypeSupported() {
        return false;
    }

    public void setFilters(Vector vector) {
    }

    public void showByType() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.die();
    }

    public void die() {
        this.theApp.getContentInstances().removeElement(this);
    }

    public int getNumInstances() {
        return this.theApp.getContentInstances().size();
    }

    public Content getInstance(int n) {
        if (n < 0 || n >= this.theApp.getContentInstances().size()) {
            return null;
        }
        return (Content)this.theApp.getContentInstances().elementAt(n);
    }

    public Vector getInstances() {
        return this.theApp.getContentInstances();
    }

    public static void broadcastUpdate(Vector vector, Object object, Object object2, boolean bl) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object2 == null && !bl) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Content content = (Content)vector.elementAt(n);
            if (content.isRefreshed()) {
                if (object != null && object2 != null) {
                    content.offerDelete(object, false);
                    content.offerNew(object2, false);
                } else if (object == null && object2 != null) {
                    content.offerNew(object2, false);
                } else {
                    content.offerDelete(object, false);
                }
            }
            ++n;
        }
    }

    public abstract boolean offerNew(Object var1, boolean var2);

    public abstract boolean offerDelete(Object var1, boolean var2);

    public void setTreeNode(VScopeNode vScopeNode) {
        this.treeNode = vScopeNode;
    }

    public VScopeNode getTreeNode() {
        return this.treeNode;
    }

    public VFilter getFilterControl() {
        return null;
    }

    public VScopeNode getInternalRoot() {
        return this.rootNode;
    }

    public Vector getDataCache() {
        return this.vDataCache;
    }

    public abstract void clear(boolean var1);

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    public synchronized void addContentListener(ContentListener contentListener) {
        this.listeners.addElement(contentListener);
    }

    public synchronized void removeContentListener(ContentListener contentListener) {
        this.listeners.removeElement(contentListener);
    }

    protected void fireItemPressed(int n) {
        ContentEvent contentEvent = new ContentEvent(this, n, this.getSortAttribute(), null);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ContentListener contentListener = (ContentListener)this.listeners.elementAt(n2);
            contentListener.itemPressed(contentEvent);
            ++n2;
        }
    }
}

