/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.compiler.mofc.I18N;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;

class XmlWriter {
    private BufferedWriter xmlOut;
    private BufferedWriter bigxmlOut;
    CIMXml xi = CIMXmlFactory.getCIMXmlImpl();
    private String fileName = "mof.xml";
    private String bigfileName = "bigmof.xml";
    private String className = "";
    private String startTag = "<?xml version=\"1.0\"?>";

    public XmlWriter() {
        I18N.setResourceName("com.sun.wbem.compiler.mofc.Compiler");
    }

    BufferedWriter getFile() {
        return this.xmlOut;
    }

    BufferedWriter getBigFile() {
        return this.bigxmlOut;
    }

    BufferedWriter openXmlFile() {
        try {
            BufferedWriter bufferedWriter;
            File file = new File(this.fileName);
            if (file.exists()) {
                file.delete();
            }
            this.xmlOut = bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            this.writeStartTags(bufferedWriter);
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.fileName));
            System.exit(1);
        }
        return this.xmlOut;
    }

    BufferedWriter openBigXmlFile() {
        try {
            BufferedWriter bufferedWriter;
            File file = new File(this.bigfileName);
            if (file.exists()) {
                file.delete();
            }
            this.bigxmlOut = bufferedWriter = new BufferedWriter(new FileWriter(this.bigfileName, true));
            this.writeBigStartTags(bufferedWriter);
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.fileName));
            System.exit(1);
        }
        return this.bigxmlOut;
    }

    void writeBigStartTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(this.startTag);
            bufferedWriter.newLine();
            bufferedWriter.write("<CIM CIMVERSION=\"2.0\" DTDVERSION=\"2.0\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("<DECLGROUP>");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeStartTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(this.startTag);
            bufferedWriter.newLine();
            bufferedWriter.write("<CLASSES>");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeEndTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("</CLASSES>");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigEndTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("</DECLGROUP>");
            bufferedWriter.newLine();
            bufferedWriter.write("</DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("</CIM>");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeAllClasses(CIMClass cIMClass, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("<CLASS NAME=\"");
            bufferedWriter.write(cIMClass.getName());
            if (cIMClass.getSuperClass().length() != 0) {
                bufferedWriter.write("\" SUPERCLASS=\"");
                bufferedWriter.write(cIMClass.getSuperClass());
            }
            if (cIMClass.isAssociation()) {
                bufferedWriter.write("\" ASSOCIATION=\"true");
            }
            bufferedWriter.write("\" />");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigXml(CIMQualifierType cIMQualifierType, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(this.xi.CIMQualifierTypeToXml(cIMQualifierType));
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigXml(CIMClass cIMClass, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("         <VALUE.OBJECT>");
            bufferedWriter.write(this.xi.CIMClassToXml(cIMClass, true, true, null, true));
            bufferedWriter.write("         </VALUE.OBJECT>");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeClass(CIMClass cIMClass) {
        try {
            this.className = cIMClass.getName() + ".xml";
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(cIMClass.getName() + ".xml", false));
            bufferedWriter.write(this.startTag);
            bufferedWriter.newLine();
            bufferedWriter.write("<CIM CIMVERSION=\"2.0\" DTDVERSION=\"2.0\">");
            bufferedWriter.newLine();
            bufferedWriter.write("   <DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("      <DECLGROUP>");
            bufferedWriter.newLine();
            bufferedWriter.write("         <VALUE.OBJECT>");
            bufferedWriter.newLine();
            bufferedWriter.write(this.xi.CIMClassToXml(cIMClass, true, true, null, true));
            bufferedWriter.write("         </VALUE.OBJECT>");
            bufferedWriter.newLine();
            bufferedWriter.write("      </DECLGROUP>");
            bufferedWriter.newLine();
            bufferedWriter.write("   </DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("</CIM>");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.className));
            System.exit(1);
        }
    }
}

