/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.compiler.mofc.BeanClassWriter;
import com.sun.wbem.compiler.mofc.BeanGeneratorConstants;
import com.sun.wbem.compiler.mofc.BeanInterfaceWriter;
import com.sun.wbem.compiler.mofc.I18N;
import com.sun.wbem.compiler.mofc.JavaDocElement;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;

class BeanGenerator
implements BeanGeneratorConstants {
    private static CIMOMHandle cimomHandle = null;
    private CIMClass cimClass = null;
    private static StringBuffer fileHeader = null;
    private static StringBuffer packageStatement = null;
    private static StringBuffer importStatements = null;
    private static StringBuffer exceptions = null;
    private static StringBuffer invokeMethodExceptions = null;
    private static String[] keywordArr = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private static String lastKeyword = null;
    private static final String invalidChars = "!@#$%^&*(-){[]}+=?/\"'<,>.:;\\|        ";
    private static String packageName = null;
    private static Vector vImports = null;
    private static Vector vExceptions = null;
    private static File outputDir = null;

    public BeanGenerator(CIMOMHandle cIMOMHandle, CIMClass cIMClass, String string, String string2, String string3, File file) {
        cimomHandle = cIMOMHandle;
        this.cimClass = cIMClass;
        packageName = string;
        outputDir = file;
        Debug.trace2((String)("Generating Java Bean source for " + cIMClass.getName()));
        vImports = BeanGenerator.parseColonList(string2);
        vExceptions = BeanGenerator.parseColonList(string3);
        I18N.setResourceName("com.sun.wbem.compiler.mofc.Compiler");
        BeanInterfaceWriter beanInterfaceWriter = new BeanInterfaceWriter(cIMClass);
        BeanClassWriter beanClassWriter = new BeanClassWriter(cIMClass);
    }

    public static void writeToFile(StringBuffer stringBuffer, StringBuffer stringBuffer2, File file) {
        stringBuffer.append(".java");
        Debug.trace3((String)("Generating source file: " + stringBuffer.toString()));
        try {
            File file2 = new File(file.getAbsolutePath(), stringBuffer.toString());
            if (file2.exists()) {
                file2.delete();
            }
            try {
                FileWriter fileWriter = new FileWriter(file2, true);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(stringBuffer2.toString());
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", stringBuffer.toString()));
                System.exit(1);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public static void writeToFile(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        BeanGenerator.writeToFile(stringBuffer, stringBuffer2, outputDir);
    }

    public static String getSuperClass(CIMClass cIMClass) {
        String string = BeanGenerator.getClassName(cIMClass.getSuperClass());
        if (!BeanGenerator.hasContents(string)) {
            string = "CIM";
        }
        return string;
    }

    public static String getClassName(String string) {
        if (!BeanGenerator.hasContents(string)) {
            return string;
        }
        string = BeanGenerator.firstCharUpper(string).toString();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(BeanGenerator.firstCharUpper(string2)).append("_");
        }
        if (stringBuffer.lastIndexOf("_") == stringBuffer.length() - 1) {
            stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.lastIndexOf("_")));
        }
        return stringBuffer.toString();
    }

    public static StringBuffer getAccessorDoc(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating accessor method JavaDoc for property: " + cIMProperty.getOriginClass() + "." + cIMProperty.getName()));
        String string = I18N.loadStringFormat("BEAN_ACCESSOR_JAVADOC", cIMProperty.getOriginClass(), (Object)cIMProperty.getName());
        StringBuffer stringBuffer = BeanGenerator.getPropertyDescription(cIMProperty);
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1 + vExceptions.size());
        JavaDocElement javaDocElement = new JavaDocElement("@return", BeanGenerator.getPropertyDataType(cIMProperty), I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", cIMProperty.getName()));
        vector.addElement(javaDocElement);
        BeanGenerator.addExceptionsToVector(vector, vExceptions);
        StringBuffer stringBuffer2 = BeanGenerator.getJavaDoc(string, stringBuffer, vector, 1);
        return stringBuffer2;
    }

    public static StringBuffer getMutatorDoc(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating mutator method JavaDoc for property: " + cIMProperty.getOriginClass() + "." + cIMProperty.getName()));
        String string = I18N.loadStringFormat("BEAN_MUTATOR_JAVADOC", cIMProperty.getOriginClass(), (Object)cIMProperty.getName());
        StringBuffer stringBuffer = BeanGenerator.getPropertyDescription(cIMProperty);
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1 + vExceptions.size());
        JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getPropertyDataType(cIMProperty), I18N.loadStringFormat("MUTATOR_PARAM_DESCRIPTION", cIMProperty.getName()));
        vector.addElement(javaDocElement);
        BeanGenerator.addExceptionsToVector(vector, vExceptions);
        StringBuffer stringBuffer2 = BeanGenerator.getJavaDoc(string, stringBuffer, vector, 1);
        return stringBuffer2;
    }

    public static StringBuffer getUnitsDoc(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating units accessor method JavaDoc for property: " + cIMProperty.getOriginClass() + "." + cIMProperty.getName()));
        StringBuffer stringBuffer = new StringBuffer();
        if (BeanGenerator.hasQualifier(cIMProperty, "Units")) {
            String string = I18N.loadStringFormat("BEAN_UNITS_JAVADOC", cIMProperty.getOriginClass(), (Object)cIMProperty.getName());
            StringBuffer stringBuffer2 = BeanGenerator.getPropertyDescription(cIMProperty);
            Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1 + vExceptions.size());
            JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadStringFormat("UNITS_RETURN_DESCRIPTION", cIMProperty.getName()));
            vector.addElement(javaDocElement);
            BeanGenerator.addExceptionsToVector(vector, vExceptions);
            stringBuffer.append(BeanGenerator.getJavaDoc(string, stringBuffer2, vector, 1));
        }
        return stringBuffer;
    }

    public static StringBuffer getDisplayNameDoc(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating display name accessor method JavaDoc for property: " + cIMProperty.getOriginClass() + "." + cIMProperty.getName()));
        StringBuffer stringBuffer = new StringBuffer();
        if (BeanGenerator.hasQualifier(cIMProperty, "DisplayName")) {
            String string = I18N.loadStringFormat("BEAN_DISPLAYNAME_JAVADOC", cIMProperty.getOriginClass(), (Object)cIMProperty.getName());
            StringBuffer stringBuffer2 = BeanGenerator.getPropertyDescription(cIMProperty);
            Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1 + vExceptions.size());
            JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadStringFormat("DISPLAYNAME_RETURN_DESCRIPTION", cIMProperty.getName()));
            vector.addElement(javaDocElement);
            BeanGenerator.addExceptionsToVector(vector, vExceptions);
            stringBuffer.append(BeanGenerator.getJavaDoc(string, stringBuffer2, vector, 1));
        }
        return stringBuffer;
    }

    public static StringBuffer getInvokeMethodDoc(CIMMethod cIMMethod) {
        Debug.trace3((String)("Generating invokeMethod JavaDoc for property: " + cIMMethod.getOriginClass() + "." + cIMMethod.getName()));
        String string = I18N.loadStringFormat("BEAN_INVOKEMETHOD_JAVADOC", cIMMethod.getOriginClass(), (Object)cIMMethod.getName());
        StringBuffer stringBuffer = BeanGenerator.getMethodDescription(cIMMethod);
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1 + vExceptions.size());
        JavaDocElement javaDocElement = new JavaDocElement("@return", BeanGenerator.getDataType(cIMMethod.getType()), I18N.loadStringFormat("INVOKEMETHOD_RETURN_DESCRIPTION", cIMMethod.getName()));
        vector.addElement(javaDocElement);
        BeanGenerator.addExceptionsToVector(vector, vExceptions);
        BeanGenerator.insertParamsInVector(vector, cIMMethod.getParameters());
        StringBuffer stringBuffer2 = BeanGenerator.getJavaDoc(string, stringBuffer, vector, 1);
        return stringBuffer2;
    }

    public static StringBuffer getFileHeader() {
        Debug.trace3((String)"Generating file header");
        if (!BeanGenerator.hasContents(fileHeader)) {
            String string = new Date().toString();
            String string2 = BeanGenerator.format("{0}.{1}.{2}", Integer.toString(2), Integer.toString(5), Integer.toString(0));
            fileHeader = BeanGenerator.getJavaDoc(I18N.loadStringFormat("FILE_HEADER", string2, (Object)string), new StringBuffer(), null, 0).append("\n");
        }
        return fileHeader;
    }

    public static StringBuffer getPackageStatement(String string) {
        Debug.trace3((String)"Generating package statement");
        StringBuffer stringBuffer = new StringBuffer(BeanGenerator.format("package {0};\n", string)).append("\n");
        return stringBuffer;
    }

    public static StringBuffer getPackageStatement() {
        if (!BeanGenerator.hasContents(packageStatement)) {
            packageStatement = BeanGenerator.getPackageStatement(packageName);
        }
        return packageStatement;
    }

    public static StringBuffer getImportStatements(Vector vector) {
        Debug.trace3((String)"Generating import statement(s)");
        StringBuffer stringBuffer = new StringBuffer("import javax.wbem.client.*;\nimport javax.wbem.cim.*;\nimport java.util.*;\n");
        if (BeanGenerator.hasContents(vector)) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append(BeanGenerator.format("import {0};\n", string));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer;
    }

    public static StringBuffer getImportStatements() {
        if (!BeanGenerator.hasContents(importStatements)) {
            importStatements = BeanGenerator.getImportStatements(vImports);
        }
        return importStatements;
    }

    public static StringBuffer getPropertyDescription(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating description for property: " + cIMProperty.getOriginClass() + "." + cIMProperty.getName()));
        StringBuffer stringBuffer = new StringBuffer();
        if (BeanGenerator.hasQualifier(cIMProperty, "Description")) {
            stringBuffer.append(BeanGenerator.replaceNewlines((String)cIMProperty.getQualifier("Description").getValue().getValue()));
        }
        return stringBuffer;
    }

    private static boolean hasProperty(Vector vector, CIMProperty cIMProperty) {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        String string = cIMProperty.getName();
        while (enumeration.hasMoreElements() && !bl) {
            CIMProperty cIMProperty2 = (CIMProperty)enumeration.nextElement();
            if (!string.equalsIgnoreCase(cIMProperty2.getName())) continue;
            bl = true;
        }
        return bl;
    }

    public static StringBuffer getOverriddenDataType(CIMClass cIMClass, CIMProperty cIMProperty) {
        CIMClass cIMClass2 = null;
        CIMProperty cIMProperty2 = null;
        String string = cIMProperty.getName();
        if (BeanGenerator.hasQualifier(cIMProperty, "Override")) {
            string = BeanGenerator.getQualifier(cIMProperty, "Override");
        }
        String[] stringArray = new String[]{string};
        String string2 = cIMClass.getSuperClass();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string2);
        while (cIMProperty2 == null || BeanGenerator.hasQualifier(cIMProperty2, "Override")) {
            try {
                cIMClass2 = cimomHandle.getClass(cIMObjectPath, true, true, true, stringArray);
                cIMProperty2 = cIMClass2.getProperty(stringArray[0]);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
            string2 = cIMClass2.getSuperClass();
            cIMObjectPath = new CIMObjectPath(string2);
        }
        return BeanGenerator.getPropertyDataType(cIMProperty2);
    }

    public static StringBuffer getPropertyDataType(CIMProperty cIMProperty) {
        StringBuffer stringBuffer = BeanGenerator.getDataType(cIMProperty.getType());
        if ((BeanGenerator.hasQualifier(cIMProperty, "ValueMap") || BeanGenerator.hasQualifier(cIMProperty, "Values")) && BeanGenerator.isArrayType(stringBuffer)) {
            stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.length() - 2));
        }
        return stringBuffer;
    }

    public static boolean isArrayType(StringBuffer stringBuffer) {
        return stringBuffer.indexOf("[]") > 0;
    }

    public static boolean hasQualifier(CIMParameter cIMParameter, String string) {
        CIMQualifier cIMQualifier = cIMParameter.getQualifier(string);
        return cIMQualifier != null;
    }

    public static boolean hasQualifier(CIMProperty cIMProperty, String string) {
        CIMQualifier cIMQualifier = cIMProperty.getQualifier(string);
        return cIMQualifier != null;
    }

    public static boolean hasQualifier(CIMMethod cIMMethod, String string) {
        CIMQualifier cIMQualifier = cIMMethod.getQualifier(string);
        return cIMQualifier != null;
    }

    public static boolean hasQualifier(CIMClass cIMClass, String string) {
        CIMQualifier cIMQualifier = cIMClass.getQualifier(string);
        return cIMQualifier != null;
    }

    public static String getQualifier(CIMProperty cIMProperty, String string) {
        String string2 = "";
        if (BeanGenerator.hasQualifier(cIMProperty, string)) {
            string2 = (String)cIMProperty.getQualifier(string).getValue().getValue();
        }
        return string2;
    }

    public static String getQualifier(CIMClass cIMClass, String string) {
        String string2 = "";
        if (BeanGenerator.hasQualifier(cIMClass, string)) {
            string2 = (String)cIMClass.getQualifier(string).getValue().getValue();
        }
        return string2;
    }

    public static StringBuffer getMethodDescription(CIMMethod cIMMethod) {
        Debug.trace3((String)("Generating description for method: " + cIMMethod.getOriginClass() + "." + cIMMethod.getName()));
        StringBuffer stringBuffer = new StringBuffer();
        if (BeanGenerator.hasQualifier(cIMMethod, "Description")) {
            stringBuffer.append(BeanGenerator.replaceNewlines((String)cIMMethod.getQualifier("Description").getValue().getValue()));
        }
        return stringBuffer;
    }

    public static StringBuffer getClassDescription(CIMClass cIMClass) {
        Debug.trace3((String)("Generating description for class: " + cIMClass.getName()));
        StringBuffer stringBuffer = new StringBuffer();
        if (BeanGenerator.hasQualifier(cIMClass, "Description")) {
            stringBuffer.append(BeanGenerator.replaceNewlines((String)cIMClass.getQualifier("Description").getValue().getValue()));
        }
        return stringBuffer;
    }

    private static String replaceNewlines(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf("\n");
        while (n > -1) {
            stringBuffer.replace(n, n + 1, " ");
            n = stringBuffer.indexOf("\n");
        }
        return stringBuffer.toString();
    }

    public static StringBuffer getInvokeMethodParams(CIMMethod cIMMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = cIMMethod.getParameters();
        if (!BeanGenerator.hasContents(vector)) {
            return stringBuffer;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            if (!BeanGenerator.isInParameter(cIMParameter)) continue;
            boolean bl = BeanGenerator.hasQualifier(cIMParameter, "Values") || BeanGenerator.hasQualifier(cIMParameter, "ValueMap");
            StringBuffer stringBuffer2 = BeanGenerator.getDataType(cIMParameter.getType());
            if (bl) {
                stringBuffer2 = BeanGenerator.isArrayType(stringBuffer2) ? new StringBuffer("String[]") : new StringBuffer("String");
            }
            stringBuffer.append(BeanGenerator.format("{0} {1}, ", stringBuffer2.toString(), BeanGenerator.getParameterName(cIMParameter.getName())));
        }
        if (BeanGenerator.hasOutParameter(cIMMethod)) {
            stringBuffer.append(BeanGenerator.format("{0} {1}", BeanGenerator.getOutputInterfaceName(cIMMethod).toString() + "[]", BeanGenerator.getOutputParameterName(cIMMethod).toString()));
        } else {
            stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.lastIndexOf(",")));
        }
        return stringBuffer;
    }

    public static String getParameterName(String string) {
        if (BeanGenerator.isKeyword(string = BeanGenerator.firstCharLower(string).toString())) {
            string = BeanGenerator.firstCharUpper(string).toString();
        }
        return string;
    }

    public static Vector getConstantNames(CIMProperty cIMProperty, String string) {
        Vector vector = BeanGenerator.getValuesConstantValues(cIMProperty);
        return BeanGenerator.getConstantNames(vector, string);
    }

    public static Vector getConstantNames(CIMParameter cIMParameter, String string) {
        Vector vector = BeanGenerator.getValuesConstantValues(cIMParameter);
        return BeanGenerator.getConstantNames(vector, string);
    }

    public static Vector getConstantNames(Vector vector, String string) {
        if (BeanGenerator.hasContents(vector)) {
            Vector<String> vector2 = new Vector<String>(vector.size());
            Enumeration enumeration = vector.elements();
            String string2 = "";
            while (enumeration.hasMoreElements()) {
                String string3 = BeanGenerator.replacePlus((String)enumeration.nextElement());
                StringTokenizer stringTokenizer = new StringTokenizer(string3, invalidChars);
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = string2 + stringTokenizer.nextToken() + "_";
                }
                int n = string2.lastIndexOf("_");
                if (n > 0) {
                    string2 = string2.substring(0, n);
                }
                string2 = string2.toUpperCase();
                int n2 = 1;
                String string4 = new String(string2);
                while (vector2.contains(string2)) {
                    string2 = new String(string4 + Integer.toString(n2));
                    ++n2;
                }
                vector2.addElement(new String(string2));
                string2 = "";
            }
            vector = BeanGenerator.prependPrefix(vector2, string);
        }
        return vector;
    }

    public static Vector getValuesConstantValues(CIMProperty cIMProperty) {
        Vector vector = new Vector();
        boolean bl = BeanGenerator.hasQualifier(cIMProperty, "ValueMap");
        boolean bl2 = BeanGenerator.hasQualifier(cIMProperty, "Values");
        if (bl2) {
            vector = (Vector)cIMProperty.getQualifier("Values").getValue().getValue();
        } else if (bl) {
            vector = (Vector)cIMProperty.getQualifier("ValueMap").getValue().getValue();
        }
        return vector;
    }

    public static Vector getValuesConstantValues(CIMParameter cIMParameter) {
        Vector vector = new Vector();
        boolean bl = BeanGenerator.hasQualifier(cIMParameter, "ValueMap");
        boolean bl2 = BeanGenerator.hasQualifier(cIMParameter, "Values");
        if (bl2) {
            vector = (Vector)cIMParameter.getQualifier("Values").getValue().getValue();
        } else if (bl) {
            vector = (Vector)cIMParameter.getQualifier("ValueMap").getValue().getValue();
        }
        return vector;
    }

    public static Vector getValueMapConstantValues(CIMProperty cIMProperty) {
        Vector vector = new Vector();
        if (BeanGenerator.hasQualifier(cIMProperty, "ValueMap")) {
            vector = (Vector)cIMProperty.getQualifier("ValueMap").getValue().getValue();
        } else {
            Vector vector2 = (Vector)cIMProperty.getQualifier("Values").getValue().getValue();
            vector = BeanGenerator.generateValueMap(vector2.size());
        }
        return vector;
    }

    public static Vector getValueMapConstantValues(CIMParameter cIMParameter) {
        Vector vector = new Vector();
        if (BeanGenerator.hasQualifier(cIMParameter, "ValueMap")) {
            vector = (Vector)cIMParameter.getQualifier("ValueMap").getValue().getValue();
        } else {
            Vector vector2 = (Vector)cIMParameter.getQualifier("Values").getValue().getValue();
            vector = BeanGenerator.generateValueMap(vector2.size());
        }
        return vector;
    }

    private static Vector generateValueMap(int n) {
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(Integer.toString(n2));
            ++n2;
        }
        return vector;
    }

    private static String replacePlus(String string) {
        if (string.indexOf(43) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken()).append("plus");
        }
        return stringBuffer.toString();
    }

    private static Vector prependPrefix(Vector vector, String string) {
        Vector<String> vector2 = new Vector<String>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = new String(string + (String)enumeration.nextElement());
            vector2.addElement(string2);
        }
        return vector2;
    }

    public static boolean isInParameter(CIMParameter cIMParameter) {
        return BeanGenerator.hasQualifier(cIMParameter, "IN");
    }

    public static boolean isOutParameter(CIMParameter cIMParameter) {
        return BeanGenerator.hasQualifier(cIMParameter, "OUT");
    }

    public static boolean hasInParameter(CIMMethod cIMMethod) {
        return BeanGenerator.getInParameters(cIMMethod).size() > 0;
    }

    public static boolean hasOutParameter(CIMMethod cIMMethod) {
        return BeanGenerator.getOutParameters(cIMMethod).size() > 0;
    }

    public static Vector getInParameters(CIMMethod cIMMethod) {
        Vector<CIMParameter> vector = new Vector<CIMParameter>();
        Vector vector2 = cIMMethod.getParameters();
        if (!BeanGenerator.hasContents(vector2)) {
            return vector;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            if (!BeanGenerator.isInParameter(cIMParameter)) continue;
            vector.addElement(cIMParameter);
        }
        return vector;
    }

    public static Vector getOutParameters(CIMMethod cIMMethod) {
        Vector<CIMParameter> vector = new Vector<CIMParameter>();
        Vector vector2 = cIMMethod.getParameters();
        if (!BeanGenerator.hasContents(vector2)) {
            return vector;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            if (!BeanGenerator.isOutParameter(cIMParameter)) continue;
            vector.addElement(cIMParameter);
        }
        return vector;
    }

    private static boolean isKeyword(String string) {
        if (BeanGenerator.hasContents(lastKeyword) && lastKeyword.equals(string)) {
            return true;
        }
        boolean bl = false;
        int n = 0;
        while (n < keywordArr.length) {
            if (string.equals(keywordArr[n])) {
                lastKeyword = keywordArr[n];
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static StringBuffer getOutputClassName(CIMMethod cIMMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BeanGenerator.format("{0}_{1}OutputImpl", cIMMethod.getOriginClass(), BeanGenerator.firstCharUpper(cIMMethod.getName()).toString()));
        return stringBuffer;
    }

    public static StringBuffer getOutputInterfaceName(CIMMethod cIMMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BeanGenerator.format("{0}_{1}Output", cIMMethod.getOriginClass(), BeanGenerator.firstCharUpper(cIMMethod.getName()).toString()));
        return stringBuffer;
    }

    public static StringBuffer getOutputParameterName(CIMMethod cIMMethod) {
        StringBuffer stringBuffer = BeanGenerator.firstCharLower(BeanGenerator.getOutputInterfaceName(cIMMethod).toString());
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        return stringBuffer2;
    }

    public static StringBuffer getPropertyName(CIMProperty cIMProperty) {
        return BeanGenerator.firstCharLower(cIMProperty.getName());
    }

    public static StringBuffer getParameterName(CIMParameter cIMParameter) {
        return new StringBuffer(BeanGenerator.getParameterName(cIMParameter.getName()));
    }

    public static StringBuffer firstCharUpper(String string) {
        String string2 = string.substring(0, 1);
        StringBuffer stringBuffer = new StringBuffer(string2.toUpperCase());
        return stringBuffer.append(string.substring(1));
    }

    public static StringBuffer firstCharLower(String string) {
        String string2 = string.substring(0, 1);
        StringBuffer stringBuffer = new StringBuffer(string2.toLowerCase());
        return stringBuffer.append(string.substring(1));
    }

    public static boolean hasContents(Vector vector) {
        return vector != null && vector.size() > 0;
    }

    public static boolean hasContents(String string) {
        return string != null && !string.equals("");
    }

    public static boolean hasContents(StringBuffer stringBuffer) {
        return stringBuffer != null && stringBuffer.length() > 0;
    }

    private static StringBuffer getWrappedString(StringBuffer stringBuffer, StringBuffer stringBuffer2, int n) {
        int n2 = 80 - n - 1;
        int n3 = 80 - BeanGenerator.getTokenLength(stringBuffer2.toString()) - 1;
        if (BeanGenerator.getTokenLength(stringBuffer.toString()) < n2) {
            return stringBuffer;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " ");
        StringBuffer stringBuffer3 = new StringBuffer();
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        StringBuffer stringBuffer4 = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            while (BeanGenerator.hasOneQuote(string) && stringTokenizer.hasMoreTokens()) {
                string = string + " " + stringTokenizer.nextToken();
            }
            n4 = BeanGenerator.getTokenLength(string);
            if (!bl && n4 > n2 || !bl && n4 + n5 < n2 || bl && n4 + n5 < n3) {
                stringBuffer4.append(string);
                stringBuffer4.append(" ");
            } else {
                bl = true;
                stringBuffer4.append(stringBuffer2);
                stringBuffer3.append(stringBuffer4);
                stringBuffer4 = new StringBuffer(string);
                stringBuffer4.append(" ");
            }
            n5 = BeanGenerator.getTokenLength(stringBuffer4.toString());
        }
        if (stringBuffer4.toString().endsWith("\n ")) {
            stringBuffer4 = new StringBuffer(stringBuffer4.substring(0, stringBuffer4.length() - 1));
        }
        stringBuffer3.append(stringBuffer4);
        return stringBuffer3;
    }

    private static boolean hasOneQuote(String string) {
        int n = string.indexOf("\"");
        int n2 = string.lastIndexOf("\"");
        return n > -1 && n == n2;
    }

    private static int getTokenLength(String string) {
        int n = 0;
        if (string == null || string.length() == 0) {
            return n;
        }
        int n2 = 0;
        n = string.indexOf("\t", n);
        while (n > -1) {
            n = string.indexOf("\t", n + 1);
            ++n2;
        }
        return 8 * n2 - n2 + string.length();
    }

    public static StringBuffer getIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append("\t");
            ++n3;
        }
        if (n % 2 != 0) {
            stringBuffer.append("    ");
        }
        return stringBuffer;
    }

    public static StringBuffer getSourceLine(String string, int n) {
        StringBuffer stringBuffer = BeanGenerator.getIndentString(n);
        StringBuffer stringBuffer2 = BeanGenerator.getBreakString(string, n);
        return stringBuffer.append(BeanGenerator.getWrappedString(new StringBuffer(string), stringBuffer2, BeanGenerator.getTokenLength(stringBuffer.toString())));
    }

    private static StringBuffer getBreakString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(BeanGenerator.getIndentString(n + 1));
        if (string.indexOf("//") > -1) {
            stringBuffer.append("//").append(" ");
        }
        return stringBuffer;
    }

    public static StringBuffer getJavaDoc(String string, StringBuffer stringBuffer, Vector vector, int n) {
        StringBuffer stringBuffer2 = BeanGenerator.getIndentString(n);
        StringBuffer stringBuffer3 = new StringBuffer(stringBuffer2.toString());
        stringBuffer3.append("/**\n");
        stringBuffer2.append(" ");
        stringBuffer3.append(stringBuffer2).append("* ");
        int n2 = BeanGenerator.getTokenLength(stringBuffer2.toString()) + "* ".length();
        StringBuffer stringBuffer4 = new StringBuffer("\n");
        stringBuffer4.append(stringBuffer2).append("* ");
        stringBuffer3.append(BeanGenerator.getWrappedString(new StringBuffer(string), stringBuffer4, n2));
        if (BeanGenerator.hasContents(stringBuffer)) {
            stringBuffer3.append(stringBuffer4).append(stringBuffer4);
            stringBuffer3.append(BeanGenerator.getWrappedString(stringBuffer, stringBuffer4, n2));
        }
        if (BeanGenerator.hasContents(vector)) {
            stringBuffer3.append(stringBuffer4);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                JavaDocElement javaDocElement = (JavaDocElement)enumeration.nextElement();
                stringBuffer3.append(stringBuffer4);
                stringBuffer3.append(BeanGenerator.getWrappedString(new StringBuffer(BeanGenerator.format("{0}\t{1}\t{2}", javaDocElement.getTag().toString(), javaDocElement.getType().toString(), javaDocElement.getDescription())), stringBuffer4, n2));
            }
        }
        stringBuffer3.append("\n").append(stringBuffer2).append("*/\n");
        return stringBuffer3;
    }

    public static Vector parseColonList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public static StringBuffer getDataType(CIMDataType cIMDataType) {
        switch (cIMDataType.getType()) {
            case 9: {
                return new StringBuffer("Boolean");
            }
            case 23: {
                return new StringBuffer("Boolean[]");
            }
            case 13: {
                return new StringBuffer("Character");
            }
            case 27: {
                return new StringBuffer("Character[]");
            }
            case 12: {
                return new StringBuffer("CIMDateTime");
            }
            case 10: {
                return new StringBuffer("Float");
            }
            case 24: {
                return new StringBuffer("Float[]");
            }
            case 11: {
                return new StringBuffer("Double");
            }
            case 25: {
                return new StringBuffer("Double[]");
            }
            case 1: {
                return new StringBuffer("Byte");
            }
            case 15: {
                return new StringBuffer("Byte[]");
            }
            case 3: {
                return new StringBuffer("Short");
            }
            case 17: {
                return new StringBuffer("Short[]");
            }
            case 5: {
                return new StringBuffer("Integer");
            }
            case 19: {
                return new StringBuffer("Integer[]");
            }
            case 7: {
                return new StringBuffer("Long");
            }
            case 21: {
                return new StringBuffer("Long[]");
            }
            case 8: {
                return new StringBuffer("String");
            }
            case 22: {
                return new StringBuffer("String[]");
            }
            case 0: {
                return new StringBuffer("UnsignedInt8");
            }
            case 14: {
                return new StringBuffer("UnsignedInt8[]");
            }
            case 2: {
                return new StringBuffer("UnsignedInt16");
            }
            case 16: {
                return new StringBuffer("UnsignedInt16[]");
            }
            case 4: {
                return new StringBuffer("UnsignedInt32");
            }
            case 18: {
                return new StringBuffer("UnsignedInt32[]");
            }
            case 6: {
                return new StringBuffer("UnsignedInt64");
            }
            case 20: {
                return new StringBuffer("UnsignedInt64[]");
            }
        }
        if (cIMDataType.isReferenceType()) {
            return new StringBuffer(cIMDataType.getRefClassName()).append("Bean");
        }
        return new StringBuffer("UNKNOWN DATATYPE: ").append(cIMDataType.toString());
    }

    private static void addExceptionsToVector(Vector vector, Vector vector2) {
        if (vector.capacity() > 1) {
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JavaDocElement javaDocElement = new JavaDocElement("@exception", new StringBuffer(string), "");
                vector.addElement(javaDocElement);
            }
        }
    }

    private static void insertParamsInVector(Vector vector, Vector vector2) {
        if (!BeanGenerator.hasContents(vector2)) {
            return;
        }
        Enumeration enumeration = vector2.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            if (!BeanGenerator.isInParameter(cIMParameter)) continue;
            JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getDataType(cIMParameter.getType()), I18N.loadStringFormat("INVOKEMETHOD_PARAM_DESCRIPTION", cIMParameter.getName()));
            vector.insertElementAt(javaDocElement, n);
            ++n;
        }
    }

    public static StringBuffer getExceptions() {
        if (!BeanGenerator.hasContents(exceptions) && BeanGenerator.hasContents(vExceptions)) {
            exceptions = new StringBuffer(" throws ");
            Enumeration enumeration = vExceptions.elements();
            while (enumeration.hasMoreElements()) {
                exceptions.append((String)enumeration.nextElement());
                exceptions.append(", ");
            }
            exceptions = new StringBuffer(exceptions.substring(0, exceptions.length() - 2));
        }
        return exceptions;
    }

    public static StringBuffer getInvokeMethodExceptions() {
        if (!BeanGenerator.hasContents(invokeMethodExceptions)) {
            if (!BeanGenerator.hasContents(BeanGenerator.getExceptions())) {
                invokeMethodExceptions = new StringBuffer("throws CIMException");
            } else {
                invokeMethodExceptions = new StringBuffer(BeanGenerator.getExceptions().toString());
                invokeMethodExceptions.append(", ").append("CIMException");
            }
        }
        return invokeMethodExceptions;
    }

    public static String format(String string, String string2) {
        Object[] objectArray = new String[]{string2};
        return MessageFormat.format(string, objectArray);
    }

    public static String format(String string, String string2, String string3) {
        Object[] objectArray = new String[]{string2, string3};
        return MessageFormat.format(string, objectArray);
    }

    public static String format(String string, String string2, String string3, String string4) {
        Object[] objectArray = new String[]{string2, string3, string4};
        return MessageFormat.format(string, objectArray);
    }

    public static String format(String string, String string2, String string3, String string4, String string5) {
        Object[] objectArray = new String[]{string2, string3, string4, string5};
        return MessageFormat.format(string, objectArray);
    }
}

