/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.ASTMibs;
import com.sun.wbem.compiler.mib2mof.CimCodeGenerator;
import com.sun.wbem.compiler.mib2mof.CodeGenerator;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.ModulesHandler;
import com.sun.wbem.compiler.mib2mof.ParseException;
import com.sun.wbem.compiler.mib2mof.Parser;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.StoreGenerator;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class Mib2Mof {
    private String program;
    private OutputStream out;
    private String specificPackageName = "";
    private String targetDir = ".";
    private String prefix = "";
    private boolean generateCode = true;
    private boolean generateMgrCode = false;
    private boolean generateMgrCodeOnly = false;
    private boolean standAlone = false;
    private boolean forAll = false;
    private String lastFile = "";
    private ASTMibs lastMib;
    private boolean status = true;
    private boolean commentRequested = false;
    private boolean defaultMibCore = true;
    private boolean usageWanted = false;
    private Vector fileList;
    private static final String SOLARIS_MIB_CORE_DIR = "/usr/sadm/mof/";
    private static final String MIB_CORE_FILE = "Solaris_SNMPmib_core.txt";
    private static final String sccs_id = "@(#)Mib2Mof.java 4.12 11/17/99 SMI";

    private Mib2Mof(OutputStream outputStream, String string) {
        this.out = outputStream;
        Trace.setOutput(this.out);
        this.program = string;
    }

    private void output(String string) {
        try {
            int n = 0;
            while (n < string.length()) {
                this.out.write(string.charAt(n));
                ++n;
            }
            this.out.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int error(String string) {
        Trace.error(string);
        Trace.info(MessageHandler.getMessage("compile.error.stop"));
        return 1;
    }

    private void usage() {
        Trace.info("Usage: " + this.program + " <options> <mib files>");
        Trace.info("\n" + MessageHandler.getMessage("usage.where"));
        Trace.info("  -n\t\t" + MessageHandler.getMessage("usage.n"));
        Trace.info("  -d <dir>\t" + MessageHandler.getMessage("usage.dir"));
        Trace.info("  -q\t\t" + MessageHandler.getMessage("usage.q"));
        Trace.info("  -c\t\t" + MessageHandler.getMessage("usage.c"));
        Trace.info("  -a\t\t" + MessageHandler.getMessage("usage.a"));
        Trace.info("  -h\t\t" + MessageHandler.getMessage("usage.h"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseArgs(String[] stringArray) {
        this.fileList = new Vector();
        boolean bl = false;
        if (stringArray.length == 0) {
            this.usageWanted = true;
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                if (n + 1 >= stringArray.length) {
                    Trace.error(MessageHandler.getMessage("compile.error.option.level", "-d"));
                    return false;
                }
                this.targetDir = stringArray[++n];
            } else if (stringArray[n].equals("-n")) {
                bl = true;
                this.generateCode = false;
                this.generateMgrCode = false;
            } else if (stringArray[n].equals("-a")) {
                this.forAll = true;
            } else {
                if (stringArray[n].equals("-h")) {
                    this.usageWanted = true;
                    return false;
                }
                if (stringArray[n].equals("-q")) {
                    this.commentRequested = true;
                } else if (stringArray[n].equals("-c")) {
                    this.defaultMibCore = false;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        Trace.error(MessageHandler.getMessage("compile.error.option.invalid", stringArray[n]));
                        return false;
                    }
                    this.fileList.addElement(stringArray[n]);
                    this.lastFile = stringArray[n];
                }
            }
            ++n;
        }
        return this.validTargetDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private synchronized boolean doCompile() {
        var3_1 = true;
        var4_2 = null;
        var5_3 = new ModulesHandler();
        var6_4 = null;
        if (this.defaultMibCore) {
            block31: {
                var7_5 = "Solaris_SNMPmib_core.txt";
                try {
                    var4_2 = new FileInputStream(var7_5);
                    var11_7 = null;
                    ** if (var4_2 == null) goto lbl-1000
                }
                catch (Throwable var10_19) {
                    var11_8 = null;
                    if (var4_2 != null) {
                        try {
                            var4_2.close();
                        }
                        catch (IOException var12_11) {
                            // empty catch block
                        }
                    }
                    throw var10_19;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var4_2.close();
                    }
                    catch (IOException var12_10) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block31;
                    catch (FileNotFoundException var8_12) {
                        var7_5 = "/usr/sadm/mof/Solaris_SNMPmib_core.txt";
                        var11_7 = null;
                        if (var4_2 != null) {
                            try {
                                var4_2.close();
                            }
                            catch (IOException var12_10) {}
                        }
                        break block31;
                    }
                    catch (Exception var9_14) {
                        var11_7 = null;
                        if (var4_2 != null) {
                            try {
                                var4_2.close();
                            }
                            catch (IOException var12_10) {}
                        }
                    }
                }
            }
            Trace.info(MessageHandler.getMessage("compile.info.start.mibcore", var7_5));
            var8_13 = null;
            try {
                var8_13 = new Parser(new FileInputStream(var7_5));
                var6_4 = var8_13.Mibs(var5_3);
            }
            catch (FileNotFoundException var9_15) {
                Trace.warning(MessageHandler.getMessage("compile.error.noMibCoreFile", var7_5));
            }
            catch (ParseException var10_20) {
                Trace.error(var10_20.getMessage());
                var3_1 = false;
            }
            catch (Exception var11_9) {
                if (var11_9 instanceof RuntimeException) {
                    throw (RuntimeException)var11_9;
                }
                Trace.error(var11_9.getMessage());
                var3_1 = false;
            }
        }
        var7_6 = this.fileList.size() - 1;
        while (var7_6 >= 0) {
            var1_23 = (String)this.fileList.elementAt(var7_6);
            Trace.info(MessageHandler.getMessage("compile.info.start", var1_23));
            var8_13 = null;
            try {
                var8_13 = new Parser(new FileInputStream(var1_23));
            }
            catch (FileNotFoundException var9_17) {
                Trace.error(MessageHandler.getMessage("compile.error.noFile", var1_23));
                return false;
            }
            try {
                var9_16 /* !! */  = var8_13.Mibs(var5_3);
                this.lastMib = var9_16 /* !! */ ;
            }
            catch (ParseException var9_18) {
                Trace.error(var9_18.getMessage());
                var3_1 = false;
            }
            catch (Exception var10_22) {
                if (var10_22 instanceof RuntimeException) {
                    throw (RuntimeException)var10_22;
                }
                Trace.error(var10_22.getMessage());
                var3_1 = false;
            }
            --var7_6;
        }
        if (!var5_3.resolve()) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        if (!var5_3.buildMibTrees()) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        if (this.defaultMibCore && var6_4 != null) {
            var8_13 = var6_4.mibElements();
            while (var8_13.hasMoreElements()) {
                var9_16 /* !! */  = (ASTMib)var8_13.nextElement();
                var5_3.removeMibModule(var9_16 /* !! */ .getModuleName());
            }
        }
        this.status = this.generateMofCode(var5_3) != false && var3_1 != false;
        return this.status;
    }

    private boolean generateAgentCode(ModulesHandler modulesHandler) {
        if (!this.generateCode) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        boolean bl = true;
        CodeGenerator codeGenerator = new CodeGenerator(new ResourceManager(), this.specificPackageName, this.prefix, this.targetDir);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setDescriptionHandling(this.commentRequested);
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.agent", aSTMib.getModuleName()));
            try {
                codeGenerator.generateCode(aSTMib);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean generateMgrCode(ModulesHandler modulesHandler) {
        if (!this.generateMgrCode && !this.generateMgrCodeOnly) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        StoreGenerator storeGenerator = new StoreGenerator(new ResourceManager(), this.specificPackageName, this.prefix, this.targetDir);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.oidtable", aSTMib.getModuleName()));
            try {
                storeGenerator.generateCode(aSTMib);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean generateMofCode(ModulesHandler modulesHandler) {
        if (!this.generateCode) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        boolean bl = true;
        CimCodeGenerator cimCodeGenerator = new CimCodeGenerator(new ResourceManager(), this.specificPackageName, this.prefix, this.targetDir);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setDescriptionHandling(this.commentRequested);
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.agent", aSTMib.getModuleName()));
            try {
                cimCodeGenerator.generateCode(aSTMib);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    private void run() {
        if (this.fileList != null && this.fileList.size() > 0) {
            this.status = this.doCompile();
        }
    }

    public static void main(String[] stringArray) {
        String string = MessageHandler.getMessage("compile.error.internal.outmemory");
        try {
            int n = Mib2Mof.compile(stringArray);
            Trace.conclude();
            System.exit(n);
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                Trace.error(string);
            } else {
                Trace.error(MessageHandler.getMessage("compile.error.internal", throwable.toString()));
                Trace.conclude();
            }
            System.exit(1);
        }
    }

    public static int compile(String[] stringArray) {
        Mib2Mof mib2Mof = new Mib2Mof(System.out, "mib2mof");
        return mib2Mof.startCompile(stringArray) ? 0 : 1;
    }

    private synchronized boolean startCompile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            if (this.usageWanted) {
                this.usage();
                return true;
            }
            Trace.setOutput(System.err);
            this.usage();
            return false;
        }
        if (this.fileList.size() == 0) {
            Trace.setOutput(System.err);
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    private boolean validTargetDir() {
        File file;
        if (!this.generateCode) {
            return true;
        }
        try {
            file = new File(this.targetDir);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (!file.exists()) {
            this.error(MessageHandler.getMessage("compile.error.noDir", this.targetDir));
            return false;
        }
        if (!file.canWrite()) {
            this.error(MessageHandler.getMessage("compile.error.noWritePermission", this.targetDir));
            return false;
        }
        return true;
    }
}

