/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.CalendarWidget;
import com.sun.admin.cis.common.Clock;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.TimeControlWidget;
import com.sun.admin.sysinfo.client.DateTimeDialog;
import com.sun.admin.sysinfo.client.SysInfoContextHelpListener;
import com.sun.admin.sysinfo.client.VSysInfo;
import com.sun.admin.sysinfo.common.SysInfoData;
import com.sun.admin.sysinfo.common.TimeZoneData;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;

public class DateTimePanel
extends JPanel {
    public static final int HELP_CACHE_SIZE = 3;
    private static final Dimension MIN_CLOCK_SIZE = new Dimension(100, 100);
    private static final Dimension PREF_CAL_SIZE = new Dimension(200, 340);
    private static final Dimension PREF_TZ_SIZE = new Dimension(200, 150);
    private Vector vHeaders = new Vector(3);
    private VSysInfo theApp;
    private ResourceBundle bundle;
    GenInfoPanel infoPanel;
    Vector helpCache;
    SysInfoContextHelpListener helpListener;
    private GridBagLayout bag = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private DateTimeDialog dialog;
    private SysInfoData sysInfoData;
    private Vector vTimeZones = new Vector();
    private TimeControlWidget timeControl;
    private Clock clock;
    private CalendarWidget calendarWidget;
    private JTable timeZoneTable;
    private TimeZoneTableModel tableModel;

    public DateTimePanel(VSysInfo vSysInfo, VOptionPane vOptionPane, SysInfoData sysInfoData) {
        this.theApp = vSysInfo;
        this.bundle = vSysInfo.getResourceBundle();
        this.dialog = (DateTimeDialog)vOptionPane;
        this.sysInfoData = sysInfoData;
        this.initTimeZoneData();
        this.infoPanel = new GenInfoPanel(vOptionPane);
        this.helpCache = new Vector(3);
        this.initColumnHeaders();
        this.createGUI();
        this.init(sysInfoData);
    }

    private void initColumnHeaders() {
        this.vHeaders.addElement(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"timeCol"));
        this.vHeaders.addElement(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"locationCol"));
        this.vHeaders.addElement(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dstCol"));
    }

    public void createGUI() {
        this.setLayout(this.bag);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        Constraints.constrain((Container)jPanel, (Component)this.buildTimePanel(), (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)0.0, (double)1.0, (int)12, (int)12, (int)12, (int)6);
        Constraints.constrain((Container)jPanel, (Component)this.buildDatePanel(), (int)1, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)12, (int)6, (int)12, (int)12);
        Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this, (Component)this.buildTimeZonePanel(), (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)12, (int)12, (int)12);
    }

    private JPanel buildTimePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        ActionString actionString = new ActionString(this.bundle, "time");
        JLabel jLabel = new JLabel(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)3, (int)0);
        this.timeControl = new TimeControlWidget();
        jLabel.setLabelFor((Component)this.timeControl);
        TimeControlListener timeControlListener = new TimeControlListener();
        Document document = this.timeControl.getHourField().getTextField().getDocument();
        document.addDocumentListener(timeControlListener);
        document = this.timeControl.getMinuteField().getTextField().getDocument();
        document.addDocumentListener(timeControlListener);
        document = this.timeControl.getSecondField().getTextField().getDocument();
        document.addDocumentListener(timeControlListener);
        this.helpListener = new SysInfoContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "sysinfo_datetime_time");
        this.theApp.addHelpListener(this.helpListener, (Component)this.timeControl);
        Constraints.constrain((Container)jPanel, (Component)this.timeControl, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)12, (int)0);
        this.clock = new Clock();
        Constraints.constrain((Container)jPanel, (Component)this.clock, (int)0, (int)2, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        return jPanel;
    }

    private JPanel buildDatePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        ActionString actionString = new ActionString(this.bundle, "date");
        JLabel jLabel = new JLabel(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)3, (int)0);
        this.calendarWidget = new CalendarWidget(){

            public void daySelectionChanged() {
                DateTimePanel.this.dialog.setDateChanged(DateTimePanel.this.calendarWidget.getDay() != DateTimePanel.this.sysInfoData.getDateTime().get(5));
            }
        };
        jLabel.setLabelFor((Component)this.calendarWidget);
        this.calendarWidget.addMonthListener((ItemListener)new MonthListener());
        this.calendarWidget.addYearListener((DocumentListener)new YearListener());
        this.helpListener = new SysInfoContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "sysinfo_datetime_date");
        this.theApp.addHelpListener(this.helpListener, (Component)this.calendarWidget);
        Constraints.constrain((Container)jPanel, (Component)this.calendarWidget, (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        return jPanel;
    }

    private JPanel buildTimeZonePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        ActionString actionString = new ActionString(this.bundle, "timezone");
        JLabel jLabel = new JLabel(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)3, (int)0);
        this.tableModel = new TimeZoneTableModel();
        this.timeZoneTable = new TimeZoneTable(this.vTimeZones, this.vHeaders);
        jLabel.setLabelFor(this.timeZoneTable);
        this.helpListener = new SysInfoContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "sysinfo_datetime_timezone");
        this.theApp.addHelpListener(this.helpListener, this.timeZoneTable);
        this.timeZoneTable.setModel(this.tableModel);
        this.timeZoneTable.getTableHeader().setReorderingAllowed(false);
        this.timeZoneTable.setCellSelectionEnabled(false);
        this.timeZoneTable.setColumnSelectionAllowed(false);
        this.timeZoneTable.setRowSelectionAllowed(true);
        this.timeZoneTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.timeZoneTable);
        jScrollPane.setPreferredSize(PREF_TZ_SIZE);
        Constraints.constrain((Container)jPanel, (Component)jScrollPane, (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        return jPanel;
    }

    private void initTimeZoneData() {
        Vector<String> vector = this.sysInfoData.getTimeZones();
        Enumeration enumeration = vector.elements();
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dstNotObserved");
        String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dstObserved");
        while (enumeration.hasMoreElements()) {
            TimeZoneData timeZoneData = (TimeZoneData)enumeration.nextElement();
            vector = new Vector<String>(3);
            vector.addElement(timeZoneData.getOffset());
            vector.addElement(timeZoneData.getName());
            if (timeZoneData.isDST()) {
                vector.addElement(string2);
            } else {
                vector.addElement(string);
            }
            this.vTimeZones.addElement(vector);
        }
    }

    public void init(SysInfoData sysInfoData) {
        this.sysInfoData = sysInfoData;
        this.timeControl.reset();
        this.clock.setDate(sysInfoData.getDateTime().getTime());
        this.calendarWidget.setCalendar((GregorianCalendar)sysInfoData.getDateTime().clone());
        int n = sysInfoData.getCurrentTimeZoneIndex();
        this.timeZoneTable.addRowSelectionInterval(n, n);
        this.timeZoneTable.addColumnSelectionInterval(0, 2);
        this.validate();
        this.repaint();
    }

    private boolean isDateChanged() {
        Calendar calendar = this.sysInfoData.getDateTime();
        boolean bl = calendar.get(1) != this.calendarWidget.getYear() || calendar.get(2) != this.calendarWidget.getMonth() || calendar.get(5) != this.calendarWidget.getDay();
        return bl;
    }

    public Calendar getCalendar() {
        TimeZone timeZone = TimeZone.getTimeZone((String)this.timeZoneTable.getValueAt(this.timeZoneTable.getSelectedRow(), 1));
        Calendar calendar = Calendar.getInstance(timeZone);
        if (this.isDateChanged()) {
            calendar.set(5, this.calendarWidget.get(5));
            calendar.set(2, this.calendarWidget.get(2));
            calendar.set(1, this.calendarWidget.get(1));
        }
        if (this.timeControl.isTimeSet()) {
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTime(this.clock.getDate());
            int n = this.timeControl.get(13);
            if (n < 0) {
                n = calendar2.get(13);
            }
            calendar.set(13, n);
            n = this.timeControl.get(12);
            if (n < 0) {
                n = calendar2.get(12);
            }
            calendar.set(12, n);
            n = this.timeControl.get(11);
            if (n < 0) {
                n = calendar2.get(11);
            }
            calendar.set(11, n);
        }
        return calendar;
    }

    public int getTimeZoneIndex() {
        return this.timeZoneTable.getSelectedRow();
    }

    private class YearListener
    implements DocumentListener {
        private YearListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DateTimePanel.this.dialog.setDateChanged(DateTimePanel.this.calendarWidget.getYear() != DateTimePanel.this.sysInfoData.getDateTime().get(1));
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DateTimePanel.this.dialog.setDateChanged(DateTimePanel.this.calendarWidget.getYear() != DateTimePanel.this.sysInfoData.getDateTime().get(1));
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DateTimePanel.this.dialog.setDateChanged(DateTimePanel.this.calendarWidget.getYear() != DateTimePanel.this.sysInfoData.getDateTime().get(1));
        }
    }

    private class MonthListener
    implements ItemListener {
        private MonthListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            DateTimePanel.this.dialog.setDateChanged(DateTimePanel.this.calendarWidget.getMonth() != DateTimePanel.this.sysInfoData.getDateTime().get(2));
        }
    }

    class TimeControlListener
    implements DocumentListener {
        TimeControlListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DateTimePanel.this.dialog.setTimeChanged(DateTimePanel.this.timeControl.isTimeSet());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DateTimePanel.this.dialog.setTimeChanged(DateTimePanel.this.timeControl.isTimeSet());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DateTimePanel.this.dialog.setTimeChanged(DateTimePanel.this.timeControl.isTimeSet());
        }
    }

    class TimeZoneTable
    extends JTable {
        private boolean bConstructed = true;

        public TimeZoneTable(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.bConstructed) {
                DateTimePanel.this.dialog.setTimeZoneChanged(this.getSelectedRow() != DateTimePanel.this.sysInfoData.getCurrentTimeZoneIndex());
                this.validate();
                this.repaint();
            }
        }
    }

    private class TimeZoneTableModel
    extends AbstractTableModel {
        private TimeZoneTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return DateTimePanel.this.vTimeZones.size();
        }

        public Object getValueAt(int n, int n2) {
            return ((Vector)DateTimePanel.this.vTimeZones.elementAt(n)).elementAt(n2);
        }

        public String getColumnName(int n) {
            return (String)DateTimePanel.this.vHeaders.elementAt(n);
        }
    }
}

