/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.sysinfo.client.DateTimePanel;
import com.sun.admin.sysinfo.client.SysInfoContextHelpListener;
import com.sun.admin.sysinfo.client.VSysInfo;
import com.sun.admin.sysinfo.common.SysInfoData;
import com.sun.admin.sysinfo.common.SysInfoException;
import com.sun.admin.sysinfo.common.TimeZoneData;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DateTimeDialog
extends VOptionPane {
    public static final int HELP_CACHE_SIZE = 1;
    GenInfoPanel infoPanel;
    Vector helpCache;
    SysInfoContextHelpListener helpListener;
    VSysInfo theApp;
    ResourceBundle bundle;
    DateTimeDialog dialog;
    SysInfoData sysInfoData;
    SysInfoData newSysInfoData;
    DateTimePanel dateTimePanel;
    private JButton okBtn;
    private JButton cancelBtn;
    GridBagConstraints gbc;
    private boolean bTimeZoneChanged = false;
    private boolean bTimeChanged = false;
    private boolean bDateChanged = false;

    public DateTimeDialog(VSysInfo vSysInfo, SysInfoData sysInfoData) {
        this.theApp = vSysInfo;
        this.bundle = vSysInfo.getResourceBundle();
        this.dialog = this;
        this.gbc = new GridBagConstraints();
        this.sysInfoData = sysInfoData;
        this.newSysInfoData = (SysInfoData)sysInfoData.clone();
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DateTimeTitle");
        this.setTitle(string);
        this.infoPanel = new GenInfoPanel((VOptionPane)this);
        this.helpCache = new Vector(1);
        this.helpListener = new SysInfoContextHelpListener(vSysInfo, this.helpCache, this.infoPanel, "sysinfo_datetime_gen");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        JPanel jPanel = this.buildBtnPanel();
        JComponent jComponent = this.getButtonPane();
        jComponent.removeAll();
        jComponent.setLayout(new GridBagLayout());
        Constraints.constrain((Container)jComponent, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.dateTimePanel = new DateTimePanel(vSysInfo, this, this.newSysInfoData);
        JComponent jComponent2 = this.getContentPane();
        jComponent2.setLayout(new GridBagLayout());
        Constraints.constrain((Container)jComponent2, (Component)this.dateTimePanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    protected JPanel buildBtnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        BtnListener btnListener = new BtnListener();
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ok"));
        this.okBtn = new JButton(string);
        this.okBtn.setEnabled(false);
        this.okBtn.addActionListener(btnListener);
        Constraints.constrain((Container)jPanel, (Component)this.okBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"cancel"));
        this.cancelBtn = new JButton(string);
        this.cancelBtn.addActionListener(btnListener);
        Constraints.constrain((Container)jPanel, (Component)this.cancelBtn, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        return jPanel;
    }

    protected void defaultAction() {
        this.okBtn.setEnabled(false);
        Thread thread = new Thread(){

            public void run() {
                Calendar calendar = DateTimeDialog.this.dateTimePanel.getCalendar();
                if (DateTimeDialog.this.bTimeChanged || DateTimeDialog.this.bDateChanged) {
                    DateTimeDialog.this.newSysInfoData.setDateTime(calendar);
                    try {
                        DateTimeDialog.this.theApp.getSystemInfo().setDateTime(DateTimeDialog.this.newSysInfoData);
                    }
                    catch (SysInfoException sysInfoException) {
                        DateTimeDialog.this.theApp.reportErrorException((Exception)((Object)sysInfoException));
                    }
                }
                if (DateTimeDialog.this.bTimeZoneChanged) {
                    TimeZoneData timeZoneData = (TimeZoneData)DateTimeDialog.this.newSysInfoData.getTimeZones().elementAt(DateTimeDialog.this.dateTimePanel.getTimeZoneIndex());
                    DateTimeDialog.this.newSysInfoData.setCurrentTimeZone(timeZoneData);
                    try {
                        DateTimeDialog.this.theApp.getSystemInfo().setTimeZone(DateTimeDialog.this.newSysInfoData);
                    }
                    catch (SysInfoException sysInfoException) {
                        DateTimeDialog.this.theApp.reportErrorException((Exception)((Object)sysInfoException));
                    }
                    DateTimeDialog.this.dateTimePanel.init(DateTimeDialog.this.newSysInfoData);
                }
            }
        };
        thread.start();
        this.cancelAction();
        if (this.bTimeZoneChanged) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"TimeZoneChangedTitle"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"TimeZoneChangedText"), true);
        }
        this.theApp.getContent().refresh();
    }

    protected void cancelAction() {
        this.getParentFrame().dispose();
        this.theApp.setDateTimeEnabled(true);
    }

    private void setOKEnabled(boolean bl) {
        this.okBtn.setEnabled(bl);
        this.validate();
        this.repaint();
    }

    protected void setTimeZoneChanged(boolean bl) {
        this.bTimeZoneChanged = bl;
        this.setOKEnabled(this.bDateChanged || this.bTimeChanged || this.bTimeZoneChanged);
    }

    protected void setTimeChanged(boolean bl) {
        this.bTimeChanged = bl;
        this.setOKEnabled(this.bDateChanged || this.bTimeChanged || this.bTimeZoneChanged);
    }

    protected void setDateChanged(boolean bl) {
        this.bDateChanged = bl;
        this.setOKEnabled(this.bDateChanged || this.bTimeChanged || this.bTimeZoneChanged);
    }

    private JFrame getParentFrame() {
        return (JFrame)this.getContainer();
    }

    class BtnListener
    implements ActionListener {
        BtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DateTimeDialog.this.okBtn) {
                DateTimeDialog.this.defaultAction();
            } else {
                DateTimeDialog.this.cancelAction();
            }
        }
    }
}

