/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import javax.transaction.xa.XAException;

public final class Debug {
    private Debug() {
    }

    static void printHeuristic(int n) {
        switch (n) {
            case 2: {
                System.out.println("heuristic rollback");
                break;
            }
            case 1: {
                System.out.println("heuristic commit");
                break;
            }
            case 4: {
                System.out.println("heuristic mixed");
                break;
            }
            case 8: {
                System.out.println("heuristic hazard");
                break;
            }
            case 32: {
                System.out.println("heuristic other");
                break;
            }
            case 48: {
                System.out.println("heuristic unknown");
                break;
            }
            case 0: {
                System.out.println("heuristic read only");
                break;
            }
            default: {
                if ((n & 2) != 0) {
                    System.out.print("heuristic rollback");
                }
                if ((n & 1) != 0) {
                    System.out.print("heuristic rollback");
                }
                if ((n & 4) != 0) {
                    System.out.print("heuristic rollback");
                }
                if ((n & 8) != 0) {
                    System.out.print("heuristic rollback");
                }
                if ((n & 0x20) != 0) {
                    System.out.print("heuristic rollback");
                }
                if ((n & 0x30) != 0) {
                    System.out.print("heuristic rollback");
                }
                if (false) {
                    System.out.print("heuristic rollback");
                }
                System.out.println("");
            }
        }
    }

    static void printStatus(int n) {
        switch (n) {
            case 0: {
                System.out.println("STATUS_ACTIVE");
                System.out.println("A transaction is associated with the target object and it is in the active state.");
                break;
            }
            case 3: {
                System.out.println("STATUS_COMMITTED");
                System.out.println("A transaction is associated with the target object and it has been committed.");
                break;
            }
            case 8: {
                System.out.println("STATUS_COMMITTING");
                System.out.println("A transaction is associated with the target object and it is in the process of committing.");
                break;
            }
            case 1: {
                System.out.println("STATUS_MARKED_ROLLBACK");
                System.out.println("A transaction is associated with the target object and it has been marked for rollback, perhaps as a result of a setRollbackOnly operation.");
                break;
            }
            case 6: {
                System.out.println("STATUS_NO_TRANSACTION");
                System.out.println("No transaction is currently associated with the target object.");
                break;
            }
            case 2: {
                System.out.println("STATUS_PREPARED");
                System.out.println("A transaction is associated with the target object and it has been prepared, i.e.");
                break;
            }
            case 7: {
                System.out.println("STATUS_PREPARING");
                System.out.println("A transaction is associated with the target object and it is in the process of preparing.");
                break;
            }
            case 4: {
                System.out.println("STATUS_ROLLEDBACK");
                System.out.println("A transaction is associated with the target object and the outcome has been determined as rollback.");
                break;
            }
            case 9: {
                System.out.println("STATUS_ROLLING_BACK");
                System.out.println("A transaction is associated with the target object and it is in the process of rolling back.");
                break;
            }
            default: {
                System.out.println("Unknown status " + n);
            }
        }
    }

    static void printXAException(XAException xAException) {
        System.out.println("XA Exception occurred:");
        System.out.println(xAException.toString());
        switch (xAException.errorCode) {
            case 7: {
                System.out.println("XA_HEURCOM");
                System.out.println("The transaction branch has been heuristically committed.");
                break;
            }
            case 8: {
                System.out.println("XA_HEURHAZ");
                System.out.println("The transaction branch may have been heuristically completed.");
                break;
            }
            case 5: {
                System.out.println("XA_HEURMIX");
                System.out.println("The transaction branch has been heuristically committed and rolled back.");
                break;
            }
            case 6: {
                System.out.println("XA_HEURRB");
                System.out.println("The transaction branch has been heuristically rolled back.");
                break;
            }
            case 9: {
                System.out.println("XA_NOMIGRATE");
                System.out.println("Resumption must occur where suspension occured.");
                break;
            }
            case 101: {
                System.out.println("XA_RBCOMMFAIL");
                System.out.println("");
                break;
            }
            case 102: {
                System.out.println("XA_RBDEADLOCK");
                System.out.println("");
                break;
            }
            case 103: {
                System.out.println("XA_RBINTEGRITY");
                System.out.println("A condition that violates the integrity of the resource was detected.");
                break;
            }
            case 104: {
                System.out.println("XA_RBOTHER");
                System.out.println("The resource manager rolled back the transaction branch for a reason not on this list.");
                break;
            }
            case 105: {
                System.out.println("XA_RBPROTO");
                System.out.println("A protocol error occured in the resource manager. ");
                break;
            }
            case 100: {
                System.out.println("XA_RBROLLBACK");
                System.out.println("Rollback was caused by unspecified reason.");
                break;
            }
            case 106: {
                System.out.println("XA_RBTIMEOUT");
                System.out.println("A transaction branch took too long.");
                break;
            }
            case 107: {
                System.out.println("XA_RBTRANSIENT");
                System.out.println("May retry the transaction branch.");
                break;
            }
            case 3: {
                System.out.println("XA_RDONLY");
                System.out.println("The transaction branch has been read-only and has been committed.");
                break;
            }
            case 4: {
                System.out.println("XA_RETRY");
                System.out.println("Routine returned with no effect and may be reissued.");
                break;
            }
            case -2: {
                System.out.println("XAER_ASYNC");
                System.out.println("Asynchronous operation already outstanding.");
                break;
            }
            case -8: {
                System.out.println("XAER_DUPID");
                System.out.println("The XID already exists.");
                break;
            }
            case -5: {
                System.out.println("XAER_INVAL");
                System.out.println("Invalid arguments were given.");
                break;
            }
            case -4: {
                System.out.println("XAER_NOTA");
                System.out.println("The XID is not valid.");
                break;
            }
            case -9: {
                System.out.println("XAER_OUTSIDE");
                System.out.println("The resource manager is doing work outside global transaction.");
                break;
            }
            case -6: {
                System.out.println("XAER_PROTO");
                System.out.println("Routine was invoked in an inproper context.");
                break;
            }
            case -3: {
                System.out.println("XAER_RMERR");
                System.out.println("A resource manager error has occured in the transaction branch.");
                break;
            }
            case -7: {
                System.out.println("XAER_RMFAIL");
                System.out.println("Resource manager is unavailable.");
                break;
            }
            default: {
                System.out.println("Unknown error code: " + xAException.errorCode);
            }
        }
        xAException.printStackTrace();
    }
}

