/*
 * Decompiled with CFR 0.152.
 */
package tyrex.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import tyrex.jdbc.AbstractTyrexConnectionImpl;
import tyrex.jdbc.xa.XAConnectionImpl;
import tyrex.jdbc.xa.XADataSourceImpl;

final class ClientConnection
extends AbstractTyrexConnectionImpl
implements Connection {
    private XAConnectionImpl _xaConn;
    private XADataSourceImpl _xaDataSource;
    private int _clientId;

    ClientConnection(XAConnectionImpl xAConnectionImpl, XADataSourceImpl xADataSourceImpl, int n) {
        this._xaConn = xAConnectionImpl;
        this._xaDataSource = xADataSourceImpl;
        this._clientId = n;
    }

    public void commit() throws SQLException {
        if (this._xaConn.insideGlobalTx()) {
            throw new SQLException("Cannot commit/rollback a connection managed by the transaction manager");
        }
        if (this.isReadOnly()) {
            throw new SQLException("Cannot commit/rollback a read-only transaction");
        }
        try {
            super.commit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return super.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    protected void internalClose() throws SQLException {
        if (!this.isClosed()) {
            this._xaConn.notifyClose(this._clientId);
            this._xaConn = null;
            this._xaDataSource = null;
        }
    }

    protected Connection internalGetUnderlyingConnection() throws SQLException {
        try {
            return this._xaConn.getUnderlying(this._clientId);
        }
        catch (SQLException sQLException) {
            this._xaConn = null;
            this._xaDataSource = null;
            throw sQLException;
        }
    }

    public synchronized boolean isClosed() {
        return this._xaConn == null;
    }

    protected void notifyError(SQLException sQLException) {
        if (this._xaConn != null) {
            this._xaConn.notifyError(this._clientId, sQLException);
        }
    }

    public void rollback() throws SQLException {
        if (this._xaConn.insideGlobalTx()) {
            throw new SQLException("Cannot commit/rollback a connection managed by the transaction manager");
        }
        try {
            super.rollback();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this._xaConn.insideGlobalTx()) {
            throw new SQLException("Cannot commit/rollback a connection managed by the transaction manager");
        }
        try {
            super.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return "XAConnection: Connection closed";
        }
        try {
            return this.internalGetUnderlyingConnection().toString();
        }
        catch (SQLException sQLException) {
            return "XAConnection: Connection closed";
        }
    }
}

