/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.sql.XADataSource;
import tyrex.connector.AbstractManagedConnectionFactory;
import tyrex.connector.ConnectionException;
import tyrex.connector.ManagedConnection;
import tyrex.connector.ManagedConnectionFactory;
import tyrex.connector.jdbc.JDBCConnectionCredential;
import tyrex.connector.jdbc.JDBCConnectionInfo;
import tyrex.connector.jdbc.JDBCManagedConnection;

public abstract class JDBCManagedConnectionFactory
extends AbstractManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private XADataSource xaDataSource = null;

    protected JDBCManagedConnectionFactory() {
    }

    protected abstract boolean canAccess(XADataSource var1, Subject var2, Set var3, Object var4);

    protected boolean canAccess(ManagedConnection managedConnection, Subject subject, Set set, Object object) throws ConnectionException {
        return managedConnection instanceof JDBCManagedConnection ? this.canAccess((JDBCManagedConnection)managedConnection, subject, set, this.getJDBCConnectionInfo(object)) : false;
    }

    protected boolean canAccess(JDBCManagedConnection jDBCManagedConnection, Subject subject, Set set, JDBCConnectionInfo jDBCConnectionInfo) throws ConnectionException {
        return jDBCManagedConnection.isSameInfo(jDBCConnectionInfo);
    }

    protected abstract XADataSource createDataSource(Subject var1, Set var2, Object var3) throws ConnectionException;

    public final ManagedConnection createManagedConnection(Subject subject, Set set, Object object) throws ConnectionException {
        JDBCConnectionCredential jDBCConnectionCredential = this.getConnectionCredential(subject, set, object);
        if (jDBCConnectionCredential == null) {
            throw new ConnectionException("Cannot find the connection credential.");
        }
        try {
            return new JDBCManagedConnection(this.getDataSource(subject, set, object).getXAConnection(jDBCConnectionCredential.getUserName(), jDBCConnectionCredential.getPassword()), this.getJDBCConnectionInfo(object));
        }
        catch (SQLException sQLException) {
            throw new ConnectionException(sQLException);
        }
    }

    protected JDBCConnectionCredential getConnectionCredential(Subject subject, Set set, Object object) {
        return set == null || set.size() != 1 ? null : (JDBCConnectionCredential)set.iterator().next();
    }

    protected final XADataSource getDataSource() {
        return this.xaDataSource;
    }

    protected final synchronized XADataSource getDataSource(Subject subject, Set set, Object object) throws ConnectionException {
        if (this.xaDataSource == null) {
            this.xaDataSource = this.createDataSource(subject, set, object);
            if (this.xaDataSource == null) {
                throw new ConnectionException("Failed to create data source.");
            }
            try {
                this.xaDataSource.setLogWriter(this.getLogWriter());
                this.xaDataSource.setLoginTimeout(this.getLoginTimeout());
            }
            catch (SQLException sQLException) {
                throw new ConnectionException(sQLException);
            }
        } else if (!this.canAccess(this.xaDataSource, subject, set, object)) {
            throw new ConnectionException("Subject <" + subject + "> cannot access required data source.");
        }
        return this.xaDataSource;
    }

    protected JDBCConnectionInfo getJDBCConnectionInfo(Object object) {
        return object == null || !(object instanceof JDBCConnectionInfo) ? null : (JDBCConnectionInfo)object;
    }

    protected boolean isValidCredential(Object object, Object object2, boolean bl) {
        return object instanceof JDBCConnectionCredential;
    }
}

