/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector;

import java.io.PrintWriter;
import javax.transaction.xa.XAResource;
import tyrex.connector.ConnectionEvent;
import tyrex.connector.ConnectionEventListener;
import tyrex.connector.ConnectionException;
import tyrex.connector.LocalTransaction;
import tyrex.connector.ManagedConnection;
import tyrex.connector.transaction.XALocalTransaction;

public abstract class AbstractManagedConnection
implements ManagedConnection {
    private static final int connectionErrorOccurred = 0;
    private static final int connectionClosed = 1;
    private static final int localTransactionBegun = 2;
    private static final int localTransactionCommitted = 3;
    private static final int localTransactionRolledback = 4;
    private transient ConnectionEventListener[] listeners = null;
    private transient XAResource xaResource = null;
    private transient XALocalTransaction.XALocalTransactionListener xaLocalTransactionListener = new LocalTransactionListener();
    private boolean isClosed = false;

    protected AbstractManagedConnection() {
    }

    public final synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        if (this.listeners == null) {
            this.listeners = new ConnectionEventListener[1];
            this.listeners[0] = connectionEventListener;
        } else {
            int n = 0;
            while (n < this.listeners.length) {
                if (this.listeners[n] == connectionEventListener) {
                    return;
                }
                ++n;
            }
            ConnectionEventListener[] connectionEventListenerArray = new ConnectionEventListener[this.listeners.length + 1];
            int n2 = 0;
            while (n2 < this.listeners.length) {
                connectionEventListenerArray[n2] = this.listeners[n2];
                ++n2;
            }
            connectionEventListenerArray[this.listeners.length] = connectionEventListener;
            this.listeners = connectionEventListenerArray;
        }
    }

    protected final void checkClosed() throws ConnectionException {
        if (this.isClosed()) {
            throw new ConnectionException("The managed conenction <" + this.toString() + "> is closed.");
        }
    }

    public final synchronized void close() throws ConnectionException {
        if (!this.isClosed()) {
            this.isClosed = true;
            this.xaResource = null;
            this.performClose();
        }
    }

    protected XAResource createXAResource() throws ConnectionException {
        return null;
    }

    protected final void fireConnectionClosedEvent() {
        this.fireConnectionEvent(1, null);
    }

    protected final void fireConnectionErrorOccurredEvent(Exception exception) {
        this.fireConnectionEvent(0, exception);
    }

    private void fireConnectionEvent(int n, Exception exception) {
        ConnectionEventListener[] connectionEventListenerArray = null;
        Object object = this;
        synchronized (object) {
            if (this.listeners != null && this.listeners.length > 0) {
                connectionEventListenerArray = (ConnectionEventListener[])this.listeners.clone();
            }
        }
        if (connectionEventListenerArray != null) {
            object = new ConnectionEvent(this, exception);
            int n2 = 0;
            while (n2 < connectionEventListenerArray.length) {
                switch (n) {
                    case 0: {
                        connectionEventListenerArray[n2].connectionErrorOccurred((ConnectionEvent)object);
                        break;
                    }
                    case 1: {
                        connectionEventListenerArray[n2].connectionClosed((ConnectionEvent)object);
                        break;
                    }
                    case 2: {
                        connectionEventListenerArray[n2].localTransactionBegun((ConnectionEvent)object);
                        break;
                    }
                    case 3: {
                        connectionEventListenerArray[n2].localTransactionCommitted((ConnectionEvent)object);
                        break;
                    }
                    case 4: {
                        connectionEventListenerArray[n2].localTransactionRolledback((ConnectionEvent)object);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    protected final void fireLocalTransactionBegunEvent() {
        this.fireConnectionEvent(2, null);
    }

    protected final void fireLocalTransactionCommittedEvent() {
        this.fireConnectionEvent(3, null);
    }

    protected final void fireLocalTransactionRolledBackEvent() {
        this.fireConnectionEvent(4, null);
    }

    public abstract Object getConnection(Object var1) throws ConnectionException;

    public LocalTransaction getLocalTransaction() throws ConnectionException {
        return new XALocalTransaction(this.getXAResource(), this.xaLocalTransactionListener);
    }

    public abstract PrintWriter getLogWriter();

    public final synchronized XAResource getXAResource() throws ConnectionException {
        this.checkClosed();
        if (this.xaResource == null) {
            this.xaResource = this.createXAResource();
        }
        return this.xaResource;
    }

    protected final boolean isClosed() {
        return this.isClosed;
    }

    protected abstract void performClose() throws ConnectionException;

    public final synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.length == 1) {
            if (this.listeners[0] == connectionEventListener) {
                this.listeners = null;
            }
            return;
        }
        int n = 0;
        while (n < this.listeners.length) {
            if (this.listeners[n] == connectionEventListener) {
                this.listeners[n] = this.listeners[this.listeners.length - 1];
                ConnectionEventListener[] connectionEventListenerArray = new ConnectionEventListener[this.listeners.length - 1];
                int n2 = 0;
                while (n2 < this.listeners.length - 1) {
                    connectionEventListenerArray[n2] = this.listeners[n2];
                    ++n2;
                }
                this.listeners = connectionEventListenerArray;
                return;
            }
            ++n;
        }
    }

    public abstract void setLogWriter(PrintWriter var1);

    private class LocalTransactionListener
    implements XALocalTransaction.XALocalTransactionListener {
        LocalTransactionListener() {
        }

        public void beginCalled() {
            AbstractManagedConnection.this.fireLocalTransactionBegunEvent();
        }

        public void commitCalled() {
            AbstractManagedConnection.this.fireLocalTransactionCommittedEvent();
        }

        public void rollbackCalled() {
            AbstractManagedConnection.this.fireLocalTransactionRolledBackEvent();
        }
    }
}

