/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.recycle;

import org.apache.java.recycle.Recyclable;
import org.apache.java.recycle.RecycleBin;
import org.apache.java.recycle.RecycleBinIsFull;

public class LimitedContainer
implements RecycleBin {
    private RecycleBin container;
    private int capacity;

    public LimitedContainer(RecycleBin recycleBin, int n) {
        this.container = recycleBin;
        this.capacity = n;
    }

    public Recyclable getRecyclable() {
        return this.container.getRecyclable();
    }

    public void recycle(Recyclable recyclable) {
        if (this.container.getSize() >= this.capacity) {
            recyclable.destroy();
            throw new RecycleBinIsFull();
        }
        this.container.recycle(recyclable);
    }

    public int getSize() {
        return this.container.getSize();
    }
}

