/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.wbem.cim.CIMException;

public class CronLog {
    private static String CRON_LOG_FILE = "/var/cron/log";
    private static String CRON_LOG_COMMAND_PREFIX = ">  CMD: ";
    private static String CRON_LOG_ENDJOB_PREFIX = "<  ";
    private static String CRON_LOG_RETURNCODE_PREFIX = "rc=";
    private static int MAX_LOG_LINES = 250;
    private static String JOB_EVENTS_REGEXP = "^[><].*";
    private String inDateFormatString = null;
    private DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    private String jobStateUnknown = null;
    private String jobStateFinished1 = null;
    private String jobStateFinished2 = null;
    private String jobStateStarted1 = null;
    private String jobStateStarted2 = null;
    private ScheduledJobProvider provHandle = null;
    private DirectoryTable cronLog = null;
    private DirectoryRow logRows = null;
    private TableDefinitions cronLogTableDefs = null;
    private int lineCol = 0;
    private Hashtable jobEvents = null;
    private boolean dataLoaded = false;
    private SimpleDateFormat inDateFormat = null;

    public CronLog(ScheduledJobProvider scheduledJobProvider) {
        this.provHandle = scheduledJobProvider;
        this.inDateFormatString = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_IN_DATE_FORMAT");
        this.jobStateUnknown = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_UNKNOWN");
        this.jobStateFinished1 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_FINISHED1");
        this.jobStateFinished2 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_FINISHED2");
        this.jobStateStarted1 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_STARTED1");
        this.jobStateStarted2 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_STARTED2");
        this.inDateFormat = new SimpleDateFormat(this.inDateFormatString);
    }

    public void initialize() throws CIMException {
        try {
            this.cronLog = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
            this.cronLogTableDefs = this.cronLog.getTableDefinitionsInstance();
            this.cronLogTableDefs.loadTableDefinitions("text");
            this.cronLogTableDefs.setMappedTableName(CRON_LOG_FILE);
            this.lineCol = this.cronLogTableDefs.getColumnNumber("line");
        }
        catch (DirectoryTableException directoryTableException) {
            this.cronLog = null;
            this.provHandle.logWarning("LM_7908", "LM_7909");
        }
    }

    public void loadCronLog() throws CIMException {
        if (this.cronLog == null) {
            return;
        }
        try {
            this.cronLog.open(this.cronLogTableDefs);
            DirectoryFilter directoryFilter = new DirectoryFilter(1);
            directoryFilter.add(this.lineCol, 1, 9, JOB_EVENTS_REGEXP);
            this.logRows = this.cronLog.getAll((SearchTemplate)directoryFilter);
            if (this.logRows == null) {
                this.dataLoaded = true;
                this.jobEvents = null;
                return;
            }
            this.jobEvents = new Hashtable(101);
            this.parseLogEntries();
            this.cronLog.close();
            this.logRows = null;
        }
        catch (DirectoryTableException directoryTableException) {
            this.logRows = null;
            this.jobEvents = null;
        }
        this.dataLoaded = true;
    }

    public void unloadCronLog() {
        if (this.dataLoaded) {
            this.logRows = null;
            this.jobEvents = null;
            this.dataLoaded = false;
        }
    }

    public String getCronLogJobStatus(String string, String string2) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7681", "LM_7682");
        }
        if (this.jobEvents == null) {
            return null;
        }
        return (String)this.jobEvents.get(string.trim() + ":" + string2.trim());
    }

    private void parseLogEntries() {
        int n = this.logRows.getNumberOfRows();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "";
        if (n > MAX_LOG_LINES) {
            n = MAX_LOG_LINES;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            try {
                string = this.logRows.getColumn(this.lineCol, n2);
                if (string.startsWith(CRON_LOG_COMMAND_PREFIX)) {
                    int n3 = string.indexOf(35);
                    string2 = n3 != -1 ? string.substring(CRON_LOG_COMMAND_PREFIX.length(), n3).trim() : string.substring(CRON_LOG_COMMAND_PREFIX.length()).trim();
                    string5 = null;
                    string6 = null;
                    string7 = null;
                    string4 = null;
                    string = this.logRows.getColumn(this.lineCol, n2 + 1);
                    int n4 = 0;
                    int n5 = 3;
                    n3 = string.indexOf(32, 3);
                    while (n3 != -1 && n4 < 4) {
                        switch (n4) {
                            case 0: {
                                string3 = string.substring(n5, n3).trim();
                                break;
                            }
                            case 1: {
                                string4 = string.substring(n5, n3).trim();
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                string5 = string.substring(n5).trim();
                                break;
                            }
                        }
                        n5 = n3 + 1;
                        n3 = string.indexOf(32, n5);
                        ++n4;
                    }
                    if (!this.jobEvents.containsKey(string3 + ":" + string2)) {
                        int n6 = n2 + 2;
                        while (n6 <= n) {
                            string = this.logRows.getColumn(this.lineCol, n6);
                            if (string.startsWith(CRON_LOG_ENDJOB_PREFIX + string3 + " " + string4)) break;
                            ++n6;
                        }
                        if (n6 <= n) {
                            n3 = string.indexOf(CRON_LOG_RETURNCODE_PREFIX);
                            n5 = CRON_LOG_ENDJOB_PREFIX.length() + string3.length() + string4.length() + 4;
                            if (n3 == -1) {
                                string6 = string.substring(n5);
                            } else {
                                string7 = string.substring(n3 + CRON_LOG_RETURNCODE_PREFIX.length());
                                string6 = string.substring(n5, n3 - 1);
                            }
                        }
                        string8 = this.deriveJobStatus(string4, string5, string6, string7);
                        this.jobEvents.put(string3 + ":" + string2, string8);
                    }
                }
            }
            catch (DirectoryTableException directoryTableException) {
                // empty catch block
            }
            --n2;
        }
    }

    private String deriveJobStatus(String string, String string2, String string3, String string4) {
        String string5 = this.jobStateUnknown;
        Date date = null;
        if (string2 == null || string == null) {
            return string5;
        }
        if (string3 == null) {
            try {
                date = this.inDateFormat.parse(string2);
                string5 = this.jobStateStarted1 + " " + this.df.format(date) + " " + this.jobStateStarted2 + " " + string;
            }
            catch (Exception exception) {
                string5 = this.jobStateStarted1 + " " + this.jobStateStarted2 + " " + string;
            }
        } else {
            try {
                date = this.inDateFormat.parse(string3);
                string5 = this.jobStateFinished1 + " " + this.df.format(date);
            }
            catch (Exception exception) {
                string5 = this.jobStateFinished1;
            }
            if (string4 != null) {
                string5 = string5 + " " + this.jobStateFinished2 + " " + string4;
            }
        }
        return string5;
    }
}

