/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.project.ProjCommon;
import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.solarisprovider.project.SolarisProjectTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;

public class Solaris_Project
implements Authorizable,
MethodProvider,
InstanceProvider {
    private static final String PROJECT_NAME = "ProjectName";
    private static final String PROJECT_ID = "ProjectID";
    private static final String PROJECT_DESCRIPTION = "Description";
    private static final String PROJECT_USERS = "Users";
    private static final String PROJECT_GROUPS = "Groups";
    private static final String PROJECT_ATTRIBUTES = "ProjectAttributes";
    private static final String PROJECT_CLASS = "Solaris_Project";
    private static final String PROJECT_USER_CLASS = "Solaris_ProjectUser";
    private static final String PROJECT_GROUP_CLASS = "Solaris_ProjectGroup";
    private static final String SYSTEM_CCN = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String USER_PREFIX = "user.";
    private static final String GROUP_PREFIX = "group.";
    public static final int MAX_PROJ_INTEGER_VALUE = Integer.MAX_VALUE;
    public static final String PROJECT_WRITE_RIGHT = "solaris.project.write";
    public static final String PROJECT_READ_RIGHT = "solaris.project.read";
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    public static final String PROVIDERNAME = "Project Provider";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, PROVIDERNAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        SolarisProjectTable solarisProjectTable;
        Object object;
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        Object var7_7 = null;
        String string = null;
        String string2 = null;
        string = this.provUtil.getMgmtScope(cIMObjectPath);
        String string3 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        Object var13_13 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(PROJECT_NAME)) continue;
            if (object.getValue() != null) {
                string3 = (String)object.getValue().getValue();
                continue;
            }
            string2 = this.provUtil.writeLog(1, "LM_12001", "LM_12010", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)string2);
        }
        object = null;
        ProjectObj projectObj = new ProjectObj(string3);
        if (string3 != null) {
            projectObj.setProjectName(string3);
        }
        try {
            solarisProjectTable = new SolarisProjectTable(string);
            object = solarisProjectTable.getProjectRow(projectObj);
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        if (object == null) {
            string2 = this.provUtil.writeLog(1, "LM_12000", "LM_12010", string3, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)string2);
        }
        try {
            solarisProjectTable = ProjCommon.projectToCim((ProjectObj)object, cIMClass, this.provUtil.getScopeClassType(string), this.provUtil.getScopeDomainName(string));
            if (bl) {
                solarisProjectTable = solarisProjectTable.localElements();
            }
            return solarisProjectTable.filterProperties(stringArray, bl2, bl3);
        }
        catch (CIMException cIMException) {
            string2 = this.provUtil.writeLog(1, "LM_12020", "LM_12020", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)string2);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        Vector vector2 = new Vector();
        SolarisProjectTable solarisProjectTable = null;
        String string = null;
        string = this.provUtil.getMgmtScope(cIMObjectPath);
        try {
            solarisProjectTable = new SolarisProjectTable(string);
            vector2 = solarisProjectTable.getAllProjectRows();
            cIMInstanceArray = null;
            String string2 = null;
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                cIMInstanceArray = (CIMInstance[])enumeration.nextElement();
                string2 = cIMInstanceArray.getProjectName();
                CIMInstance cIMInstance = ProjCommon.projectToCim((ProjectObj)cIMInstanceArray, cIMClass, this.provUtil.getScopeClassType(string), this.provUtil.getScopeDomainName(string));
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath[] cIMObjectPathArray;
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = new Vector();
        SolarisProjectTable solarisProjectTable = null;
        String string = null;
        string = this.provUtil.getMgmtScope(cIMObjectPath);
        try {
            solarisProjectTable = new SolarisProjectTable(string);
            vector2 = solarisProjectTable.getAllProjectRows();
            cIMObjectPathArray = vector2.elements();
            while (cIMObjectPathArray.hasMoreElements()) {
                vector.addElement(ProjCommon.projectToCOP((ProjectObj)cIMObjectPathArray.nextElement(), cIMObjectPath, this.provUtil.getScopeClassType(string), this.provUtil.getScopeDomainName(string)));
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        SolarisProjectTable solarisProjectTable = null;
        String string = null;
        ProjectObj projectObj = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, cIMObjectPath);
        try {
            string = this.provUtil.getMgmtScope(cIMObjectPath);
            solarisProjectTable = new SolarisProjectTable(string);
            projectObj = ProjCommon.cimToProject(cIMInstance, string);
            solarisProjectTable.addProjectRow(projectObj);
            this.provUtil.writeLog(0, "LM_12043", "LM_12026", projectObj.getProjectName(), null, null, null);
        }
        catch (DirectoryTableRowSizeException directoryTableRowSizeException) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", projectObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableRowSizeException.getMessage());
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        catch (CIMException cIMException) {
            String string2 = this.provUtil.writeLog(2, "LM_12009", "LM_12019", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return cIMObjectPath;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        SolarisProjectTable solarisProjectTable = null;
        ProjectObj projectObj = null;
        String string = null;
        String string2 = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, cIMObjectPath);
        try {
            string = this.provUtil.getMgmtScope(cIMObjectPath);
            solarisProjectTable = new SolarisProjectTable(string);
            projectObj = ProjCommon.cimToProject(cIMInstance, string);
            string2 = projectObj.getProjectName();
            solarisProjectTable.modifyProjectRow(projectObj);
            this.provUtil.writeLog(0, "LM_12044", "LM_12028", string2, null, null, null);
        }
        catch (DirectoryTableRowSizeException directoryTableRowSizeException) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", projectObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableRowSizeException.getMessage());
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        catch (CIMException cIMException) {
            String string3 = this.provUtil.writeLog(2, "LM_12021", "LM_12022", string2, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        SolarisProjectTable solarisProjectTable = null;
        String string = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, cIMObjectPath);
        try {
            string = this.provUtil.getMgmtScope(cIMObjectPath);
            solarisProjectTable = new SolarisProjectTable(string);
            ProjectObj projectObj = ProjCommon.opToProject(cIMObjectPath, string);
            solarisProjectTable.deleteProjectRow(projectObj);
            this.provUtil.writeLog(0, "LM_12045", "LM_12030", projectObj.getProjectName(), null, null, null);
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        catch (Exception exception) {
            String string2 = this.provUtil.writeLog(2, "LM_12024", "LM_12024", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        try {
            if (string.equalsIgnoreCase("getNextProjectID")) {
                return this.getNextID(cIMObjectPath);
            }
            if (string.equalsIgnoreCase("getProjectUsers")) {
                return this.getMembers(cIMObjectPath, PROJECT_USER_CLASS);
            }
            if (string.equalsIgnoreCase("getProjectGroups")) {
                return this.getMembers(cIMObjectPath, PROJECT_GROUP_CLASS);
            }
            if (string.equalsIgnoreCase("setProjectUsers")) {
                return this.setMembers(cIMObjectPath, PROJECT_USER_CLASS, vector);
            }
            if (string.equalsIgnoreCase("setProjectGroups")) {
                return this.setMembers(cIMObjectPath, PROJECT_GROUP_CLASS, vector);
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        String string2 = this.provUtil.writeLog(1, "LM_12003", "LM_12013", string, null, null, null);
        throw new CIMException("GENERAL_EXCEPTION", (Object)string2);
    }

    public Vector myExecQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMValue getNextID(CIMObjectPath cIMObjectPath) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        Vector vector = new Vector();
        SolarisProjectTable solarisProjectTable = null;
        int n = 100;
        int n2 = -1;
        String string = null;
        ProjectObj projectObj = null;
        boolean bl = false;
        CIMValue cIMValue = null;
        string = this.provUtil.getMgmtScope(cIMObjectPath);
        try {
            solarisProjectTable = new SolarisProjectTable(string);
            vector = solarisProjectTable.getAllProjectRows();
            Enumeration enumeration = vector.elements();
            int[] nArray = new int[vector.size()];
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                projectObj = (ProjectObj)enumeration.nextElement();
                if (projectObj == null) continue;
                nArray[n3] = Integer.parseInt(projectObj.getProjectID());
                ++n3;
            }
            Arrays.sort(nArray);
            n3 = 0;
            while (!bl && n3 < vector.size() && n <= Integer.MAX_VALUE) {
                if (nArray[n3] < 100) {
                    ++n3;
                    continue;
                }
                if (n == nArray[n3]) {
                    ++n;
                    ++n3;
                    continue;
                }
                if (n < nArray[n3]) {
                    n2 = n;
                    bl = true;
                    continue;
                }
                if (n <= nArray[n3]) continue;
                ++n3;
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        if (n <= Integer.MAX_VALUE) {
            n2 = n;
        }
        if (n2 <= 0) {
            this.provUtil.writeLog(1, "LM_12002", "LM_12012", null, null, null, null);
            return null;
        }
        cIMValue = new CIMValue((Object)new UnsignedInt32((long)n2));
        return cIMValue;
    }

    private CIMValue getMembers(CIMObjectPath cIMObjectPath, String string) throws CIMException {
        Object object;
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        String string2 = null;
        String string3 = null;
        string2 = this.provUtil.getMgmtScope(cIMObjectPath);
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(PROJECT_NAME) || object.getValue() == null) continue;
            string3 = (String)object.getValue().getValue();
        }
        try {
            object = new ProjectObj(string3);
            SolarisProjectTable solarisProjectTable = new SolarisProjectTable(string2);
            object = solarisProjectTable.getProjectRow((ProjectObj)object);
            if (string.equals(PROJECT_USER_CLASS)) {
                return new CIMValue((Object)SolarisProjectTable.formatMembersIntoString(((ProjectObj)object).getProjectUsers()));
            }
            if (string.equals(PROJECT_GROUP_CLASS)) {
                return new CIMValue((Object)SolarisProjectTable.formatMembersIntoString(((ProjectObj)object).getProjectGroups()));
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        return null;
    }

    private CIMValue setMembers(CIMObjectPath cIMObjectPath, String string, Vector vector) throws CIMException {
        Object object;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, cIMObjectPath);
        String string2 = null;
        String string3 = null;
        string2 = this.provUtil.getMgmtScope(cIMObjectPath);
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(PROJECT_NAME) || object.getValue() == null) continue;
            string3 = (String)object.getValue().getValue();
        }
        try {
            if (vector == null || vector.isEmpty()) {
                if (string.equals(PROJECT_USER_CLASS)) {
                    this.provUtil.writeLog(2, "LM_12004", "LM_12014", string3, null, null, null);
                    throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"EXM_PRJ24");
                }
                this.provUtil.writeLog(2, "LM_12007", "LM_12017", string3, null, null, null);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"EXM_PRJ25");
            }
            object = new ProjectObj(string3);
            SolarisProjectTable solarisProjectTable = new SolarisProjectTable(string2);
            object = solarisProjectTable.getProjectRow((ProjectObj)object);
            CIMValue cIMValue = (CIMValue)vector.elementAt(0);
            String string4 = (String)cIMValue.getValue();
            String[] stringArray = null;
            stringArray = string4 == null ? new String[]{""} : ProjCommon.stringToArray(string4);
            String string5 = "";
            if (string.equals(PROJECT_USER_CLASS)) {
                ((ProjectObj)object).setProjectUsers(stringArray);
                string5 = "users";
            } else if (string.equals(PROJECT_GROUP_CLASS)) {
                ((ProjectObj)object).setProjectGroups(stringArray);
                string5 = "groups";
            }
            solarisProjectTable.modifyProjectRow((ProjectObj)object);
            this.provUtil.writeLog(0, "LM_12044", "LM_12054", ((ProjectObj)object).getProjectName(), string5, null, null);
            return new CIMValue((Object)SolarisProjectTable.formatMembersIntoString(stringArray));
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
    }
}

