/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.solarisprovider.project.SolarisProjectTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class ProjCommon {
    private static final String PROJECT_DESCRIPTION = "Description";
    private static final String PROJECT_ATTRIBUTES = "ProjectAttributes";
    private static final String PROJECT_ID = "ProjectID";
    private static final String PROJECT_NAME = "ProjectName";

    public static CIMObjectPath projectToCOP(ProjectObj projectObj, CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)string));
        cIMObjectPath2.addKey("SystemName", new CIMValue((Object)string2));
        cIMObjectPath2.addKey(PROJECT_NAME, new CIMValue((Object)projectObj.getProjectName()));
        return cIMObjectPath2;
    }

    public static Vector buildVector(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        if (vector.size() == 0) {
            vector = null;
        }
        vector.trimToSize();
        return vector;
    }

    public static String[] stringToArray(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String[] removeElements(String string, String[] stringArray) {
        if (string == null) {
            return stringArray;
        }
        string = string.trim();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length) {
            if (string.indexOf(stringArray[n]) == -1) {
                stringArray2[n2] = stringArray[n];
                ++n2;
            }
            ++n;
        }
        return stringArray2;
    }

    public static CIMInstance projectToCim(ProjectObj projectObj, CIMClass cIMClass, String string, String string2) throws CIMException {
        CIMInstance cIMInstance = null;
        String string3 = projectObj.getProjectName();
        String string4 = projectObj.getProjectID();
        String string5 = projectObj.getProjectDescription();
        Vector vector = ProjCommon.buildVector(projectObj.getProjectAttributes());
        try {
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty(PROJECT_NAME, new CIMValue((Object)string3));
            cIMInstance.setProperty(PROJECT_ID, new CIMValue((Object)new UnsignedInt32(string4)));
            cIMInstance.setProperty(PROJECT_DESCRIPTION, new CIMValue((Object)string5));
            cIMInstance.setProperty(PROJECT_ATTRIBUTES, new CIMValue((Object)vector));
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)string));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)string2));
        }
        catch (Exception exception) {
            throw new CIMException("GENERAL_EXCEPTION");
        }
        return cIMInstance;
    }

    public static ProjectObj opToProject(CIMObjectPath cIMObjectPath, String string) throws ProjectException {
        ProjectObj projectObj = new ProjectObj();
        String string2 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(PROJECT_NAME) || cIMProperty.getValue() == null) continue;
            string2 = (String)cIMProperty.getValue().getValue();
        }
        if (string2 == null) {
            throw new ProjectException("EXM_PRJ24");
        }
        projectObj.setProjectName(string2);
        return projectObj;
    }

    public static ProjectObj cimToProject(CIMInstance cIMInstance, String string) throws CIMException, ProjectException {
        Object object;
        ProjectObj projectObj = new ProjectObj();
        ProjectObj projectObj2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        CIMValue cIMValue = null;
        cIMValue = cIMInstance.getProperty(PROJECT_NAME).getValue();
        string2 = cIMValue != null ? (String)cIMValue.getValue() : null;
        if (string2 == null) {
            throw new ProjectException("EXM_PRJ24");
        }
        projectObj.setProjectName(string2);
        try {
            object = new SolarisProjectTable(string);
            projectObj2 = ((SolarisProjectTable)object).getProjectRow(projectObj);
        }
        catch (DirectoryTableException directoryTableException) {
            throw new CIMException("GENERAL_EXCEPTION");
        }
        catch (ProjectException projectException) {
            // empty catch block
        }
        if (projectObj2 != null) {
            if (projectObj2.getProjectUsers() != null) {
                projectObj.setProjectUsers(projectObj2.getProjectUsers());
            }
            if (projectObj2.getProjectGroups() != null) {
                projectObj.setProjectGroups(projectObj2.getProjectGroups());
            }
            if (projectObj2.getProjectAttributes() != null) {
                projectObj.setProjectAttributes(projectObj2.getProjectAttributes());
            }
            if (projectObj2.getProjectDescription() != null) {
                projectObj.setProjectDescription(projectObj2.getProjectDescription());
            }
        }
        if ((string3 = (cIMValue = cIMInstance.getProperty(PROJECT_ID).getValue()) != null ? cIMValue.getValue().toString() : null) == null) {
            throw new ProjectException("EXM_PRJ25");
        }
        projectObj.setProjectID(string3);
        cIMValue = cIMInstance.getProperty(PROJECT_DESCRIPTION).getValue();
        string4 = cIMValue != null ? (String)cIMValue.getValue() : null;
        if (string4 != null) {
            projectObj.setProjectDescription(string4);
        }
        if ((cIMValue = cIMInstance.getProperty(PROJECT_ATTRIBUTES).getValue()) != null && (object = (Vector)cIMValue.getValue()) != null) {
            String[] stringArray = new String[((Vector)object).size()];
            int n = 0;
            while (object != null && n < ((Vector)object).size()) {
                stringArray[n] = (String)((Vector)object).elementAt(n);
                ++n;
            }
            projectObj.setProjectAttributes(stringArray);
        }
        return projectObj;
    }
}

