/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchAccumulator;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.util.NoResultException;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PProUtil;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.SolarisPatchInfo;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import com.sun.wbem.utility.log.LogUtil;
import java.io.File;
import java.util.Vector;
import javax.wbem.client.Debug;

public class InstallPatchesByPolicy
extends PPro {
    private String spoolDir;
    private String sequesterDir;
    private File spoolDirHandle;
    private Vector patchList;
    private LogUtil logUtil;
    private static final String VERSION = "1";
    private static final String VERSION_HEADER = "~VERSION~";
    private static final String ERROR_HEADER = "~ERROR~";
    private static final String SEQUESTERED_HEADER = "~SEQUESTERED~";
    private static final String EXCLUDED_HEADER = "~EXCLUDED~";
    private static final String ADDED_HEADER = "~ADDED~";
    private static final String NOTFOUND_HEADER = "~NOTFOUND~";
    private static final String INSTALLED_HEADER = "~INSTALLED~";
    private static final String SEQUESTER_SUBDIR = "patchproSequester";

    public InstallPatchesByPolicy(ProviderUtility providerUtility, LogUtil logUtil) {
        provUtil = providerUtility;
        this.logUtil = logUtil;
    }

    protected void initialize(Vector vector, String string) throws PatchException {
        this.patchList = vector;
        this.spoolDir = string;
        this.sequesterDir = string + System.getProperty("file.separator") + SEQUESTER_SUBDIR;
        if (this.spoolDir != null && this.spoolDir.length() > 0) {
            PProUtil.dirAvailable(this.spoolDir);
        }
        this.spoolDirHandle = new File(string);
        this.init();
        if (this.model == null) {
            throw new PatchException("EXM_INST_UNEXP_ERR");
        }
        this.analyzeHost();
    }

    protected Vector installPatches() {
        Vector<String> vector;
        block32: {
            Object object;
            Object object2;
            vector = new Vector<String>();
            vector.add("~VERSION~1");
            Vector<String> vector2 = new Vector<String>();
            try {
                int n;
                object2 = PatchProProperties.getInstance();
                PatchAccumulator patchAccumulator = this.model.getPatchAccumulator();
                object = new PatchListImpl();
                int n2 = this.patchList != null ? this.patchList.size() : 0;
                int n3 = 0;
                while (n3 < n2) {
                    PatchID patchID = new PatchID((String)this.patchList.elementAt(n3));
                    object = patchAccumulator.getPatchClosure(patchID);
                    ++n3;
                }
                Vector<String> vector3 = new Vector<String>();
                String string = null;
                String string2 = null;
                boolean bl = false;
                int n4 = 0;
                while (n4 < this.patchList.size()) {
                    bl = false;
                    string = (String)this.patchList.elementAt(n4);
                    n = 0;
                    while (n < object.size()) {
                        string2 = object.getPatchAt(n).getPatchID().getPatchID();
                        if (string.equals(string2)) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        vector3.addElement(string);
                    }
                    ++n4;
                }
                n2 = vector3 != null ? vector3.size() : 0;
                n = 0;
                while (n < n2) {
                    vector.add(EXCLUDED_HEADER + vector3.elementAt(n));
                    ++n;
                }
                if (object.size() == 0) {
                    return vector;
                }
                vector2 = new Vector();
                int n5 = 0;
                while (n5 < object.size()) {
                    string2 = object.getPatchAt(n5).getPatchID().getPatchID();
                    if (!this.patchList.contains(string2)) {
                        vector2.addElement(string2);
                    }
                    ++n5;
                }
                if (vector2.size() > 0) {
                    int n6 = 0;
                    while (n6 < vector2.size()) {
                        vector.add(ADDED_HEADER + vector2.elementAt(n6));
                        ++n6;
                    }
                }
                File file = null;
                String string3 = null;
                IPatch iPatch = null;
                try {
                    int n7 = 0;
                    while (n7 < object.size()) {
                        iPatch = (IPatch)object.getPatchAt(n7);
                        string3 = this.spoolDirHandle + System.getProperty("file.separator") + iPatch.getPatchID().getPatchID() + ".jar";
                        file = new File(string3);
                        if (!file.exists()) {
                            vector.add(NOTFOUND_HEADER + iPatch.getPatchID().getPatchID());
                        }
                        file = null;
                        string3 = null;
                        iPatch = null;
                        ++n7;
                    }
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    Debug.trace3((String)"---- InstallPatches looking for patches caught ", (Throwable)noSuchPatchException);
                }
                object2.setProperty("smpatch.request", "true");
                object2.setProperty("patchpro.patch.sequester.directory", this.sequesterDir);
                object2.setProperty("patchpro.download.directory", this.spoolDir);
                this.prepForThread();
                Debug.trace3((String)"---- InstallPatches about to install");
                this.model.installPatches((PatchList)object, this.spoolDirHandle);
                this.waitForThread();
                Debug.trace3((String)"---- InstallPatches install finished ok");
            }
            catch (NoSuchPatchException noSuchPatchException) {
                Debug.trace3((String)"---- InstallPatches installing patches (missing) caught ", (Throwable)noSuchPatchException);
            }
            catch (MalformedPatchException malformedPatchException) {
                Debug.trace3((String)"---- InstallPatches installing patches (malform) caught ", (Throwable)malformedPatchException);
            }
            catch (NoResultException noResultException) {
                Debug.trace3((String)"InstallPatches installing patches (no result) caught ", (Throwable)noResultException);
            }
            catch (PatchException patchException) {
                Debug.trace3((String)"InstallPatches installing patches caught ", (Throwable)((Object)patchException));
            }
            if (this.nonfatalProblems.size() > 0) {
                object2 = "";
                int n = 0;
                while (n < this.nonfatalProblems.size()) {
                    vector.add("~ERROR~ " + (String)this.nonfatalProblems.elementAt(n));
                    object2 = (String)object2 + "\n" + " " + (String)this.nonfatalProblems.elementAt(n);
                    ++n;
                }
                PPro.provUtil.writeLog(2, "LM_8904", "LM_8905", (String)object2, null, null, null, null);
            }
            try {
                Debug.trace1((String)"---- InstallPatches getting system patch list");
                object2 = new SolarisPatchInfo(PPro.provUtil);
                Vector vector4 = ((SolarisPatchInfo)object2).getPatchListData();
                String string = null;
                Debug.trace1((String)("---- InstallPatches got system patch list: " + vector4));
                int n = 0;
                while (vector4 != null && n < vector4.size()) {
                    object = (SolarisPatchObj)vector4.elementAt(n);
                    String string4 = ((SolarisPatchObj)object).getPatchName();
                    if (this.patchList.contains(string4) || vector2.contains(string4)) {
                        vector.add(INSTALLED_HEADER + string4);
                        string = string == null ? string4 : string + " ," + string4;
                    }
                    ++n;
                }
                if (string != null) {
                    PPro.provUtil.writeLog(0, "LM_8906", "LM_8907", string, null, null, null, null);
                }
                Debug.trace1((String)("---- InstallPatches installedlist: " + string));
            }
            catch (PatchException patchException) {
                Debug.trace3((String)"---- InstallPatches getting installed threw: ", (Throwable)((Object)patchException));
            }
            try {
                int n;
                object2 = this.model.getUninstalledPatches();
                Debug.trace3((String)("---- InstallPatches uninstalled: " + object2));
                if (object2 == null || (n = object2.size()) == 0) break block32;
                object = null;
                String string = null;
                String string5 = null;
                int n8 = 0;
                while (n8 < object2.size()) {
                    block33: {
                        try {
                            object = object2.getPatchAt(n8);
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            break block33;
                        }
                        string5 = object.getPatchID().getPatchID();
                        vector.add(SEQUESTERED_HEADER + string5);
                        string = string == null ? string5 : string + " ," + string5;
                    }
                    ++n8;
                }
                PPro.provUtil.writeLog(0, "LM_8902", "LM_8903", this.sequesterDir, string, null, null, null);
            }
            catch (Exception exception) {
                Debug.trace3((String)"InstallPatches getting uninstalled caught ", (Throwable)exception);
            }
        }
        return vector;
    }
}

