/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.repository;

import com.sun.wbem.repository.PersistentStore;
import java.io.IOException;
import java.io.Serializable;

class CIMRlogEntry
implements Serializable {
    private static final long serialVersionUID = 4012529228189L;
    protected String name;
    protected static PersistentStore store;
    private long objectID = -1L;

    protected static String toNameKey(String string) {
        return string.toLowerCase();
    }

    public static void setPersistentStore(PersistentStore persistentStore) {
        store = persistentStore;
    }

    public CIMRlogEntry() {
    }

    public CIMRlogEntry(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return CIMRlogEntry.toNameKey(this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof CIMRlogEntry) {
            CIMRlogEntry cIMRlogEntry = (CIMRlogEntry)object;
            return cIMRlogEntry.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public byte[] getValue() {
        if (this.objectID == -1L) {
            return null;
        }
        try {
            byte[] byArray = null;
            byArray = store.readObjectBytes(this.objectID);
            return byArray;
        }
        catch (IOException iOException) {
            System.out.println("exception:" + iOException);
            iOException.printStackTrace();
            return null;
        }
    }

    private void deletePersistObject() {
        if (this.objectID != -1L) {
            store.deleteObject(this.objectID);
        }
        this.objectID = -1L;
    }

    public void createPersistObject(byte[] byArray) {
        try {
            if (byArray == null || byArray.length == 0) {
                this.delete();
                return;
            }
            long l = store.writeObjectBytes(byArray);
            this.setID(l);
        }
        catch (IOException iOException) {
            System.out.println("exception:" + iOException);
            iOException.printStackTrace();
        }
    }

    public void setID(long l) {
        this.delete();
        this.objectID = l;
    }

    public long getID() {
        return this.objectID;
    }

    public void delete() {
        if (this.objectID != -1L) {
            store.deleteObject(this.objectID);
        }
        this.objectID = -1L;
    }

    public PersistentStore.PersistObject getPersistObject() {
        if (this.objectID == -1L) {
            throw new RuntimeException("CIMRlogEntry contains no object");
        }
        return store.getPersistObject(this.objectID);
    }
}

