/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.Ascii;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class HttpDate
extends Ascii {
    private static final String DATESTR = "Sun, 06 Nov 1994 08:49:37 GMT";
    public static final int DATELEN = "Sun, 06 Nov 1994 08:49:37 GMT".length();
    private static final String datePattern = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static final Locale loc = Locale.US;
    private static final TimeZone zone = TimeZone.getTimeZone("GMT");
    private static final SimpleDateFormat dformat = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", loc);
    protected Calendar calendar = new GregorianCalendar(zone, loc);

    public HttpDate() {
        this.calendar.setTime(new Date(System.currentTimeMillis()));
    }

    public HttpDate(long l) {
        this.calendar.setTime(new Date(l));
    }

    public void setTime() {
        this.calendar.setTime(new Date(System.currentTimeMillis()));
    }

    public void setTime(long l) {
        this.calendar.setTime(new Date(l));
    }

    public void parse(String string) {
        try {
            Date date = dformat.parse(string);
            this.calendar.setTime(date);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Date format invalid: " + string);
        }
    }

    public void parse(byte[] byArray, int n, int n2) {
        String string = new String(byArray, n, n2);
        this.parse(string);
    }

    public void write(OutputStream outputStream) throws IOException {
        String string = dformat.format(this.calendar.getTime());
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    public String toString() {
        return dformat.format(this.calendar.getTime());
    }

    public long getTime() {
        return this.calendar.getTime().getTime();
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public int getBytes(byte[] byArray, int n, int n2) {
        if (n2 < DATELEN) {
            throw new IllegalArgumentException("array too small");
        }
        String string = dformat.format(this.calendar.getTime());
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, n, DATELEN);
        return DATELEN;
    }

    static {
        dformat.setTimeZone(zone);
    }
}

