/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.HttpDate;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.http.Cookie;

public class CookieUtils {
    private static final String tspecials = "()<>@,;:\\\"/[]?={} \t";

    public static String getCookieHeader(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = cookie.getVersion();
        stringBuffer.append(cookie.getName());
        stringBuffer.append("=");
        CookieUtils.maybeQuote(n, stringBuffer, cookie.getValue());
        if (n == 1) {
            stringBuffer.append(";Version=1");
            if (cookie.getComment() != null) {
                stringBuffer.append(";Comment=");
                CookieUtils.maybeQuote(n, stringBuffer, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            stringBuffer.append(";Domain=");
            CookieUtils.maybeQuote(n, stringBuffer, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (n == 0) {
                stringBuffer.append(";Expires=");
                new OldCookieExpiry(cookie.getMaxAge()).append(stringBuffer);
            } else {
                stringBuffer.append(";MaxAge=");
                stringBuffer.append(cookie.getMaxAge());
            }
        } else if (n == 1) {
            stringBuffer.append(";Discard");
        }
        if (cookie.getPath() != null) {
            stringBuffer.append(";Path=");
            CookieUtils.maybeQuote(n, stringBuffer, cookie.getPath());
        }
        if (cookie.getSecure()) {
            stringBuffer.append(";Secure");
        }
        if (n == 1) {
            Cookie cookie2 = (Cookie)cookie.clone();
            cookie2.setVersion(0);
            StringBuffer stringBuffer2 = new StringBuffer("Set-Cookie2: ");
            stringBuffer2.append(stringBuffer + "\r\n");
            stringBuffer2.append(CookieUtils.getCookieHeader(cookie2));
            return stringBuffer2.toString();
        }
        return "Set-Cookie: " + stringBuffer.toString();
    }

    private static void maybeQuote(int n, StringBuffer stringBuffer, String string) {
        if (n == 0 || CookieUtils.isToken(string)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
    }

    private static boolean isToken(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    static class OldCookieExpiry
    extends HttpDate {
        OldCookieExpiry(long l) {
            this.setTime(OldCookieExpiry.getCurrentTime() + l * 1000L);
        }

        void append(StringBuffer stringBuffer) {
            String string = "EEE, dd-MMM-yyyyy HH:mm:ss z";
            Locale locale = Locale.US;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
            String string2 = simpleDateFormat.format(this.calendar.getTime());
            stringBuffer.append(string2);
        }
    }
}

