/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import com.sun.xml.parser.Parser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class HttpServerRequestHandler
implements RequestHandler {
    protected void doErrorOutput(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        dataOutputStream.writeBytes("<HTML><HEAD><TITLE>");
        dataOutputStream.writeBytes(string);
        dataOutputStream.writeBytes("</TITLE></HEAD><BODY>\n");
        dataOutputStream.writeBytes(string + " - " + string2);
        dataOutputStream.writeBytes("</BODY></HTML>");
    }

    protected void do501Error(DataOutputStream dataOutputStream) {
        try {
            String string = "501 Not Implemented";
            dataOutputStream.writeBytes("HTTP/1.0 " + string + "\r\n\r\n");
            this.doErrorOutput(dataOutputStream, string, "The requested METHOD is not supported");
        }
        catch (IOException iOException) {
            Debug.trace1("IOException: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    protected void do500Error(DataOutputStream dataOutputStream, String string) {
        try {
            String string2 = "500 Internal Server Error";
            dataOutputStream.writeBytes("HTTP/1.0 " + string2 + "\r\n\r\n");
            this.doErrorOutput(dataOutputStream, string2, "An internal error occurred while processing the request<br><b>" + string + "</b>");
        }
        catch (IOException iOException) {
            Debug.trace1("IOException: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    protected void do404Error(DataOutputStream dataOutputStream, String string) {
        try {
            String string2 = "404 Not Found";
            dataOutputStream.writeBytes("HTTP/1.0 " + string2 + "\r\n\r\n");
            this.doErrorOutput(dataOutputStream, string2, "The requested URI was not found: " + string);
        }
        catch (IOException iOException) {
            Debug.trace1("IOException: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    protected XmlDocument getXmlDocument(InboundRequest inboundRequest) throws IOException, SAXException {
        Parser parser = new Parser();
        XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
        InputSource inputSource = new InputSource();
        xmlDocumentBuilder.setDisableNamespaces(false);
        parser.setDocumentHandler((DocumentHandler)xmlDocumentBuilder);
        inputSource.setByteStream(inboundRequest.getRequestInputStream());
        parser.parse(inputSource);
        XmlDocument xmlDocument = xmlDocumentBuilder.getDocument();
        return xmlDocument;
    }
}

