/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import javax.wbem.client.adapter.http.transport.Header;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import javax.wbem.client.adapter.http.transport.MessageReader;
import javax.wbem.client.adapter.http.transport.MessageWriter;
import javax.wbem.client.adapter.http.transport.Request;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import javax.wbem.client.adapter.http.transport.StartLine;
import javax.wbem.client.adapter.http.transport.TimedConnection;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.GetThreadPoolAction;

public abstract class HttpServerConnection
implements TimedConnection {
    private static final int HTTP_MAJOR = 1;
    private static final int HTTP_MINOR = 1;
    private static final int UNSTARTED = 0;
    private static final int IDLE = 1;
    private static final int BUSY = 2;
    private static final int CLOSED = 3;
    private static final String serverString = "Java/" + System.getProperty("java.version", "???") + " " + (class$javax$wbem$client$adapter$http$transport$HttpServerConnection == null ? (class$javax$wbem$client$adapter$http$transport$HttpServerConnection = HttpServerConnection.class$("javax.wbem.client.adapter.http.transport.HttpServerConnection")) : class$javax$wbem$client$adapter$http$transport$HttpServerConnection).getName();
    private static final Executor userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
    private Socket sock;
    private InputStream in;
    private OutputStream out;
    private RequestHandler handler;
    private int state = 0;
    private Object stateLock = new Object();
    static /* synthetic */ Class class$javax$wbem$client$adapter$http$transport$HttpServerConnection;

    public HttpServerConnection(Socket socket, RequestHandler requestHandler) throws IOException {
        if (requestHandler == null) {
            throw new NullPointerException();
        }
        this.sock = socket;
        this.handler = requestHandler;
        this.in = new BufferedInputStream(socket.getInputStream());
        this.out = new BufferedOutputStream(socket.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException();
            }
            this.state = 1;
            userThreadPool.execute((Runnable)new Dispatcher(), "HTTP dispatcher");
        }
    }

    protected void checkPermissions() {
    }

    protected abstract String getClientHost();

    protected void idle() {
    }

    protected void busy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean bl) {
        Object object = this.stateLock;
        synchronized (object) {
            block8: {
                block7: {
                    if (this.state != 3) break block7;
                    boolean bl2 = true;
                    return bl2;
                }
                if (bl || this.state != 2) break block8;
                boolean bl3 = false;
                return bl3;
            }
            this.state = 3;
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static boolean supportsPersist(StartLine startLine, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int n = StartLine.compareVersions(startLine.major, startLine.minor, 1, 1);
        return n >= 0;
    }

    private static boolean supportsChunking(StartLine startLine, Header header) {
        int n = StartLine.compareVersions(startLine.major, startLine.minor, 1, 1);
        return n >= 0 && header.containsValue("TE", "trailers", true);
    }

    private static Header createResponseHeader(Header header, boolean bl) {
        long l = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(l));
        header.setField("Server", serverString);
        header.setField("Connection", bl ? "Keep-Alive" : "close");
        return header;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class InboundRequestImpl
    extends Request
    implements InboundRequest {
        private MessageReader reader;
        private MessageWriter writer;
        private boolean corrupt = false;
        private Header header;
        private Header respondHeader = new Header();

        InboundRequestImpl(MessageReader messageReader, MessageWriter messageWriter, Header header) {
            this.reader = messageReader;
            this.writer = messageWriter;
            this.header = header;
        }

        public void checkPermissions() {
            HttpServerConnection.this.checkPermissions();
        }

        public String getClientHost() {
            return HttpServerConnection.this.getClientHost();
        }

        public InputStream getRequestInputStream() {
            return this.getInputStream();
        }

        public OutputStream getResponseOutputStream() {
            return this.getOutputStream();
        }

        public String getHeaderField(String string) {
            return this.header.getField(string);
        }

        public void setRespondHeaderField(String string, String string2) {
            this.respondHeader.setField(string, string2);
        }

        Header getRespondHeader() {
            return this.respondHeader;
        }

        boolean streamCorrupt() {
            return this.corrupt;
        }

        void startOutput() throws IOException {
        }

        void write(byte[] byArray, int n, int n2) throws IOException {
            this.writer.writeContent(byArray, n, n2);
        }

        void endOutput() throws IOException {
            this.writer.writeTrailer(null);
        }

        boolean startInput() throws IOException {
            return true;
        }

        int read(byte[] byArray, int n, int n2) throws IOException {
            return this.reader.readContent(byArray, n, n2);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
        }

        void done(boolean bl) {
            this.corrupt = bl;
        }
    }

    private final class Dispatcher
    implements Runnable {
        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {}
                catch (IOException iOException) {
                    Object var8_10 = null;
                    HttpServerConnection.this.shutdown(true);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                HttpServerConnection.this.shutdown(true);
                throw throwable;
            }
            while (true) {
                StartLine startLine;
                HttpServerConnection.this.idle();
                MessageReader messageReader = new MessageReader(HttpServerConnection.this.in, false);
                try {
                    startLine = messageReader.readStartLine();
                }
                catch (IOException iOException) {
                    if (!iOException.getMessage().equals("empty start line")) throw iOException;
                    continue;
                }
                HttpServerConnection.this.busy();
                Object object = HttpServerConnection.this.stateLock;
                synchronized (object) {
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT @DISABLED, blocks:[16, 7, 12] lbl29 : MonitorExitStatement: MONITOREXIT : var3_4
                        Object var8_8 = null;
                        HttpServerConnection.this.shutdown(true);
                        return;
                    }
                    HttpServerConnection.this.state = 2;
                }
                Header header = messageReader.readHeader();
                if ("POST".equals(startLine.method)) {
                    this.handleRequest(startLine, header, messageReader);
                } else {
                    this.handleBadRequest(startLine, header, messageReader);
                }
                Object object2 = HttpServerConnection.this.stateLock;
                synchronized (object2) {
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT @DISABLED, blocks:[8, 12, 13] lbl46 : MonitorExitStatement: MONITOREXIT : var5_7
                        Object var8_9 = null;
                        HttpServerConnection.this.shutdown(true);
                        return;
                    }
                    HttpServerConnection.this.state = 1;
                }
            }
        }

        private void handleBadRequest(StartLine startLine, Header header, MessageReader messageReader) throws IOException {
            header.merge(messageReader.readTrailer());
            boolean bl = HttpServerConnection.supportsPersist(startLine, header);
            MessageWriter messageWriter = new MessageWriter(HttpServerConnection.this.out, false);
            if ("M-POST".equals(startLine.method)) {
                messageWriter.writeStartLine(new StartLine(1, 1, 501, "Not Implemented."));
            } else {
                messageWriter.writeStartLine(new StartLine(1, 1, 400, "Bad Request"));
            }
            messageWriter.writeHeader(HttpServerConnection.createResponseHeader(new Header(), bl));
            messageWriter.writeTrailer(null);
            if (!bl) {
                HttpServerConnection.this.shutdown(true);
            }
        }

        private void handleRequest(StartLine startLine, Header header, MessageReader messageReader) throws IOException {
            boolean bl = HttpServerConnection.supportsPersist(startLine, header);
            boolean bl2 = HttpServerConnection.supportsChunking(startLine, header);
            MessageWriter messageWriter = new MessageWriter(HttpServerConnection.this.out, bl2);
            InboundRequestImpl inboundRequestImpl = new InboundRequestImpl(messageReader, messageWriter, header);
            if (!HttpServerConnection.this.handler.checkAuthentication(inboundRequestImpl)) {
                messageWriter.writeStartLine(new StartLine(1, 1, 401, "Unauthorized"));
                Header header2 = inboundRequestImpl.getRespondHeader();
                messageWriter.writeHeader(header2);
                messageWriter.writeTrailer(null);
                return;
            }
            HttpServerConnection.this.handler.addResponseHeaderFields(inboundRequestImpl);
            messageWriter.writeStartLine(new StartLine(1, 1, 200, "OK"));
            messageWriter.writeHeader(HttpServerConnection.createResponseHeader(inboundRequestImpl.getRespondHeader(), bl));
            try {
                HttpServerConnection.this.handler.handleRequest(inboundRequestImpl);
            }
            catch (Throwable throwable) {
                System.out.println("throwale th:");
            }
            inboundRequestImpl.finish();
            if (!bl || inboundRequestImpl.streamCorrupt()) {
                HttpServerConnection.this.shutdown(true);
            }
        }
    }
}

