/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.Debug;

class CIMClientFactory {
    public static final String XML_PROTOCOL_NAME = "cim-xml";
    public static final String RMI_PROTOCOL_NAME = "cim-rmi";
    private static final String PROP_DEFAULT_FILE = "javax.wbem.client.WbemDefaults";
    private static final String PROP_EXTEND_FILE = "WbemClient";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_NAME = "name";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_CLASS = "client.class";
    private static final String XML_CLASS_NAME = "javax.wbem.client.adapter.http.CIMClientXML";
    private static final String RMI_CLASS_NAME = "javax.wbem.client.adapter.rmi.CIMClientRMI";
    private static Properties props = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$wbem$cim$CIMNameSpace;
    static /* synthetic */ Class class$javax$wbem$client$CIMListener;
    static /* synthetic */ Class class$java$lang$Integer;

    CIMClientFactory() {
    }

    public static CIMClientAPI getClientAPI(String string, CIMNameSpace cIMNameSpace, String string2, int n, CIMListener cIMListener) throws CIMException {
        String string3;
        String string4;
        String string5 = string2;
        if ((string2 == null || string2.trim().length() == 0) && (string5 = CIMClientFactory.getProperty(string4 = "transport.protocol.default")) == null) {
            string5 = RMI_PROTOCOL_NAME;
        }
        if (!((string5 = string5.toLowerCase()) == null || (string3 = CIMClientFactory.getProperty(string4 = "transport.protocol.name." + string5)) != null && string5.equalsIgnoreCase(string3))) {
            string5 = null;
        }
        if (string5 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "protocol name");
        }
        Debug.trace1("Client adapter protocol name: " + string5);
        string4 = "transport." + string5 + "." + PROP_CLASS;
        string3 = CIMClientFactory.getProperty(string4);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3);
        }
        catch (Exception exception) {
            throw new CIMTransportException("CIM_ERR_NOT_FOUND", "protocol class");
        }
        CIMClientAPI cIMClientAPI = null;
        try {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CIMClientFactory.class$("java.lang.String")) : class$java$lang$String, class$javax$wbem$cim$CIMNameSpace == null ? (class$javax$wbem$cim$CIMNameSpace = CIMClientFactory.class$("javax.wbem.cim.CIMNameSpace")) : class$javax$wbem$cim$CIMNameSpace, class$javax$wbem$client$CIMListener == null ? (class$javax$wbem$client$CIMListener = CIMClientFactory.class$("javax.wbem.client.CIMListener")) : class$javax$wbem$client$CIMListener, class$java$lang$Integer == null ? (class$java$lang$Integer = CIMClientFactory.class$("java.lang.Integer")) : class$java$lang$Integer};
            Object[] objectArray = new Object[]{string, cIMNameSpace, cIMListener, new Integer(n)};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            cIMClientAPI = (CIMClientAPI)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CIMException) {
                CIMException cIMException = (CIMException)throwable;
                throw cIMException;
            }
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)throwable);
        }
        catch (Exception exception) {
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)exception);
        }
        return cIMClientAPI;
    }

    private static synchronized String getProperty(String string) throws CIMException {
        if (props == null) {
            CIMClientFactory.initProperties();
        }
        return props.getProperty(string);
    }

    private static List getPropertyList(String string) throws CIMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (props == null) {
            CIMClientFactory.initProperties();
        }
        boolean bl = false;
        boolean bl2 = true;
        String string2 = string.concat(".");
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(string2) || (string3 = props.getProperty(string4)) == null) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private static void initProperties() throws CIMException {
        if (props == null) {
            props = new Properties();
            try {
                CIMClientFactory.loadProperties(PROP_DEFAULT_FILE);
            }
            catch (Exception exception) {
                Debug.trace1("Error loading WbemDefaults properties.");
                throw new CIMException("CIM_ERR_FAILED", PROP_DEFAULT_FILE);
            }
            try {
                CIMClientFactory.loadProperties(PROP_EXTEND_FILE);
            }
            catch (MissingResourceException missingResourceException) {
                Debug.trace1("Error loading properties: WbemClient");
            }
            if (Debug.isOn()) {
                Debug.trace3("Client configuration properties:");
                Enumeration<?> enumeration = props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = props.getProperty(string);
                    if (string2 == null) {
                        string2 = "null";
                    }
                    Debug.trace3("    " + string + " \t" + string2);
                }
            }
        }
    }

    private static void loadProperties(String string) throws CIMException {
        PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(string, new Locale("", ""));
        if (propertyResourceBundle != null) {
            String string2 = null;
            Enumeration<String> enumeration = propertyResourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                try {
                    string2 = propertyResourceBundle.getString(string3);
                }
                catch (Exception exception) {
                    string3 = null;
                }
                if (string3 == null) continue;
                props.setProperty(string3, string2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

