/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.MOFFormatter;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;

public class CIMDataType
implements Serializable {
    static final long serialVersionUID = 200L;
    private int type;
    private String refClassName;
    private int size;
    public static final int SIZE_SINGLE = -1;
    public static final int SIZE_UNLIMITED = -2;
    public static final int INVALID = -1;
    public static final int UINT8 = 0;
    public static final int SINT8 = 1;
    public static final int UINT16 = 2;
    public static final int SINT16 = 3;
    public static final int UINT32 = 4;
    public static final int SINT32 = 5;
    public static final int UINT64 = 6;
    public static final int SINT64 = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN = 9;
    public static final int REAL32 = 10;
    public static final int REAL64 = 11;
    public static final int DATETIME = 12;
    public static final int CHAR16 = 13;
    public static final int UINT8_ARRAY = 14;
    public static final int SINT8_ARRAY = 15;
    public static final int UINT16_ARRAY = 16;
    public static final int SINT16_ARRAY = 17;
    public static final int UINT32_ARRAY = 18;
    public static final int SINT32_ARRAY = 19;
    public static final int UINT64_ARRAY = 20;
    public static final int SINT64_ARRAY = 21;
    public static final int STRING_ARRAY = 22;
    public static final int BOOLEAN_ARRAY = 23;
    public static final int REAL32_ARRAY = 24;
    public static final int REAL64_ARRAY = 25;
    public static final int DATETIME_ARRAY = 26;
    public static final int CHAR16_ARRAY = 27;
    public static final int REFERENCE = 28;
    public static final int OBJECT = 29;
    public static final int NULL = 30;
    public static final int CLASS = 31;
    protected static CIMDataType[] predefined = new CIMDataType[30];

    public static final int findType(Object object) {
        if (object == null) {
            return 30;
        }
        if (object instanceof Vector) {
            return CIMDataType.findType((Vector)object);
        }
        if (object instanceof UnsignedInt8) {
            return 0;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof UnsignedInt16) {
            return 2;
        }
        if (object instanceof Short) {
            return 3;
        }
        if (object instanceof UnsignedInt32) {
            return 4;
        }
        if (object instanceof Integer) {
            return 5;
        }
        if (object instanceof UnsignedInt64) {
            return 6;
        }
        if (object instanceof Long) {
            return 7;
        }
        if (object instanceof String) {
            return 8;
        }
        if (object instanceof Boolean) {
            return 9;
        }
        if (object instanceof Float) {
            return 10;
        }
        if (object instanceof Double) {
            return 11;
        }
        if (object instanceof Character) {
            return 13;
        }
        if (object instanceof CIMDateTime) {
            return 12;
        }
        if (object instanceof CIMObjectPath) {
            return 28;
        }
        if (object instanceof CIMInstance) {
            return 29;
        }
        if (object instanceof CIMClass) {
            return 31;
        }
        return -1;
    }

    public static CIMDataType getDataType(String string) throws CIMException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("boolean")) {
            return new CIMDataType(9);
        }
        if (string.equals("char16")) {
            return new CIMDataType(13);
        }
        if (string.equals("datetime")) {
            return new CIMDataType(12);
        }
        if (string.equals("real32")) {
            return new CIMDataType(10);
        }
        if (string.equals("real64")) {
            return new CIMDataType(11);
        }
        if (string.equals("sint16")) {
            return new CIMDataType(3);
        }
        if (string.equals("sint32")) {
            return new CIMDataType(5);
        }
        if (string.equals("sint64")) {
            return new CIMDataType(7);
        }
        if (string.equals("sint8")) {
            return new CIMDataType(1);
        }
        if (string.equals("string")) {
            return new CIMDataType(8);
        }
        if (string.equals("uint16")) {
            return new CIMDataType(2);
        }
        if (string.equals("uint32")) {
            return new CIMDataType(4);
        }
        if (string.equals("uint64")) {
            return new CIMDataType(6);
        }
        if (string.equals("uint8")) {
            return new CIMDataType(0);
        }
        return new CIMDataType(8);
    }

    public static CIMDataType getDataType(String string, boolean bl) throws CIMException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            if (string.equals("boolean")) {
                return new CIMDataType(23);
            }
            if (string.equals("char16")) {
                return new CIMDataType(27);
            }
            if (string.equals("datetime")) {
                return new CIMDataType(26);
            }
            if (string.equals("real32")) {
                return new CIMDataType(24);
            }
            if (string.equals("real64")) {
                return new CIMDataType(25);
            }
            if (string.equals("sint16")) {
                return new CIMDataType(17);
            }
            if (string.equals("sint32")) {
                return new CIMDataType(19);
            }
            if (string.equals("sint64")) {
                return new CIMDataType(21);
            }
            if (string.equals("sint8")) {
                return new CIMDataType(15);
            }
            if (string.equals("string")) {
                return new CIMDataType(22);
            }
            if (string.equals("uint16")) {
                return new CIMDataType(16);
            }
            if (string.equals("uint32")) {
                return new CIMDataType(18);
            }
            if (string.equals("uint64")) {
                return new CIMDataType(20);
            }
            if (string.equals("uint8")) {
                return new CIMDataType(14);
            }
            return new CIMDataType(22);
        }
        return CIMDataType.getDataType(string);
    }

    public static final int findType(Vector vector) {
        if (vector == null) {
            return 30;
        }
        Object var1_1 = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            var1_1 = vector.elementAt(n2);
            if (var1_1 != null) break;
            ++n2;
        }
        if (var1_1 == null) {
            return 30;
        }
        int n3 = CIMDataType.findType(var1_1);
        return CIMDataType.findArrayType(n3);
    }

    public static final int findArrayType(int n) {
        if (n < 0 || n > 13) {
            return -1;
        }
        return n + 14;
    }

    public static final int findSimpleType(int n) {
        if (n < 14 || n > 27) {
            return -1;
        }
        return n - 14;
    }

    public CIMDataType(int n) {
        if ((n < 0 || n > 27) && n != 29 && n != 31) {
            throw new IllegalArgumentException();
        }
        this.size = n > 13 && n < 28 ? -2 : -1;
        this.type = n;
        this.refClassName = null;
    }

    public CIMDataType(int n, int n2) {
        if (n < 14 || n > 27) {
            throw new IllegalArgumentException(n + "");
        }
        if (n2 != -2 && n2 <= 0) {
            throw new IllegalArgumentException(n2 + "");
        }
        this.type = n;
        this.size = n2;
        this.refClassName = null;
    }

    public static CIMDataType getPredefinedType(int n) {
        if ((n < 0 || n > 27) && n != 29 && n != 31) {
            throw new IllegalArgumentException();
        }
        if (predefined[n] == null) {
            CIMDataType.predefined[n] = new CIMDataType(n);
        }
        return predefined[n];
    }

    public CIMDataType(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.type = 28;
        this.refClassName = string;
        this.size = -1;
    }

    public boolean isArrayType() {
        return this.type >= 14 && this.type <= 27;
    }

    public boolean isReferenceType() {
        return this.type == 28;
    }

    public int getType() {
        return this.type;
    }

    int getType(String string) {
        Field[] fieldArray = this.getClass().getFields();
        try {
            int n = 0;
            while (n < fieldArray.length) {
                if (string.equalsIgnoreCase(fieldArray[n].getName())) {
                    return fieldArray[n].getInt(fieldArray[n]);
                }
                ++n;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public int getSize() {
        return this.size;
    }

    public String getRefClassName() {
        return this.refClassName;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CIMDataType)) {
            return false;
        }
        CIMDataType cIMDataType = (CIMDataType)object;
        if (this.refClassName == null && cIMDataType.refClassName != null) {
            return false;
        }
        if (this.refClassName != null && !this.refClassName.equals(cIMDataType.refClassName)) {
            return false;
        }
        return this.type == cIMDataType.type && this.size == cIMDataType.size;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }
}

