/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.security.CertificateStore;
import com.sun.management.viperimpl.util.security.SMCSSLConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public final class RootCACertificateStore
implements CertificateStore {
    private static String _filename = null;
    private static char[] _storepass = null;
    private KeyStore _cacerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            if (this._cacerts == null) {
                this._cacerts = KeyStore.getInstance("JKS");
                this._cacerts.load(null, null);
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(_filename);
                    if (!file.exists()) {
                        throw new KeyStoreException("Root Certificates not loaded!");
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    RootCACertificateStore.this._cacerts.load(bufferedInputStream, _storepass);
                    bufferedInputStream.close();
                    fileInputStream.close();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            exception.printStackTrace();
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    RootCACertificateStore.this._cacerts.store(bufferedOutputStream, _storepass);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            exception.printStackTrace();
        }
    }

    public void replaceSMC(String string, Certificate certificate) throws KeyStoreException {
        this._cacerts.setCertificateEntry(string, certificate);
    }

    public void add(Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Cannot add root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Cannot remove root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this._cacerts.getCertificateAlias(certificate) != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._cacerts.getCertificate(string);
            try {
                certificate.verify(certificate2.getPublicKey());
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._cacerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    public KeyStore getKeyStore() {
        return this._cacerts;
    }

    static {
        _filename = SMCSSLConfig.getRootCertificateFile();
        _storepass = SMCSSLConfig.getKeyStorePasswd();
    }
}

