/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.AdminUserWizard;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;

public class AdminUserUIDStep
extends VWizardCard {
    private VUserMgr theApp;
    ResourceBundle bundle;
    private AdminUserWizard wiz;
    private ServiceWrapper userMgrClient;
    private JIntSpinBox uidField;
    private GenInfoPanel infoPanel;
    private UMgrContextHelpListener overviewHelpListener;
    public static final int HELP_CACHE_SIZE = 2;

    public AdminUserUIDStep(VUserMgr vUserMgr, AdminUserWizard adminUserWizard) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.wiz = adminUserWizard;
        this.userMgrClient = vUserMgr.getUserMgr();
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_uid"));
        this.constructStep();
    }

    public void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "au_wiz_user_uid");
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        String string = this.wiz.getUID();
        try {
            if (string.equals("") || !CheckSyntax.isUIDOK((String)string)) {
                string = this.userMgrClient.getNextAvailableUID();
            }
        }
        catch (AdminException adminException) {
            // empty catch block
        }
        this.uidField = new JIntSpinBox(10, 100, Integer.MAX_VALUE);
        this.uidField.getTextField().setText(string);
        this.uidField.getTextField().setHorizontalAlignment(4);
        jLabel.setLabelFor(this.uidField.getTextField());
        Constraints.constrain((Container)((Object)this), (Component)this.uidField, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)24, (int)12, (int)0, (int)0);
    }

    public void start() {
        super.start();
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), false);
    }

    public boolean stop(boolean bl) {
        String string = this.uidField.getStringValue();
        if (string.equals("")) {
            String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string2);
            return false;
        }
        if (!CheckSyntax.isUIDOK((String)string)) {
            String string3 = CheckSyntax.getErrorString();
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string3);
            return false;
        }
        this.wiz.setUID(string);
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    public void loadHelp() {
        Vector vector = new Vector(2);
        this.infoPanel = this.wiz.getInfoPanel();
        UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_uid_step");
        this.uidField.getTextField().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.uidField.getDownButton().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.uidField.getUpButton().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.overviewHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_uid_step");
        ContextHelpListener.loadHelp(vector);
    }

    private void setUpLabel(JLabel jLabel, String string) {
        ActionString actionString = new ActionString(this.bundle, string);
        jLabel.setText(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
    }
}

