/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.RightsProps;
import com.sun.admin.usermgr.client.users.SolGenProps;
import com.sun.admin.usermgr.client.users.SolGrpProps;
import com.sun.admin.usermgr.client.users.SolHdirProps;
import com.sun.admin.usermgr.client.users.SolMailProps;
import com.sun.admin.usermgr.client.users.SolPassOpProps;
import com.sun.admin.usermgr.client.users.SolPassProps;
import com.sun.admin.usermgr.client.users.SolProjProps;
import com.sun.admin.usermgr.client.users.SolRoleProps;
import com.sun.admin.usermgr.client.users.UserContent;
import com.sun.admin.usermgr.client.users.UserPoliciesDlg;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdminUserTabs
extends JTabbedPane {
    private UserObj userObj = null;
    private GenInfoPanel infoPanel;
    private SolGenProps solGenProps;
    private SolGrpProps solGrpProps;
    private SolProjProps solProjProps;
    private SolPassProps solPassProps;
    private SolPassOpProps solPassOpProps;
    private SolHdirProps solHdirProps;
    private SolMailProps solMailProps;
    private RightsProps rightsProps;
    private SolRoleProps solRoleProps;
    private boolean isGenVisited;
    private boolean isPassVisited;
    private boolean isPassOpVisited;
    private boolean isGrpVisited;
    private boolean isHdirVisited;
    private boolean isMailVisited;
    private boolean isRightsVisited;
    private boolean isRoleVisited;
    private boolean isProjVisited;
    private boolean showProjectTab;
    private boolean showPasswdTab;
    private VUserMgr theApp;
    private ResourceBundle bundle;

    public AdminUserTabs(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel, boolean bl) {
        this.theApp = vUserMgr;
        this.userObj = userObj;
        this.infoPanel = genInfoPanel;
        this.bundle = vUserMgr.getResourceBundle();
        this.isGenVisited = true;
        this.isPassVisited = false;
        this.isPassOpVisited = false;
        this.isGrpVisited = false;
        this.isHdirVisited = false;
        this.isMailVisited = false;
        this.isRightsVisited = false;
        this.isRoleVisited = false;
        this.showProjectTab = true;
        this.showPasswdTab = bl;
        this.adminUserTabsInit();
    }

    private void adminUserTabsInit() {
        AdminUserTabsListener adminUserTabsListener = new AdminUserTabsListener();
        this.addChangeListener(adminUserTabsListener);
        this.addFocusListener(new TabPaneFocusListener(adminUserTabsListener));
        ServiceWrapper serviceWrapper = this.theApp.getUserMgr();
        this.showProjectTab = serviceWrapper.MOFContainsProject() && !serviceWrapper.isEqualScope("nisplus");
        this.setupSolTabs(this.userObj);
    }

    private void setupSolTabs(UserObj userObj) {
        this.solGenProps = new SolGenProps(this.theApp, userObj, this.infoPanel, this.showPasswdTab);
        this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_general"), null, this.solGenProps);
        this.solGrpProps = new SolGrpProps(this.theApp, userObj, this.infoPanel);
        this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_grp"), null, this.solGrpProps);
        if (this.showProjectTab) {
            this.solProjProps = new SolProjProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_proj"), null, this.solProjProps);
        }
        this.solHdirProps = new SolHdirProps(this.theApp, userObj, this.infoPanel);
        this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_hdir"), null, this.solHdirProps);
        if (this.showPasswdTab) {
            this.solPassProps = new SolPassProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_passwd"), null, this.solPassProps);
            this.solPassOpProps = new SolPassOpProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_passwd_op"), null, this.solPassOpProps);
        }
        this.solMailProps = new SolMailProps(this.theApp, userObj, this.infoPanel);
        this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_mail"), null, this.solMailProps);
        if (this.theApp.getUserMgr().hasProfMgrAssignAuth() || this.theApp.getUserMgr().hasProfMgrDelegateAuth()) {
            this.rightsProps = new RightsProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_rights"), null, this.rightsProps);
        }
        if (this.theApp.getUserMgr().hasRoleMgrAssignAuth() || this.theApp.getUserMgr().hasRoleMgrDelegateAuth()) {
            this.solRoleProps = new SolRoleProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_roles"), null, this.solRoleProps);
        }
    }

    public boolean isUpdatePropsOK(UserObj userObj) {
        ServiceWrapper serviceWrapper = this.theApp.getUserMgr();
        UserObj userObj2 = userObj;
        UserObj userObj3 = (UserObj)userObj.clone();
        boolean bl = false;
        if (this.isGenVisited) {
            if (this.solGenProps.isUserNameSyntaxOK() && this.solGenProps.isDescriptionSyntaxOK() && this.solGenProps.isShellSyntaxOK() && this.solGenProps.isExpireDateSyntaxOK()) {
                bl = true;
                userObj3 = this.solGenProps.updateGenProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isGrpVisited) {
            if (this.solGrpProps.checkNumberSecondaryGroups()) {
                bl = true;
                userObj3 = this.solGrpProps.updateGrpProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isPassVisited) {
            if (this.solPassProps.isPasswdSyntaxOK()) {
                bl = true;
                userObj3 = this.solPassProps.updateSolPassProps(userObj3);
                if (!this.solPassProps.getPasswordGood()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.isPassOpVisited) {
            if (this.solPassOpProps.isPasswdSyntaxOK()) {
                bl = true;
                userObj3 = this.solPassOpProps.updateSolPassOpProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isHdirVisited) {
            if (this.solHdirProps.isHdirSyntaxOK()) {
                bl = true;
                userObj3 = this.solHdirProps.updateSolHdirProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isMailVisited) {
            if (this.solMailProps.isMailSyntaxOK()) {
                bl = true;
                userObj3 = this.solMailProps.updateSolMailProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isRightsVisited) {
            bl = true;
            userObj3 = this.rightsProps.updateRightsProps(userObj3);
        }
        if (this.isRoleVisited) {
            bl = true;
            userObj3 = this.solRoleProps.updateSolRoleProps(userObj3);
        }
        if (this.showProjectTab && (this.isProjVisited || this.isGenVisited)) {
            bl = true;
            userObj3 = this.solProjProps.updateProjProps(userObj3);
        }
        if (bl) {
            block41: {
                boolean bl2 = false;
                String string = userObj2.getUserName();
                String string2 = userObj3.getUserName();
                String string3 = userObj2.getUserDescription();
                String string4 = userObj3.getUserDescription();
                if (!string.equals(string2) || !string3.equals(string4)) {
                    bl2 = true;
                }
                try {
                    if (userObj3.requireModify() || !userObj3.equals(userObj2)) {
                        UserObj userObj4 = serviceWrapper.modifyUser(userObj3, userObj2);
                        if (bl2) {
                            Content content = this.theApp.getTree().getCurrentContent();
                            VScopeNode vScopeNode = content.getTreeNode();
                            Vector vector = content.getSelected();
                            VScopeNode vScopeNode2 = (VScopeNode)vector.elementAt(0);
                            vScopeNode2.setText(string2);
                            vScopeNode2.setDescription(string4);
                            vScopeNode2.setColumnValues(UserContent.getColumnValues(this.bundle, userObj3));
                            vScopeNode2.setPayload((Object)userObj4);
                            this.updateResultsView(content);
                        }
                        if (!string.equals(string2)) {
                            UserPoliciesDlg.renameUserPolicyKey(string, string2);
                        }
                    }
                }
                catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                    Object object;
                    PartialSuccessObject partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
                    if (partialSuccessObject != null) {
                        if (partialSuccessObject.getHomedirFailed()) {
                            object = partialSuccessObject.getHomedirException();
                            if (object != null) {
                                new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), ((Throwable)object).getLocalizedMessage(), true);
                            }
                        } else if (partialSuccessObject.getMailboxFailed()) {
                            object = partialSuccessObject.getMailboxException();
                            if (object != null) {
                                new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), ((Throwable)object).getLocalizedMessage(), true);
                            }
                        } else {
                            object = solServerPartialSuccessException.getLocalizedMessage();
                            if (object != null && !((String)object).equals("")) {
                                new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), (String)object, true);
                            }
                        }
                    }
                    if (!userObj2.getUserName().equals(userObj3.getUserName())) {
                        object = this.theApp.getTree().getCurrentContent();
                        Vector vector = ((Content)object).getSelected();
                        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                        vScopeNode.setText(string2);
                        vScopeNode.setDescription(string4);
                        vScopeNode.setColumnValues(UserContent.getColumnValues(this.bundle, userObj3));
                        vScopeNode.setPayload((Object)userObj3);
                        this.updateResultsView((Content)object);
                        if (!string.equals(string2)) {
                            UserPoliciesDlg.renameUserPolicyKey(string, string2);
                        }
                    }
                }
                catch (UserMgrNameAlreadyInUseException userMgrNameAlreadyInUseException) {
                    new ErrorDialog(this.theApp.getFrame(), userMgrNameAlreadyInUseException.getLocalizedMessage());
                    return false;
                }
                catch (Exception exception) {
                    String string5 = exception.getLocalizedMessage();
                    if (string5 == null || string5.equals("")) break block41;
                    new ErrorDialog(this.theApp.getFrame(), string5);
                }
            }
            return true;
        }
        return false;
    }

    private void updateResultsView(Content content) {
        final VScopeNode vScopeNode = content.getTreeNode();
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)AdminUserTabs.this.theApp, "vconsole.updatescope", (Object)vScopeNode);
                        AdminUserTabs.this.theApp.fireConsoleAction(vConsoleEvent);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)vScopeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
    }

    class TabPaneFocusListener
    implements FocusListener {
        AdminUserTabsListener cl;

        public TabPaneFocusListener(AdminUserTabsListener adminUserTabsListener) {
            this.cl = adminUserTabsListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.cl.stateChanged(new ChangeEvent(focusEvent.getComponent()));
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class AdminUserTabsListener
    implements ChangeListener {
        AdminUserTabsListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            FocusListener focusListener;
            try {
                if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solGenProps) {
                    AdminUserTabs.this.solGenProps.requestFocus();
                    AdminUserTabs.this.isGenVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solPassProps) {
                    AdminUserTabs.this.solPassProps.requestFocus();
                    AdminUserTabs.this.isPassVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solPassOpProps) {
                    AdminUserTabs.this.solPassOpProps.requestFocus();
                    AdminUserTabs.this.isPassOpVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solGrpProps) {
                    AdminUserTabs.this.solGrpProps.requestFocus();
                    AdminUserTabs.this.isGrpVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solHdirProps) {
                    AdminUserTabs.this.solHdirProps.requestFocus();
                    AdminUserTabs.this.isHdirVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solMailProps) {
                    AdminUserTabs.this.solMailProps.requestFocus();
                    AdminUserTabs.this.isMailVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.rightsProps) {
                    AdminUserTabs.this.rightsProps.requestFocus();
                    AdminUserTabs.this.isRightsVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solRoleProps) {
                    AdminUserTabs.this.solRoleProps.requestFocus();
                    AdminUserTabs.this.isRoleVisited = true;
                } else if (AdminUserTabs.this.getSelectedComponent() == AdminUserTabs.this.solProjProps) {
                    AdminUserTabs.this.solProjProps.requestFocus();
                    AdminUserTabs.this.isProjVisited = true;
                }
            }
            catch (Exception exception) {
                new ErrorDialog(AdminUserTabs.this.theApp.getFrame(), exception.getLocalizedMessage());
            }
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            UMgrPropsPanel uMgrPropsPanel = (UMgrPropsPanel)jTabbedPane.getSelectedComponent();
            if (uMgrPropsPanel != null && (focusListener = uMgrPropsPanel.getFocusListener()) != null) {
                focusListener.focusGained(new FocusEvent(jTabbedPane, 1004));
            }
        }
    }
}

