/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.MemberSelectorPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WholeNumField;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class RoleGrpProps
extends UMgrPropsPanel {
    private JComboBox primaryCombo;
    private MemberSelectorPanel memberPanel;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private GenInfoPanel infoPanel;
    private ActionString actionString;
    private boolean offerGroups;
    private WholeNumField gidField;

    public RoleGrpProps(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.infoPanel = genInfoPanel;
        this.initGui(userObj);
        this.loadHelp();
    }

    private void initGui(UserObj userObj) {
        Vector vector = this.theApp.getAllGroupsCache();
        if (vector == null) {
            try {
                vector = this.theApp.getUserMgr().getAllGroups();
                this.theApp.setAllGroupsCache(vector);
                this.offerGroups = true;
            }
            catch (AdminException adminException) {
                this.offerGroups = false;
            }
        }
        if (vector == null || vector.isEmpty()) {
            this.offerGroups = false;
            this.createGuiWithoutGroups(userObj);
        } else {
            this.offerGroups = true;
            this.createGuiWithGroups(userObj, vector);
        }
    }

    private void createGuiWithoutGroups(UserObj userObj) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_groups_no_groups"));
        JLabel jLabel = new JLabel();
        this.actionString = new ActionString(this.bundle, "au_wiz_user_group");
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        String string = null;
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (solGroupAttr != null && solGroupAttr.getPrimaryGroup() != null) {
            string = solGroupAttr.getPrimaryGroup();
        }
        int n = 14;
        if (string != null || !string.equals("")) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 14;
            }
        }
        this.gidField = new WholeNumField(n, 11, Integer.MAX_VALUE, true);
        Constraints.constrain((Container)this, (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)this, (Component)this.gidField, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)12, (int)16, (int)0, (int)0);
    }

    private void createGuiWithGroups(UserObj userObj, Vector vector) {
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        this.actionString = new ActionString(this.bundle, "au_wiz_user_group");
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Object[] objectArray = new String[vector.size()];
        int n = 0;
        while (n < objectArray.length) {
            GroupObj groupObj = (GroupObj)vector.elementAt(n);
            objectArray[n] = new String(groupObj.getGroupName());
            ++n;
        }
        Sort.sort((String[])objectArray);
        this.primaryCombo = new JComboBox<String>(objectArray);
        String string = "sysadmin";
        if (solGroupAttr != null && solGroupAttr.getPrimaryGroup() != null) {
            string = solGroupAttr.getPrimaryGroup();
        }
        this.primaryCombo.setSelectedItem(string);
        jLabel.setLabelFor(this.primaryCombo);
        Constraints.constrain((Container)this, (Component)this.primaryCombo, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Vector vector2 = AdminCommonTools.CMN_ArrayToVector((Object[])objectArray);
        int n2 = 0;
        if (solGroupAttr != null) {
            n2 = solGroupAttr.getNumberSecondaryGroups();
        }
        AdminCommonTools.CMN_Trace3((String)("NUMBER OF SECONDARY GROUPS" + n2));
        Vector<String> vector3 = new Vector<String>(n2);
        String[] stringArray = new String[n2];
        if (solGroupAttr != null) {
            if (solGroupAttr.getSecondaryGroups() != null) {
                stringArray = solGroupAttr.getSecondaryGroups();
            }
        } else {
            stringArray[0] = "";
            n2 = 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            vector3.insertElementAt(stringArray[n3], n3);
            if (vector2.contains(stringArray[n3])) {
                vector2.removeElement(stringArray[n3]);
            }
            ++n3;
        }
        ActionString actionString = new ActionString(this.bundle, "sol_grp_props_availGr");
        ActionString actionString2 = new ActionString(this.bundle, "sol_grp_props_memberOf");
        ActionString actionString3 = new ActionString(this.bundle, "mu_wiz_usernames_btn2");
        ActionString actionString4 = new ActionString(this.bundle, "sol_grp_props_remove");
        this.memberPanel = new MemberSelectorPanel(vector2, vector3, false);
        this.memberPanel.setLabels(actionString, actionString2, actionString3, actionString4);
        Constraints.constrain((Container)this, (Component)this.memberPanel, (int)0, (int)1, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)1.0, (int)12, (int)12, (int)0, (int)0);
    }

    public boolean checkNumberSecondaryGroups() {
        if (!this.offerGroups) {
            return true;
        }
        Vector vector = this.memberPanel.getOutItems();
        if (vector.size() > SolGroupAttr.getMaximumGroupNumber()) {
            String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_grp_props_er_too_many_secondary_groups");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
            return false;
        }
        return true;
    }

    public UserObj updateGrpProps(UserObj userObj) {
        String string = null;
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (solGroupAttr == null) {
            solGroupAttr = new SolGroupAttr();
        }
        if (!this.offerGroups) {
            int n = this.gidField.getValue();
            string = String.valueOf(n);
            solGroupAttr.setPrimaryGroup(string);
            userObj.setSolGroupAttr(solGroupAttr);
            return userObj;
        }
        string = (String)this.primaryCombo.getSelectedItem();
        Vector vector = this.memberPanel.getOutItems();
        int n = vector.size();
        AdminCommonTools.CMN_Trace3((String)("SIZE OF THE OUT items IS:" + n));
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        int n2 = 0;
        while (n2 < n) {
            AdminCommonTools.CMN_Trace3((String)("2ndary Group:" + (String)objectArray[n2]));
            ++n2;
        }
        solGroupAttr.setPrimaryGroup(string);
        solGroupAttr.setSecondaryGroups((String[])objectArray);
        solGroupAttr.setNumberSecondaryGroups(objectArray.length);
        userObj.setSolGroupAttr(solGroupAttr);
        return userObj;
    }

    private void loadHelp() {
        Object object;
        Vector vector = null;
        if (!this.offerGroups) {
            vector = new Vector(2);
            this.focusListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "rprop_groups_no_groups");
        } else {
            vector = new Vector(4 + this.primaryCombo.getItemCount());
            this.theApp.addHelpListener(this.primaryCombo, new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "rprop_groups_prim"));
            object = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "rprop_groups_avail");
            UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "rprop_groups_memb");
            this.memberPanel.setFocusListeners((FocusListener)object, (FocusListener)((Object)uMgrContextHelpListener), null, null, null, null);
            this.focusListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "rprop_groups");
        }
        object = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((UMgrContextHelpListener)((Object)RoleGrpProps.this.getFocusListener())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        object.start();
    }
}

