/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.tests.FilePasswordCallback;

public class FipsTest {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 2) {
                System.out.println("Usage: FipsTest <dbdir> <fipsmode enter: enable OR disable OR chkfips > <password file>");
                return;
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = "";
            if (stringArray.length == 3) {
                string3 = stringArray[2];
                System.out.println("The password file " + string3);
            }
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string);
            System.out.println("output of Initilization values ");
            System.out.println("Manufacturer ID: " + initializationValues.getManufacturerID());
            System.out.println("Library: " + initializationValues.getLibraryDescription());
            System.out.println("Internal Slot: " + initializationValues.getInternalSlotDescription());
            System.out.println("Internal Token: " + initializationValues.getInternalTokenDescription());
            System.out.println("Key Storage Slot: " + initializationValues.getFIPSKeyStorageSlotDescription());
            System.out.println("Key Storage Token: " + initializationValues.getInternalKeyStorageTokenDescription());
            System.out.println("FIPS Slot: " + initializationValues.getFIPSSlotDescription());
            System.out.println("FIPS Key Storage: " + initializationValues.getFIPSKeyStorageSlotDescription());
            initializationValues.fipsMode = string2.equalsIgnoreCase("enable") ? CryptoManager.InitializationValues.FIPSMode.ENABLED : (string2.equalsIgnoreCase("disable") ? CryptoManager.InitializationValues.FIPSMode.DISABLED : CryptoManager.InitializationValues.FIPSMode.UNCHANGED);
            CryptoManager.initialize(initializationValues);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            if (cryptoManager.FIPSEnabled()) {
                System.out.println("\n\t\tFIPS enabled\n");
            } else {
                System.out.println("\n\t\tFIPS not enabled\n");
            }
            Enumeration enumeration = cryptoManager.getModules();
            System.out.println("\nListing of Modules:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((PK11Module)enumeration.nextElement()).getName());
            }
            enumeration = cryptoManager.getAllTokens();
            System.out.println("\nAll Tokens:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            enumeration = cryptoManager.getExternalTokens();
            System.out.println("\nExternal Tokens:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            String string4 = cryptoManager.FIPSEnabled() ? initializationValues.getFIPSSlotDescription() : initializationValues.getInternalKeyStorageTokenDescription();
            string4 = string4.substring(0, 32);
            string4 = string4.trim();
            System.out.println("\nFinding the Internal Key Storage token: " + string4);
            CryptoToken cryptoToken = cryptoManager.getTokenByName(string4);
            if (((PK11Token)cryptoToken).isInternalKeyStorageToken() && cryptoToken.equals(cryptoManager.getInternalKeyStorageToken())) {
                System.out.println("Good, " + cryptoToken.getName() + ", knows it is " + "the internal Key Storage Token");
            } else {
                System.out.println("ERROR: " + cryptoToken.getName() + ", doesn't know" + " it is the internal key storage token");
            }
            if (!string3.equals("")) {
                System.out.println("logging in to the Token: " + cryptoToken.getName());
                FilePasswordCallback filePasswordCallback = new FilePasswordCallback(string3);
                cryptoToken.login(filePasswordCallback);
                System.out.println("logged in to the Token: " + cryptoToken.getName());
            }
            string4 = cryptoManager.FIPSEnabled() ? initializationValues.getFIPSSlotDescription() : initializationValues.getInternalTokenDescription();
            string4 = string4.substring(0, 32);
            string4 = string4.trim();
            System.out.println("\nFinding the Internal Crypto token: " + string4);
            cryptoToken = cryptoManager.getTokenByName(string4);
            if (((PK11Token)cryptoToken).isInternalCryptoToken() && cryptoToken.equals(cryptoManager.getInternalCryptoToken())) {
                System.out.println("Good, " + cryptoToken.getName() + ", knows it is the internal Crypto token");
            } else {
                System.out.println("ERROR: " + cryptoToken.getName() + ", doesn't know that it is the internal Crypto token");
            }
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

