/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.TokenException;

public class KeyPairGenerator {
    protected KeyPairAlgorithm algorithm;
    protected KeyPairGeneratorSpi engine;

    public KeyPairGenerator(KeyPairAlgorithm keyPairAlgorithm, KeyPairGeneratorSpi keyPairGeneratorSpi) {
        this.algorithm = keyPairAlgorithm;
        this.engine = keyPairGeneratorSpi;
    }

    public KeyPair genKeyPair() throws TokenException {
        return this.engine.generateKeyPair();
    }

    public KeyPairAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.engine.initialize(algorithmParameterSpec, secureRandom);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engine.initialize(algorithmParameterSpec, null);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.engine.initialize(n, secureRandom);
    }

    public void initialize(int n) {
        this.engine.initialize(n, null);
    }

    public boolean keygenOnInternalToken() {
        return this.engine.keygenOnInternalToken();
    }

    public void temporaryPairs(boolean bl) {
        this.engine.temporaryPairs(bl);
    }

    public void sensitivePairs(boolean bl) {
        this.engine.sensitivePairs(bl);
    }

    public void extractablePairs(boolean bl) {
        this.engine.extractablePairs(bl);
    }
}

