/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal;

import opencard.core.terminal.CommandAPDU;

public class ISOCommandAPDU
extends CommandAPDU {
    int lc;
    int le;
    private int off;
    private int end;
    public static final int CASE_EXTENDED = 1;
    public static final int CASE_1 = 2;
    public static final int CASE_2S = 4;
    public static final int CASE_2E = 5;
    public static final int CASE_3S = 8;
    public static final int CASE_3E = 9;
    public static final int CASE_4S = 16;
    public static final int CASE_4E = 17;
    public static final int CLA = 0;
    public static final int INS = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;

    public ISOCommandAPDU(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, -1);
    }

    public ISOCommandAPDU(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, null, n5);
    }

    public ISOCommandAPDU(int n, int n2, int n3, int n4, byte[] byArray) {
        this(n, n2, n3, n4, byArray, -1);
    }

    public ISOCommandAPDU(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        super(ISOCommandAPDU.encode(n, n2, n3, n4, byArray, n5));
        this.lc = byArray == null ? -1 : byArray.length;
        this.le = n5;
        this.off = 0;
        this.end = 0;
    }

    public ISOCommandAPDU(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5 <= 0 ? null : new byte[n5], n6);
        if (this.lc > 0) {
            boolean bl = n5 > 255 || n6 > 256;
            this.off = bl ? 7 : 5;
            this.end = this.off + n5;
        }
    }

    public void append(byte by) throws IndexOutOfBoundsException {
        if (this.off + 1 > this.end) {
            throw new ArrayIndexOutOfBoundsException(this.end);
        }
        this.apdu_buffer[this.off++] = by;
    }

    public void append(byte[] byArray) throws IndexOutOfBoundsException {
        if (this.off + byArray.length > this.end) {
            throw new ArrayIndexOutOfBoundsException(this.end);
        }
        System.arraycopy(byArray, 0, this.apdu_buffer, this.off, byArray.length);
        this.off += byArray.length;
    }

    private static byte[] encode(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        int n6 = 4;
        int n7 = byArray == null ? 0 : byArray.length;
        int n8 = 0;
        if (n7 > 255 || n5 > 256) {
            n8 = 1;
            ++n6;
        }
        if (n7 > 0) {
            n6 += 1 + n8 + n7;
        }
        if (n5 > 0) {
            n6 += 1 + n8;
        }
        byte[] byArray2 = new byte[n6];
        byArray2[0] = (byte)n;
        byArray2[1] = (byte)n2;
        byArray2[2] = (byte)n3;
        byArray2[3] = (byte)n4;
        int n9 = 4;
        if (n8 != 0) {
            byArray2[n9++] = 0;
        }
        if (n7 > 0) {
            if (n8 != 0) {
                byArray2[n9++] = (byte)(n7 >> 8);
            }
            byArray2[n9++] = (byte)n7;
            System.arraycopy(byArray, 0, byArray2, n9, n7);
            n9 += n7;
        }
        if (n5 > 0) {
            if (n8 != 0) {
                byArray2[n9++] = (byte)(n5 >> 8);
            }
            byArray2[n9++] = (byte)n5;
        }
        return byArray2;
    }

    public int getLC() {
        return this.lc;
    }

    public int getLE() {
        return this.le;
    }

    public int getIsoCase() {
        int n = 0;
        if (this.lc > 255 || this.le > 256) {
            n |= 1;
        }
        n = this.lc > 0 && this.le > 0 ? (n |= 0x10) : (this.lc > 0 ? (n |= 8) : (this.le > 0 ? (n |= 4) : (n |= 2)));
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("APDU_Buffer = ");
        stringBuffer.append(this.makeHex(this.getBytes()));
        stringBuffer.append(" (hex) | lc = ");
        stringBuffer.append(this.lc);
        stringBuffer.append(" | le = ");
        stringBuffer.append(this.le);
        return stringBuffer.toString();
    }

    private String makeHex(byte[] byArray) {
        int n = byArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 0;
        while (n2 < 2 * n) {
            byte by = n2 % 2 == 1 ? (byte)(byArray[n2 / 2] & 0xF) : (byte)(byArray[n2 / 2] >> 4 & 0xF);
            stringBuffer.append((char)(by < 10 ? by + 48 : by + 55) + (n2 % 2 == 1 ? string : ""));
            ++n2;
        }
        return stringBuffer.toString();
    }
}

