/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.InvalidSlotChannelException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public abstract class CardTerminal {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$terminal$CardTerminal == null ? (class$opencard$core$terminal$CardTerminal = CardTerminal.class$("opencard.core.terminal.CardTerminal")) : class$opencard$core$terminal$CardTerminal);
    private static Tracer ctracer = new Tracer(class$opencard$core$terminal$CardTerminal == null ? (class$opencard$core$terminal$CardTerminal = CardTerminal.class$("opencard.core.terminal.CardTerminal")) : class$opencard$core$terminal$CardTerminal);
    private Vector channels = new Vector();
    protected Vector slots = new Vector();
    protected Hashtable ctListeners = new Hashtable();
    protected final String name;
    protected final String type;
    protected final String address;
    private Object ctListenerMonitor = new String("ctListenerMonitor");
    static /* synthetic */ Class class$opencard$core$terminal$CardTerminal;

    protected CardTerminal(String string, String string2, String string3) {
        ctracer.debug("<init>", "(" + string + ", " + string2 + ", " + string3 + ")");
        this.name = string;
        this.type = string2;
        this.address = string3;
    }

    public void addCTListener(CTListener cTListener) {
        this.itracer.debug("addCTListener", "adding " + cTListener);
        this.ctListeners.put(cTListener, cTListener);
    }

    public Enumeration enumerateSlots() {
        return this.slots.elements();
    }

    public final Properties features() {
        Properties properties = new Properties();
        this.internalFeatures(properties);
        if (properties == null) {
            this.itracer.debug("features ", "implementation error in terminal class -> got 'null' instead of Enumeration object");
            properties = new Properties();
        }
        properties.put("name", this.getName());
        properties.put("type", this.getType());
        properties.put("address", this.getAddress());
        properties.put("slots", String.valueOf(this.slots.size()));
        return properties;
    }

    public String getAddress() {
        return this.address;
    }

    public abstract CardID getCardID(int var1) throws CardTerminalException;

    public abstract CardID getCardID(int var1, int var2) throws CardTerminalException;

    public String getName() {
        return this.name;
    }

    public Slot getSlot(int n) throws IndexOutOfBoundsException {
        if (n >= this.slots.size()) {
            throw new IndexOutOfBoundsException("slotID too large");
        }
        return (Slot)this.slots.elementAt(n);
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot[] slots() {
        Vector vector = this.slots;
        synchronized (vector) {
            Object[] objectArray = new Slot[this.slots.size()];
            this.slots.copyInto(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    public abstract boolean isCardPresent(int var1) throws CardTerminalException;

    public boolean isCardPresent(Slot slot) throws CardTerminalException {
        return this.isCardPresent(slot.getSlotID());
    }

    public synchronized boolean isSlotChannelAvailable(int n) {
        return this.getSlotChannel(n) == null;
    }

    public synchronized boolean isSlotChannelAvailable(Slot slot) {
        return this.isSlotChannelAvailable(slot.getSlotID());
    }

    public abstract void open() throws CardTerminalException;

    public abstract void close() throws CardTerminalException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SlotChannel openSlotChannel(int n) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        this.itracer.debug("openSlotChannel", "for slot #" + n);
        this.internalOpenSlotChannel(n);
        if (n >= this.slots.size()) {
            throw new IndexOutOfBoundsException("slot id out of bounds");
        }
        SlotChannel slotChannel = null;
        Vector vector = this.channels;
        synchronized (vector) {
            if (!this.isSlotChannelAvailable(n)) {
                throw new InvalidSlotChannelException("slot channel already allocated", this);
            }
            slotChannel = new SlotChannel(this, n);
            this.channels.addElement(slotChannel);
        }
        this.itracer.debug("openSlotChannel", "new SlotChannel is " + slotChannel);
        return slotChannel;
    }

    public final synchronized SlotChannel openSlotChannel(Slot slot) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        return this.openSlotChannel(slot.getSlotID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeSlotChannel(SlotChannel slotChannel) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        Vector vector = this.channels;
        synchronized (vector) {
            this.channels.removeElement(slotChannel);
        }
        this.internalCloseSlotChannel(slotChannel);
    }

    public void removeCTListener(CTListener cTListener) {
        this.itracer.debug("removeCTListener", "removing " + cTListener);
        this.ctListeners.remove(cTListener);
    }

    public final CardID reset(SlotChannel slotChannel, int n) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        return this.internalReset(slotChannel.getSlotNumber(), n);
    }

    public final ResponseAPDU sendAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU, int n) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        return this.internalSendAPDU(slotChannel.getSlotNumber(), commandAPDU, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("\n");
        stringBuffer.append("+ name    ").append(this.name).append("\n");
        stringBuffer.append("+ type    ").append(this.type).append("\n");
        stringBuffer.append("+ addr    ").append(this.address);
        return stringBuffer.toString();
    }

    public String getFilterKey() {
        return ":0";
    }

    public boolean isClientAuthorized(long l) {
        if (l == 0L) {
            return true;
        }
        long l2 = this.getFileOwnerUID("/dev/console");
        return l == l2;
    }

    private native long getFileOwnerUID(String var1);

    protected void addSlots(int n) throws CardTerminalException {
        int n2 = 0;
        while (n2 < n) {
            this.slots.addElement(new Slot(this, n2));
            ++n2;
        }
        this.slots.trimToSize();
    }

    protected void cardRemoved(int n) {
        this.itracer.debug("cardRemoved", "slotID " + n);
        CardTerminalRegistry.getRegistry().cardRemoved(this, n);
        if (!this.ctListeners.isEmpty()) {
            CTListener cTListener = null;
            Slot slot = this.getSlot(n);
            Enumeration enumeration = this.ctListeners.elements();
            while (enumeration.hasMoreElements()) {
                cTListener = (CTListener)enumeration.nextElement();
                try {
                    cTListener.cardRemoved(new CardTerminalEvent((Object)this, 2, slot));
                }
                catch (RuntimeException runtimeException) {
                    this.itracer.critical("cardRemoved", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    this.itracer.critical("cardRemoved", cardTerminalException);
                }
            }
            this.itracer.debug("cardRemoved", "notifying CTListeners");
        }
    }

    protected void cardInserted(int n) {
        this.itracer.debug("cardInserted", "slotID " + n + ", " + ")");
        CardTerminalRegistry.getRegistry().cardInserted(this, n);
        if (!this.ctListeners.isEmpty()) {
            CTListener cTListener = null;
            Slot slot = this.getSlot(n);
            Enumeration enumeration = this.ctListeners.elements();
            while (enumeration.hasMoreElements()) {
                cTListener = (CTListener)enumeration.nextElement();
                try {
                    cTListener.cardInserted(new CardTerminalEvent((Object)this, 1, slot));
                }
                catch (RuntimeException runtimeException) {
                    this.itracer.critical("cardInserted", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    this.itracer.critical("cardInserted", cardTerminalException);
                }
            }
            this.itracer.debug("cardInserted", "notified CTListeners");
        }
    }

    protected abstract Properties internalFeatures(Properties var1);

    protected void internalOpenSlotChannel(int n) throws CardTerminalException {
    }

    protected void internalCloseSlotChannel(SlotChannel slotChannel) throws CardTerminalException {
    }

    protected abstract CardID internalReset(int var1, int var2) throws CardTerminalException;

    protected abstract ResponseAPDU internalSendAPDU(int var1, CommandAPDU var2, int var3) throws CardTerminalException;

    private void assertSlotChannelValid(SlotChannel slotChannel) throws InvalidSlotChannelException {
        if (this.getSlotChannel(slotChannel.getSlotNumber()) != slotChannel) {
            throw new InvalidSlotChannelException("illegal SlotChannel", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SlotChannel getSlotChannel(int n) {
        Vector vector = this.channels;
        synchronized (vector) {
            Enumeration enumeration = this.channels.elements();
            while (enumeration.hasMoreElements()) {
                SlotChannel slotChannel = (SlotChannel)enumeration.nextElement();
                if (slotChannel.getSlotNumber() != n) continue;
                return slotChannel;
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.loadLibrary("smartcard");
    }
}

