/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.ClosableObject;
import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.ObjectCloseListener;
import com.sun.opencard.common.ThreadInterrupter;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.service.common.INT_CardService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Slot;

public class OCFCardHandle
implements Serializable {
    private static final long NOUID = -1L;
    private final long handle;
    private final SmartCard smartCard;
    private final Slot slot;
    private CardID cardID;
    private CardServiceFactory cardServiceFactory;
    private byte[] pin = new byte[0];
    private long uid = -1L;
    private long timePinLastValidated;
    private long resetCount = 0L;
    private final Hashtable properties;
    private final Object lockNotifier;
    private final Object resetNotifier;
    private ClosableObject lockOwner = null;
    private final ObjectCloseListener lockOwnerListener;
    private boolean closed = false;

    public OCFCardHandle(long l, SmartCard smartCard, Slot slot, CardID cardID) {
        this.handle = l;
        this.smartCard = smartCard;
        this.slot = slot;
        this.cardID = cardID;
        this.properties = new Hashtable();
        this.lockNotifier = new Object();
        this.resetNotifier = new Object();
        this.lockOwnerListener = new ObjectCloseListener(){

            public void objectClosed(ClosableObject closableObject) {
                OCFCardHandle.this.unlock(closableObject);
            }
        };
    }

    void setCardServiceFactory(CardServiceFactory cardServiceFactory) {
        this.cardServiceFactory = cardServiceFactory;
    }

    public long getHandle() {
        return this.handle;
    }

    public String getCardName() {
        return this.cardServiceFactory.getName();
    }

    public byte[] getATR() {
        return this.getCardID().getATR();
    }

    public String getReaderName() {
        return this.slot.getCardTerminal().getName();
    }

    public CardID getCardID() {
        return this.cardID;
    }

    public int getSlotID() {
        return this.slot.getSlotID();
    }

    public boolean knows(String string) {
        return this.cardServiceFactory.knows(string);
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String toString() {
        return "CardHandle=" + this.handle + " CardName=" + this.getCardName() + " ReaderName=" + this.getReaderName();
    }

    public byte[] getPin() {
        return this.pin;
    }

    public void setPin(byte[] byArray) {
        this.pin = byArray;
        Date date = new Date();
        this.timePinLastValidated = date.getTime();
    }

    public boolean isAuthorizedUID(long l) {
        return this.uid == -1L || l == 0L || l == this.uid;
    }

    public void setUID(long l) {
        this.uid = l;
    }

    public long getTimeSinceLastValidation() {
        if (this.timePinLastValidated == 0L) {
            return 0L;
        }
        Date date = new Date();
        return date.getTime() - this.timePinLastValidated + 1L;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Enumeration listProperties() {
        return this.properties.keys();
    }

    public Object deleteProperty(String string) {
        if (this.properties.size() == 0) {
            return null;
        }
        return this.properties.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws CardTerminalException {
        try {
            this.cardID = this.smartCard.reset();
            Object object = this.resetNotifier;
            synchronized (object) {
                ++this.resetCount;
                this.resetNotifier.notifyAll();
            }
        }
        catch (CardTerminalException cardTerminalException) {
            this.debug("reset", cardTerminalException.getMessage());
            throw cardTerminalException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String waitForCardReset(OCFClientHandle oCFClientHandle) {
        String string = OCFConstants.OCF_SUCCESS;
        ThreadInterrupter threadInterrupter = new ThreadInterrupter();
        Object object = this.resetNotifier;
        synchronized (object) {
            long l = this.resetCount;
            if (!this.closed) {
                oCFClientHandle.addCloseListener(threadInterrupter);
                try {
                    this.resetNotifier.wait(OCFConstants.MAX_BLOCKING_TIME);
                }
                catch (InterruptedException interruptedException) {
                    return OCFConstants.OCF_INVALID_CLIENT;
                }
                oCFClientHandle.removeCloseListener(threadInterrupter);
            }
            if (l == this.resetCount) {
                string = OCFConstants.OCF_TIMEOUT;
            }
        }
        if (!this.closed) return string;
        return OCFConstants.OCF_INVALID_CARD;
    }

    public INT_CardService getCardService(String string) {
        try {
            Class<?> clazz = Class.forName("com.sun.opencard.service.common." + string);
            CardService cardService = this.smartCard.getCardService(clazz, true);
            if (cardService == null) {
                return null;
            }
            INT_CardService iNT_CardService = (INT_CardService)Class.forName("com.sun.opencard.service.common.INT_" + string).newInstance();
            iNT_CardService.setCardHandle(this);
            iNT_CardService.setCardService(cardService);
            return iNT_CardService;
        }
        catch (Exception exception) {
            OCFDebug.printStackTrace(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String lock(ClosableObject closableObject, long l) {
        this.debug("lock", "");
        long l2 = l * 1000L;
        ThreadInterrupter threadInterrupter = new ThreadInterrupter();
        Object object = this.lockNotifier;
        synchronized (object) {
            closableObject.addCloseListener(threadInterrupter);
            while (this.lockOwner != null && closableObject.isActive()) {
                if (this.lockOwner == closableObject) {
                    closableObject.removeCloseListener(threadInterrupter);
                    return OCFConstants.OCF_DOUBLELOCK;
                }
                this.debug("lock", "lock held by another object");
                if (l2 <= 0L) {
                    this.debug("lock", "timed out");
                    closableObject.removeCloseListener(threadInterrupter);
                    return OCFConstants.OCF_TIMEOUT;
                }
                this.debug("lock", "Timed wait");
                long l3 = System.currentTimeMillis();
                try {
                    this.lockNotifier.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    return OCFConstants.OCF_INVALID_CLIENT;
                }
                l2 += (l3 -= System.currentTimeMillis());
                if (!this.closed) continue;
                closableObject.removeCloseListener(threadInterrupter);
                return OCFConstants.OCF_INVALID_CARD;
            }
            closableObject.removeCloseListener(threadInterrupter);
            this.lockOwner = closableObject;
            this.lockOwner.addCloseListener(this.lockOwnerListener);
            if (this.lockOwner.isActive()) return OCFConstants.OCF_SUCCESS;
            this.lockOwner = null;
            return OCFConstants.OCF_INVALID_CLIENT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unlock(ClosableObject closableObject) {
        this.debug("unlock", "");
        Object object = this.lockNotifier;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.lockOwner != null) break block5;
                    String string = OCFConstants.OCF_SUCCESS;
                    return string;
                }
                if (closableObject == this.lockOwner) break block6;
                String string = OCFConstants.OCF_CARD_LOCKED;
                return string;
            }
            this.lockOwner = null;
            closableObject.removeCloseListener(this.lockOwnerListener);
            this.lockNotifier.notifyAll();
        }
        return OCFConstants.OCF_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessGranted(ClosableObject closableObject) {
        Object object = this.lockNotifier;
        synchronized (object) {
            boolean bl = this.lockOwner == null || this.lockOwner == closableObject;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.debug("close", "");
        try {
            this.smartCard.close();
        }
        catch (CardTerminalException cardTerminalException) {
            OCFDebug.printStackTrace(cardTerminalException);
        }
        Object object = this.lockNotifier;
        synchronized (object) {
            if (this.lockOwner != null) {
                this.lockOwner.removeCloseListener(this.lockOwnerListener);
            }
            this.closed = true;
            this.lockNotifier.notifyAll();
        }
        Object object2 = this.resetNotifier;
        synchronized (object2) {
            this.resetNotifier.notifyAll();
        }
    }

    private void debug(String string, String string2) {
        try {
            OCFDebug.debugln("OCFCardHandle::" + string + " " + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

