/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.http;

import com.sun.opencard.http.Connection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;

public class Request {
    private Connection con;
    private int requestsLeft;
    public int version;
    private DataInputStream in;
    public Properties props;
    public boolean keepAlive;
    String connectionHeader = null;
    public String method;
    public String url;
    public String query;
    public String protocol;
    public Hashtable headers;
    public byte[] postData;
    public DataOutputStream out;
    private StringBuffer extraHeaders;
    private int responseCode;
    public static final String NLT = "\r\n";
    private static final boolean[] safeHtml = new boolean[256];
    private static SimpleDateFormat dateFormat;

    Request(Connection connection, int n) {
        this.con = connection;
        this.requestsLeft = n + 1;
        this.props = new Properties(connection.server.props);
        this.headers = new Hashtable(17);
        this.keepAlive = true;
        this.responseCode = 200;
        this.extraHeaders = new StringBuffer();
        try {
            this.in = new DataInputStream(new BufferedInputStream(connection.sock.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(connection.sock.getOutputStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void Reset() {
        --this.requestsLeft;
        this.props.clear();
        this.keepAlive = false;
        this.query = "";
        this.headers.clear();
        this.postData = null;
        this.extraHeaders.setLength(0);
    }

    boolean Read() throws IOException {
        String string;
        int n;
        String string2;
        BufferedReader bufferedReader = null;
        while (true) {
            if ((string2 = (bufferedReader = new BufferedReader(new InputStreamReader(this.in))).readLine()) == null) {
                return false;
            }
            if (string2.length() != 0) break;
            this.log(4, "Skipping blank line");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n2 = stringTokenizer.countTokens();
        if (n2 != 3) {
            this.sendError(400, string2, null);
            return false;
        }
        this.method = stringTokenizer.nextToken();
        if (!this.method.equals("GET") && !this.method.equals("POST")) {
            this.sendError(501, this.method, null);
            return false;
        }
        this.url = stringTokenizer.nextToken();
        this.protocol = stringTokenizer.nextToken();
        if (this.protocol.equals("HTTP/1.0")) {
            this.version = 10;
        } else if (this.protocol.equals("HTTP/1.1")) {
            this.version = 11;
        } else {
            this.sendError(505, string2, null);
            return false;
        }
        if (!Request.extractMimeHeaders(bufferedReader, this.headers)) {
            this.log(2, "Bogus lines in mime header, ignored");
        }
        if ((n = this.url.indexOf(63)) >= 0) {
            this.query = this.url.substring(n + 1);
            this.url = this.url.substring(0, n);
        }
        if (this.requestsLeft > 0) {
            if (this.connectionHeader == null) {
                String string3 = this.connectionHeader = this.headers.containsKey("proxy-connection") ? "proxy-connection" : "connection";
            }
            if ((string = this.headers.get(this.connectionHeader)) != null && string.equals("Keep-Alive")) {
                this.keepAlive = true;
            } else if (string != null && string.equals("close")) {
                this.keepAlive = false;
            } else if (this.version > 10) {
                this.keepAlive = true;
            }
        }
        if ((string = (String)this.headers.get("content-length")) != null) {
            try {
                this.postData = new byte[Integer.parseInt(string)];
                this.in.readFully(this.postData);
            }
            catch (NumberFormatException numberFormatException) {
                this.sendError(411, null, null);
                return false;
            }
        }
        return true;
    }

    public static boolean extractMimeHeaders(BufferedReader bufferedReader, Hashtable hashtable) throws IOException {
        String string = null;
        boolean bl = true;
        while (true) {
            String string2;
            int n;
            String string3;
            if ((string3 = bufferedReader.readLine()) == null) {
                throw new EOFException();
            }
            if (string3.length() == 0) break;
            boolean bl2 = Character.isSpaceChar(string3.charAt(0));
            if (!bl2 && (n = string3.indexOf(58)) >= 0) {
                string = string3.substring(0, n).toLowerCase();
                string2 = string3.substring(n + 1).trim().replace('\t', ' ');
                String string4 = (String)hashtable.get(string);
                if (string4 == null) {
                    hashtable.put(string, string2);
                    continue;
                }
                hashtable.put(string, string4 + ",\t" + string2);
                continue;
            }
            if (bl2 && string != null) {
                string2 = (String)hashtable.get(string);
                hashtable.put(string, string2 + " " + string3.trim());
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public void log(int n, String string) {
        this.con.server.log(this.con.sock, n, string);
    }

    public void addHeader(String string) {
        this.extraHeaders.append(string).append(NLT);
    }

    public void sendResponse(String string) throws IOException {
        this.sendResponse(string, "text/html", this.responseCode);
    }

    public void sendResponse(String string, String string2) throws IOException {
        this.sendResponse(string, string2, this.responseCode);
    }

    public void sendResponse(String string, String string2, int n) throws IOException {
        this.sendHeaders(n, string2, string.length());
        this.out.writeBytes(string);
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
    }

    public void sendError(int n, String string) {
        if (this.responseCode != 200) {
            n = this.responseCode;
        }
        this.sendError(n, string, string);
    }

    public void sendError(int n, String string, String string2) {
        this.keepAlive = false;
        String string3 = this.url;
        if (string3 == null) {
            string3 = "unknown";
        }
        if (string == null) {
            string = "";
        }
        String string4 = "<html>\n<head>\n<title>Error: " + n + "</title>\n" + "<body>\nGot the error: <b>" + Request.GetCodeString(n) + "</b><br>\nwhile trying to obtain <b>" + Request.htmlEncode(string3) + "</b><br>\n" + Request.htmlEncode(string) + "\n</body>\n</html>";
        ++this.con.server.errorCount;
        this.log(3, "Error " + n + " " + Request.GetCodeString(n) + ": " + string);
        if (string2 != null) {
            this.log(3, string2);
        }
        try {
            this.sendResponse(string4, "text/html", n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendHeaders(String string, int n) throws IOException {
        this.sendHeaders(this.responseCode, string, n);
    }

    public void sendHeaders(int n, String string, int n2) throws IOException {
        if (n == 200 && n2 == 0) {
            n = 204;
        }
        this.out.writeBytes(this.protocol + " " + n + " " + Request.GetCodeString(n) + NLT);
        this.out.writeBytes("Date: " + Request.formatTime() + NLT);
        if (this.con.server.name != null) {
            this.out.writeBytes("Server: " + this.con.server.name + NLT);
        }
        this.out.writeBytes(this.getConnectionHeaders());
        if (n2 >= 0) {
            this.out.writeBytes("Content-Length: " + n2 + NLT);
        }
        this.out.writeBytes("Content-Type: " + string + NLT);
        if (this.extraHeaders.length() > 0) {
            this.out.writeBytes(this.extraHeaders.toString());
        }
        this.out.writeBytes(NLT);
    }

    public String getConnectionHeaders() throws IOException {
        String string = "";
        if (!this.keepAlive) {
            string = this.connectionHeader + ": close" + NLT;
        } else if (this.version == 10) {
            string = this.connectionHeader + ": Keep-Alive" + NLT;
        }
        return string;
    }

    public String statusLine(String string) {
        int n;
        if (string.startsWith(this.protocol + " ") || (n = string.indexOf(" ")) < 0) {
            return string;
        }
        return this.protocol + " " + string.substring(n).trim();
    }

    public void redirect(String string) throws IOException {
        this.addHeader("Location: " + string);
        String string2 = "<title>Moved</title><h1>look for <a href=" + string + ">" + string + "</h1>";
        this.sendResponse(string2, "text/html", 302);
    }

    public Socket getSocket() {
        return this.con.sock;
    }

    public Hashtable getQueryData(Hashtable hashtable) {
        String string;
        Request.extractQuery(this.query, hashtable);
        if (this.postData != null && (string = (String)this.headers.get("content-type")) != null && string.equals("application/x-www-form-urlencoded")) {
            Request.extractQuery(new String(this.postData), hashtable);
        }
        return hashtable;
    }

    public Hashtable getQueryData() {
        return this.getQueryData(new Hashtable());
    }

    public static Hashtable extractQuery(String string) {
        return Request.extractQuery(string, new Hashtable());
    }

    public static Hashtable extractQuery(String string, Hashtable hashtable) {
        string = string.replace('+', ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n < 0) {
                hashtable.put(Request.urlDecode(string2), "");
                continue;
            }
            hashtable.put(Request.urlDecode(string2.substring(0, n)), Request.urlDecode(string2.substring(n + 1)));
        }
        return hashtable;
    }

    public static String urlDecode(String string) {
        int n = string.indexOf(37);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '%') {
                try {
                    c = (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
                    n += 2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String htmlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (safeHtml[c]) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("&#" + c + ";");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String formatTime() {
        return Request.formatTime(System.currentTimeMillis());
    }

    public static String formatTime(long l) {
        return dateFormat.format(new Date(l)).substring(0, 29);
    }

    static String GetCodeString(int n) {
        switch (n) {
            case 200: {
                return "OK";
            }
            case 204: {
                return "No Content";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 404: {
                return "Not Found";
            }
            case 411: {
                return "Length Required";
            }
            case 500: {
                return "Internal Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "Version Not Supported";
            }
        }
        return "Error";
    }

    static {
        int n = 32;
        while (n < 126) {
            Request.safeHtml[n] = true;
            ++n;
        }
        Request.safeHtml[34] = false;
        Request.safeHtml[38] = false;
        Request.safeHtml[60] = false;
        Request.safeHtml[62] = false;
        dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

