/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.common;

import com.sun.opencard.common.EventDispatcher;
import com.sun.opencard.common.EventListener;
import com.sun.opencard.common.ObjectCloseListener;
import java.util.HashMap;

public abstract class ClosableObject {
    private EventDispatcher eventDispatcher;
    private HashMap listeners;
    private boolean isActive;

    protected ClosableObject(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        this.listeners = new HashMap();
        this.isActive = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseListener(final ObjectCloseListener objectCloseListener) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            if (!this.isActive) {
                return;
            }
            this.listeners.put(objectCloseListener, new EventListener(){

                public void dispatchEvent(Object object) {
                    objectCloseListener.objectClosed((ClosableObject)object);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCloseListener(ObjectCloseListener objectCloseListener) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.listeners.remove(objectCloseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.isActive = false;
            this.eventDispatcher.enqueueEvent(this, ((HashMap)this.listeners.clone()).values());
        }
    }
}

