/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.Parse;
import com.sun.wbem.repository.PSRlogImpl;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMQualifierTypeException;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMSemanticException;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;

public class CIMOMUtils {
    private static int uniqueInt = 0;
    PSRlogImpl ps;

    CIMOMUtils(PSRlogImpl pSRlogImpl) {
        this.ps = pSRlogImpl;
    }

    PSRlogImpl getPS() {
        return this.ps;
    }

    private Object intTypeConvert(int n, Object object) {
        String string;
        if (object == null) {
            return null;
        }
        Number number = null;
        if (object instanceof String) {
            string = (String)object;
            switch (n) {
                case 13: {
                    throw new IllegalArgumentException();
                }
                case 12: {
                    return new CIMDateTime(string);
                }
                case 9: {
                    throw new IllegalArgumentException();
                }
                case 28: {
                    Parse parse = new Parse();
                    return parse.parseOp(string);
                }
            }
            number = new BigDecimal(string);
        }
        if (n == 12 || n == 9) {
            throw new IllegalArgumentException();
        }
        if (number == null) {
            number = (Number)object;
        }
        switch (n) {
            case 0: {
                return new UnsignedInt8(number.shortValue());
            }
            case 1: {
                return new Byte(number.byteValue());
            }
            case 2: {
                return new UnsignedInt16(number.intValue());
            }
            case 3: {
                return new Short(number.shortValue());
            }
            case 4: {
                return new UnsignedInt32(number.longValue());
            }
            case 5: {
                return new Integer(number.intValue());
            }
            case 6: {
                string = number.toString();
                int n2 = string.indexOf(".");
                if (n2 == 0) {
                    string = "0";
                }
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                if (string.charAt(0) == '-') {
                    string = string.substring(1);
                }
                return new UnsignedInt64(string);
            }
            case 7: {
                return new Long(number.longValue());
            }
            case 10: {
                return new Float(number.floatValue());
            }
            case 11: {
                return new Double(number.doubleValue());
            }
            case 13: {
                return new Character((char)number.intValue());
            }
        }
        throw new IllegalArgumentException();
    }

    CIMValue typeConvert(CIMDataType cIMDataType, CIMValue cIMValue) {
        if (cIMValue == null || cIMDataType == null) {
            return cIMValue;
        }
        Object object = cIMValue.getValue();
        int n = CIMDataType.findType((Object)object);
        if (n == 30) {
            if (object instanceof Vector && !cIMDataType.isArrayType()) {
                throw new IllegalArgumentException(cIMValue.toString());
            }
            return cIMValue;
        }
        int n2 = cIMDataType.getType();
        if (n == n2) {
            return cIMValue;
        }
        if (cIMDataType.isArrayType() != cIMValue.getType().isArrayType()) {
            throw new IllegalArgumentException(cIMValue.toString());
        }
        if (cIMDataType.getType() == cIMValue.getType().getType()) {
            return cIMValue;
        }
        if (object instanceof Vector) {
            n2 = CIMDataType.findSimpleType((int)n2);
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(this.intTypeConvert(n2, enumeration.nextElement()));
            }
            return new CIMValue(vector, cIMDataType);
        }
        return new CIMValue(this.intTypeConvert(n2, object));
    }

    void checkQualifier(String string, CIMQualifier cIMQualifier) throws CIMException {
        CIMQualifierType cIMQualifierType = this.ps.getQualifierType(string.toLowerCase(), cIMQualifier.getName().toLowerCase());
        if (cIMQualifierType == null) {
            throw new CIMSemanticException("NO_SUCH_QUALIFIER1", (Object)cIMQualifier.getName());
        }
        CIMDataType cIMDataType = cIMQualifierType.getType();
        if (!cIMQualifier.hasValue() && cIMDataType.equals((Object)CIMDataType.getPredefinedType((int)9))) {
            cIMQualifier.setValue(CIMValue.TRUE);
            cIMQualifier.setDefaults(cIMQualifierType);
        } else {
            cIMQualifier.setDefaults(cIMQualifierType);
        }
    }

    CIMQualifier createDefaultQualifier(String string, String string2) throws CIMException {
        CIMQualifierType cIMQualifierType = this.ps.getQualifierType(string.toLowerCase(), string2.toLowerCase());
        if (cIMQualifierType == null) {
            throw new CIMSemanticException("NO_SUCH_QUALIFIER1", (Object)string2);
        }
        return new CIMQualifier(string2, cIMQualifierType);
    }

    public static synchronized String getUniqueString() {
        Calendar calendar = Calendar.getInstance();
        return new String(calendar.get(1) + ":" + calendar.get(2) + ":" + calendar.get(5) + ":" + calendar.get(10) + ":" + calendar.get(9) + ":" + calendar.get(12) + ":" + calendar.get(13) + ":" + ++uniqueInt);
    }

    void doCommonQualifierChecks(String string, String string2, Vector vector, CIMScope cIMScope) throws CIMException {
        if (vector == null) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = string.toLowerCase();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMQualifier cIMQualifier = (CIMQualifier)enumeration.nextElement();
            String string4 = cIMQualifier.getName().toLowerCase();
            if (hashtable.get(string4) != null) {
                throw new CIMSemanticException("CIM_ERR_INVALID_PARAMETER", (Object)cIMQualifier);
            }
            hashtable.put(string4, string4);
            CIMQualifierType cIMQualifierType = this.ps.getQualifierType(string3, string4);
            if (cIMQualifierType == null) {
                throw new CIMSemanticException("NO_SUCH_QUALIFIER2", (Object)string2, (Object)cIMQualifier.getName());
            }
            CIMDataType cIMDataType = cIMQualifierType.getType();
            if (!cIMQualifier.hasValue() && cIMDataType.equals((Object)CIMDataType.getPredefinedType((int)9))) {
                cIMQualifier.setValue(CIMValue.TRUE);
                cIMQualifier.setDefaults(cIMQualifierType);
            } else {
                try {
                    cIMQualifier.setValue(this.typeConvert(cIMQualifierType.getType(), cIMQualifier.getValue()));
                }
                catch (Exception exception) {
                    throw new CIMQualifierTypeException("TYPE_ERROR", new Object[]{cIMQualifierType.getName(), "", cIMQualifierType.getType(), cIMQualifier.getValue().getType(), cIMQualifier.getValue()});
                }
                cIMQualifier.setDefaults(cIMQualifierType);
            }
            this.assignQualifierDefaultFlavor(cIMQualifier);
            if (cIMQualifierType.hasScope(cIMScope)) continue;
            if (cIMScope.equals((Object)CIMScope.getScope((int)1)) || cIMScope.equals((Object)CIMScope.getScope((int)2))) {
                throw new CIMClassException("SCOPE_ERROR", (Object)string2, (Object)cIMQualifier.getName(), (Object)cIMScope);
            }
            if (cIMScope.equals((Object)CIMScope.getScope((int)4)) || cIMScope.equals((Object)CIMScope.getScope((int)5))) {
                throw new CIMPropertyException("SCOPE_ERROR", (Object)string2, (Object)cIMQualifier.getName(), (Object)cIMScope);
            }
            if (cIMScope.equals((Object)CIMScope.getScope((int)6)) || cIMScope.equals((Object)CIMScope.getScope((int)7))) {
                throw new CIMMethodException("SCOPE_ERROR", (Object)string2, (Object)cIMQualifier.getName(), (Object)cIMScope);
            }
            throw new CIMSemanticException("SCOPE_ERROR", (Object)string2, (Object)cIMQualifier.getName(), (Object)cIMScope);
        }
    }

    void assignInheritedQualifiers(Vector vector, Vector vector2) {
        if (vector2 != null) {
            if (vector == null) {
                vector = new Vector<Object>();
            }
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                CIMQualifier cIMQualifier = (CIMQualifier)enumeration.nextElement();
                if (!cIMQualifier.hasFlavor(CIMFlavor.getFlavor((int)3))) continue;
                if (vector.contains(new CIMQualifier(cIMQualifier.getName()))) {
                    if (cIMQualifier.hasFlavor(CIMFlavor.getFlavor((int)0))) continue;
                    vector.removeElement(new CIMQualifier(cIMQualifier.getName()));
                    vector.addElement(cIMQualifier.clone());
                    continue;
                }
                vector.addElement(cIMQualifier.clone());
            }
        }
    }

    private void assignQualifierDefaultFlavor(CIMQualifier cIMQualifier) {
        if (cIMQualifier == null) {
            return;
        }
        if (!(cIMQualifier.hasFlavor(new CIMFlavor(0)) || cIMQualifier.hasFlavor(new CIMFlavor(1)) || cIMQualifier.hasFlavor(new CIMFlavor(2)))) {
            cIMQualifier.addFlavor(new CIMFlavor(0));
        }
        if (!cIMQualifier.hasFlavor(new CIMFlavor(3)) && !cIMQualifier.hasFlavor(new CIMFlavor(2))) {
            cIMQualifier.addFlavor(new CIMFlavor(3));
        }
    }

    private Vector getLocalProps(Vector vector, String string) {
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getOriginClass().equalsIgnoreCase(string)) continue;
            vector2.addElement(cIMProperty);
        }
        return vector2;
    }

    private Vector getLocalMethods(Vector vector, String string) {
        Vector<CIMMethod> vector2 = new Vector<CIMMethod>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMMethod cIMMethod = (CIMMethod)enumeration.nextElement();
            if (!cIMMethod.getOriginClass().equalsIgnoreCase(string)) continue;
            vector2.addElement(cIMMethod);
        }
        return vector2;
    }

    CIMInstance getLocal(CIMInstance cIMInstance) {
        if (cIMInstance == null) {
            return null;
        }
        cIMInstance.setProperties(this.getLocalProps(cIMInstance.getProperties(), cIMInstance.getClassName()));
        return cIMInstance;
    }

    CIMClass getLocal(CIMClass cIMClass) {
        if (cIMClass == null) {
            return null;
        }
        cIMClass.setProperties(this.getLocalProps(cIMClass.getProperties(), cIMClass.getName()));
        cIMClass.setMethods(this.getLocalMethods(cIMClass.getMethods(), cIMClass.getName()));
        return cIMClass;
    }
}

