/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;

public class ChunkedOutputFilter
implements OutputFilter {
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING;
    protected static final ByteChunk END_CHUNK;
    protected OutputBuffer buffer;
    protected byte[] chunkLength = new byte[10];
    protected ByteChunk chunkHeader = new ByteChunk();

    public ChunkedOutputFilter() {
        this.chunkLength = new byte[10];
        this.chunkLength[8] = 13;
        this.chunkLength[9] = 10;
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        int result = chunk.getLength();
        if (result <= 0) {
            return 0;
        }
        int pos = 7;
        int current = result;
        while (current > 0) {
            int digit = current % 16;
            current /= 16;
            this.chunkLength[pos--] = HexUtils.HEX[digit];
        }
        this.chunkHeader.setBytes(this.chunkLength, pos + 1, 9 - pos);
        this.buffer.doWrite(this.chunkHeader, res);
        this.buffer.doWrite(chunk, res);
        this.chunkHeader.setBytes(this.chunkLength, 8, 2);
        this.buffer.doWrite(this.chunkHeader, res);
        return result;
    }

    public void setResponse(Response response) {
    }

    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    public long end() throws IOException {
        this.buffer.doWrite(END_CHUNK, null);
        return 0L;
    }

    public void recycle() {
    }

    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING_NAME = ENCODING_NAME;
        ENCODING = new ByteChunk();
        END_CHUNK = new ByteChunk();
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
        String endChunkValue = "0\r\n\r\n";
        END_CHUNK.setBytes(endChunkValue.getBytes(), 0, endChunkValue.length());
    }
}

