/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.SSLSupport;

public class Http11Processor
implements Processor,
ActionHook {
    protected Adapter adapter = null;
    protected Request request = new Request();
    protected Response response = null;
    protected InternalInputBuffer inputBuffer = new InternalInputBuffer(this.request);
    protected InternalOutputBuffer outputBuffer = null;
    protected boolean started = false;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected String[] restrictedUserAgents = null;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$coyote$http11$Http11Processor == null ? (class$org$apache$coyote$http11$Http11Processor = Http11Processor.class$("org.apache.coyote.http11.Http11Processor")) : class$org$apache$coyote$http11$Http11Processor));
    protected int maxKeepAliveRequests = -1;
    protected SSLSupport sslSupport;
    protected Socket socket;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int timeout = 300000;
    static /* synthetic */ Class class$org$apache$coyote$http11$Http11Processor;

    public Http11Processor() {
        this.request.setInputBuffer((InputBuffer)this.inputBuffer);
        this.response = new Response();
        this.response.setHook((ActionHook)this);
        this.outputBuffer = new InternalOutputBuffer(this.response);
        this.response.setOutputBuffer((OutputBuffer)this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
    }

    public void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRestrictedUserAgent(String userAgent) {
        if (this.restrictedUserAgents == null) {
            this.restrictedUserAgents = new String[0];
        }
        String[] results = new String[this.restrictedUserAgents.length + 1];
        int i = 0;
        while (i < this.restrictedUserAgents.length) {
            results[i] = this.restrictedUserAgents[i];
            ++i;
        }
        results[this.restrictedUserAgents.length] = userAgent;
        this.restrictedUserAgents = results;
    }

    public void setRestrictedUserAgents(String[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String[] findRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void process(InputStream input, OutputStream output) throws IOException {
        this.remoteAddr = this.socket.getInetAddress().getHostAddress();
        this.request.remoteAddr().setString(this.remoteAddr);
        this.remoteHost = null;
        this.inputBuffer.setInputStream(input);
        this.outputBuffer.setOutputStream(output);
        this.error = false;
        this.keepAlive = true;
        int keepAliveLeft = this.maxKeepAliveRequests;
        int soTimeout = this.socket.getSoTimeout();
        boolean keptAlive = false;
        this.socket.setSoTimeout(this.timeout);
        while (this.started && !this.error && this.keepAlive) {
            try {
                if (keptAlive && soTimeout > 0) {
                    this.socket.setSoTimeout(soTimeout);
                }
                this.inputBuffer.parseRequestLine();
                keptAlive = true;
                this.socket.setSoTimeout(this.timeout);
                this.inputBuffer.parseHeaders();
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Exception e) {
                log.warn((Object)"Error parsing HTTP request", (Throwable)e);
                this.response.setStatus(400);
                this.error = true;
            }
            this.prepareRequest();
            if (this.maxKeepAliveRequests > 0 && --keepAliveLeft == 0) {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    log.error((Object)"Error processing request", t);
                    this.response.setStatus(500);
                    this.error = true;
                }
            }
            try {
                this.inputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                log.error((Object)"Error finishing request", t);
                this.response.setStatus(500);
                this.error = true;
            }
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                log.error((Object)"Error finishing response", t);
                this.error = true;
            }
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
        }
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.sslSupport = null;
    }

    public void action(ActionCode actionCode, Object param) {
        block37: {
            if (actionCode == ActionCode.ACTION_COMMIT) {
                if (this.response.isCommitted()) {
                    return;
                }
                this.prepareResponse();
                try {
                    this.outputBuffer.commit();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_ACK) {
                if (this.response.isCommitted()) {
                    return;
                }
                MessageBytes expectMB = this.request.getMimeHeaders().getValue("expect");
                if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
                    try {
                        this.outputBuffer.sendAck();
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                }
            } else if (actionCode == ActionCode.ACTION_CLOSE) {
                try {
                    this.outputBuffer.endRequest();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_RESET) {
                this.outputBuffer.reset();
            } else if (actionCode != ActionCode.ACTION_CUSTOM) {
                if (actionCode == ActionCode.ACTION_START) {
                    this.started = true;
                } else if (actionCode == ActionCode.ACTION_STOP) {
                    this.started = false;
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    try {
                        if (this.sslSupport == null) break block37;
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception getting SSL attributes ", (Throwable)e);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    this.request.remoteAddr().setString(this.remoteAddr);
                    if (this.remoteHost == null) {
                        this.remoteHost = this.socket.getInetAddress().getHostName();
                    }
                    this.request.remoteHost().setString(this.remoteHost);
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                    try {
                        Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", (Object)sslO);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception getting SSL Cert", (Throwable)e);
                    }
                }
            }
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
        }
        MessageBytes methodMB = this.request.method();
        MessageBytes connectionValueMB = this.request.getMimeHeaders().getValue("connection");
        if (connectionValueMB != null) {
            String connectionValue = connectionValueMB.toString().toLowerCase().trim();
            if (connectionValue.equals("close")) {
                this.keepAlive = false;
            } else if (connectionValue.equals("keep-alive")) {
                this.keepAlive = true;
            }
        }
        MessageBytes userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent");
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive)) {
            String userAgentValue = userAgentValueMB.toString();
            int i = 0;
            while (i < this.restrictedUserAgents.length) {
                if (this.restrictedUserAgents[i].equals(userAgentValue)) {
                    this.http11 = false;
                    this.keepAlive = false;
                }
                ++i;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = this.request.getMimeHeaders().setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        int contentLength = this.request.getContentLength();
        if (contentLength >= 0) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = this.request.getMimeHeaders().getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase().trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase().trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation && this.keepAlive) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
        if (!this.contentDelimitation) {
            this.keepAlive = false;
        }
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getLocalPort());
            InetAddress localAddress = this.socket.getLocalAddress();
            this.request.setLocalHost(localAddress.getHostName());
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        int i = 0;
        while (i < valueL) {
            char b = (char)valueB[i + valueS];
            if (b == ':') {
                colonPos = i;
                break;
            }
            ++i;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setBytes(valueB, valueS, valueL);
        } else {
            this.request.serverName().setBytes(valueB, valueS, colonPos);
            int port = 0;
            int mult = 1;
            int i2 = valueL - 1;
            while (i2 > colonPos) {
                int charValue = HexUtils.DEC[valueB[i2 + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
                --i2;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() {
        int contentLength;
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
        }
        if ((contentLength = this.response.getContentLength()) != -1) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            this.response.addHeader("Transfer-Encoding", "chunked");
        }
        this.response.addHeader("Date", FastHttpDateFormat.getCurrentDate());
        this.response.addHeader("Server", "Apache Coyote/1.0");
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        if (!this.keepAlive) {
            this.response.addHeader("Connection", "close");
        }
        this.outputBuffer.sendStatus();
        MimeHeaders headers = this.response.getMimeHeaders();
        int size = headers.size();
        int i = 0;
        while (i < size) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
            ++i;
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                int i = 2;
                while (i < inputFilters.length) {
                    if (inputFilters[i].getEncodingName().toString().equals(encodingName)) {
                        this.inputBuffer.addActiveFilter(inputFilters[i]);
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

