/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scfimpl;

import com.sun.smartcard.Card;
import com.sun.smartcard.PassThruCardService;
import com.sun.smartcard.SmartcardCardLockedException;
import com.sun.smartcard.SmartcardDoubleLockException;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.SmartcardInvalidCardHandleException;
import com.sun.smartcard.SmartcardTimeoutException;
import com.sun.smartcard.scf.CardLockedException;
import com.sun.smartcard.scf.CardRemovedException;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.DoubleLockException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.TimeoutException;
import com.sun.smartcard.scf.spi.CardProvider;
import com.sun.smartcard.scfimpl.OCFExceptionHandler;
import com.sun.smartcard.util.HexString;

class OCFCardProvider
implements CardProvider {
    private Card ocfCard;
    private PassThruCardService ocfPassThruService;

    OCFCardProvider() {
    }

    void init(Card card) {
        this.ocfCard = card;
        this.ocfPassThruService = new PassThruCardService(card);
    }

    public byte[] getATR() throws InvalidStateException, CommException, InternalException, CardRemovedException {
        try {
            return HexString.hexToBytes(this.ocfCard.getATR());
        }
        catch (SmartcardException smartcardException) {
            this.processException(smartcardException);
            return null;
        }
    }

    public String getCardType() throws InvalidStateException, CommException, InternalException, CardRemovedException {
        try {
            return this.ocfCard.getCardType();
        }
        catch (SmartcardException smartcardException) {
            this.processException(smartcardException);
            return null;
        }
    }

    public void lock(int n) throws InvalidStateException, CommException, InternalException, TimeoutException, CardRemovedException, DoubleLockException {
        try {
            this.ocfCard.lock(n);
        }
        catch (SmartcardTimeoutException smartcardTimeoutException) {
            throw new TimeoutException();
        }
        catch (SmartcardDoubleLockException smartcardDoubleLockException) {
            throw new DoubleLockException();
        }
        catch (SmartcardException smartcardException) {
            this.processException(smartcardException);
        }
    }

    public void unlock() throws InvalidStateException, CommException, InternalException, CardLockedException, CardRemovedException {
        try {
            this.ocfCard.unlock();
        }
        catch (SmartcardCardLockedException smartcardCardLockedException) {
            throw new CardLockedException();
        }
        catch (SmartcardException smartcardException) {
            this.processException(smartcardException);
        }
    }

    public byte[] exchangeAPDU(byte[] byArray) throws InvalidStateException, CommException, InternalException, CardLockedException, CardRemovedException {
        try {
            return this.ocfPassThruService.sendCommandAPDU(byArray);
        }
        catch (SmartcardCardLockedException smartcardCardLockedException) {
            throw new CardLockedException();
        }
        catch (SmartcardException smartcardException) {
            this.processException(smartcardException);
            return null;
        }
    }

    public void waitForCardRemoved() throws InvalidStateException, CommException, InternalException {
        try {
            this.ocfCard.waitForCardRemoved();
        }
        catch (SmartcardException smartcardException) {
            try {
                this.processException(smartcardException);
            }
            catch (CardRemovedException cardRemovedException) {
                // empty catch block
            }
        }
    }

    public void reset() throws InvalidStateException, CommException, InternalException, CardRemovedException {
        try {
            this.ocfCard.reset();
        }
        catch (SmartcardException smartcardException) {
            this.processException(smartcardException);
        }
    }

    public void waitForCardReset() throws InvalidStateException, CommException, InternalException, CardRemovedException {
        try {
            this.ocfCard.waitForCardReset();
        }
        catch (SmartcardException smartcardException) {
            this.processException(smartcardException);
        }
    }

    private void processException(SmartcardException smartcardException) throws InvalidStateException, CommException, InternalException, CardRemovedException {
        if (smartcardException instanceof SmartcardInvalidCardHandleException) {
            throw new CardRemovedException();
        }
        OCFExceptionHandler.convertCommonOCFException(smartcardException);
    }
}

