/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.TimeoutSpec;
import com.sun.smartcard.UserInfo;
import java.util.Vector;

public class UserInfoCardService {
    OCFClientSocket server = new OCFClientSocket();
    Card card;

    public UserInfoCardService(Card card) throws SmartcardException {
        this.card = card;
    }

    public UserInfo getUserInfo(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("CardService", "UserInfoCardService", "getUserInfo", string2);
        Vector vector2 = OCFDecoder.decode(string3);
        if (vector2 == null || vector2.size() < 2) {
            return null;
        }
        return new UserInfo((String)vector2.elementAt(0), (String)vector2.elementAt(1));
    }

    public String getUserPassword(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("CardService", "UserInfoCardService", "getUserPassword", string2);
        Vector vector2 = OCFDecoder.decode(string3);
        return (String)vector2.elementAt(1);
    }

    public void setUserInfo(UserInfo userInfo) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(userInfo.getType());
        vector.add(userInfo.getName());
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("CardService", "UserInfoCardService", "setUserInfo", string);
        OCFDecoder.decode(string2);
    }

    public void setUserPassword(String string, String string2) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        vector.add(string2);
        String string3 = OCFEncoder.encode(vector);
        String string4 = this.server.serverResponse("CardService", "UserInfoCardService", "setUserPassword", string3);
        OCFDecoder.decode(string4);
    }

    public void deleteUserInfo(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("CardService", "UserInfoCardService", "deleteUserInfo", string2);
        OCFDecoder.decode(string3);
    }

    public static void main(String[] stringArray) {
        Smartcard smartcard = null;
        try {
            smartcard = new Smartcard("client1");
            Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(), new AIDSpec(), new TimeoutSpec());
            System.out.println("Card inserted: " + card);
            UserInfoCardService userInfoCardService = (UserInfoCardService)card.getCardService("com.sun.smartcard.UserInfoCardService");
            UserInfo userInfo = userInfoCardService.getUserInfo("AAA");
            System.out.println("User Info: ");
            System.out.println("\tType: " + userInfo.getType());
            System.out.println("\tUser: " + userInfo.getName());
            System.out.println("User password = " + userInfoCardService.getUserPassword("AAA"));
            userInfoCardService.setUserInfo(new UserInfo("dtlogin", "aravind"));
            userInfoCardService.setUserPassword("dtlogin", "123test");
            userInfo = userInfoCardService.getUserInfo("dtlogin");
            System.out.println("User Info: ");
            System.out.println("\tType: " + userInfo.getType());
            System.out.println("\tUser: " + userInfo.getName());
            System.out.println("User dtlogin password = " + userInfoCardService.getUserPassword("dtlogin"));
            userInfoCardService.deleteUserInfo("dtlogin");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (smartcard != null) {
            smartcard.cleanup();
        }
    }
}

